/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import junitx.framework.TestAccessException;
import junitx.framework.TestedClass;

public abstract class TestProxy {
    private TestedClass _testedClass;

    public void init(TestedClass testedClass) {
        this._testedClass = testedClass;
    }

    public TestedClass getProxiedClass() {
        return this._testedClass;
    }

    public String getTestedClassName() {
        return this.getProxiedClass().getTestedClass().getName();
    }

    private Object invokeMethod(Object object, Method method, Object[] objectArray) throws TestAccessException {
        boolean bl = false;
        Object object2 = null;
        try {
            bl = method.isAccessible();
            ((AccessibleObject)method).setAccessible(true);
            object2 = method.invoke(object, objectArray);
            ((AccessibleObject)method).setAccessible(bl);
        }
        catch (Exception exception) {
            throw new TestAccessException("could not invoke", object, method.getName(), "", exception);
        }
        return object2;
    }

    private Object invokeConstructor(Constructor constructor, Object[] objectArray) throws TestAccessException {
        boolean bl = false;
        Object var4_4 = null;
        try {
            bl = constructor.isAccessible();
            ((AccessibleObject)constructor).setAccessible(true);
            var4_4 = constructor.newInstance(objectArray);
            ((AccessibleObject)constructor).setAccessible(bl);
        }
        catch (Exception exception) {
            throw new TestAccessException("could not invoke constructor for " + this.getTestedClassName(), exception);
        }
        return var4_4;
    }

    public Object invoke(Object object, String string, Object[] objectArray) throws TestAccessException {
        return this.invokeMethod(object, this.getProxiedClass().getMethod(string, objectArray), objectArray);
    }

    public abstract Object newInstance(Object[] var1) throws TestAccessException;

    public Object invokeWithKey(Object object, String string, Object[] objectArray) throws TestAccessException {
        Method method = null;
        method = this.getProxiedClass().getMethod(string);
        if (method == null) {
            throw new TestAccessException("could not find method with key " + string);
        }
        return this.invokeMethod(object, method, objectArray);
    }

    public abstract Object newInstanceWithKey(String var1, Object[] var2) throws TestAccessException;

    public Object get(Object object, String string) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(string);
            Object object2 = null;
            boolean bl = field.isAccessible();
            ((AccessibleObject)field).setAccessible(true);
            object2 = field.get(object);
            ((AccessibleObject)field).setAccessible(bl);
            return object2;
        }
        catch (Exception exception) {
            throw new TestAccessException("could not access field", object, string, "", exception);
        }
    }

    public boolean getBoolean(Object object, String string) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(string);
            boolean bl = false;
            boolean bl2 = field.isAccessible();
            ((AccessibleObject)field).setAccessible(true);
            bl = field.getBoolean(object);
            ((AccessibleObject)field).setAccessible(bl2);
            return bl;
        }
        catch (Exception exception) {
            throw new TestAccessException("could not access field", object, string, "", exception);
        }
    }

    public byte getByte(Object object, String string) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(string);
            byte by = 0;
            boolean bl = field.isAccessible();
            ((AccessibleObject)field).setAccessible(true);
            by = field.getByte(object);
            ((AccessibleObject)field).setAccessible(bl);
            return by;
        }
        catch (Exception exception) {
            throw new TestAccessException("could not access field", object, string, "", exception);
        }
    }

    public char getChar(Object object, String string) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(string);
            char c = ' ';
            boolean bl = field.isAccessible();
            ((AccessibleObject)field).setAccessible(true);
            c = field.getChar(object);
            ((AccessibleObject)field).setAccessible(bl);
            return c;
        }
        catch (Exception exception) {
            throw new TestAccessException("could not access field", object, string, "", exception);
        }
    }

    public double getDouble(Object object, String string) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(string);
            double d = 0.0;
            boolean bl = field.isAccessible();
            ((AccessibleObject)field).setAccessible(true);
            d = field.getDouble(object);
            ((AccessibleObject)field).setAccessible(bl);
            return d;
        }
        catch (Exception exception) {
            throw new TestAccessException("could not access field", object, string, "", exception);
        }
    }

    public float getFloat(Object object, String string) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(string);
            float f = 0.0f;
            boolean bl = field.isAccessible();
            ((AccessibleObject)field).setAccessible(true);
            f = field.getFloat(object);
            ((AccessibleObject)field).setAccessible(bl);
            return f;
        }
        catch (Exception exception) {
            throw new TestAccessException("could not access field", object, string, "", exception);
        }
    }

    public int getInt(Object object, String string) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(string);
            int n = 0;
            boolean bl = field.isAccessible();
            ((AccessibleObject)field).setAccessible(true);
            n = field.getInt(object);
            ((AccessibleObject)field).setAccessible(bl);
            return n;
        }
        catch (Exception exception) {
            throw new TestAccessException("could not access field", object, string, "", exception);
        }
    }

    public long getLong(Object object, String string) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(string);
            long l = 0L;
            boolean bl = field.isAccessible();
            ((AccessibleObject)field).setAccessible(true);
            l = field.getLong(object);
            ((AccessibleObject)field).setAccessible(bl);
            return l;
        }
        catch (Exception exception) {
            throw new TestAccessException("could not access field", object, string, "", exception);
        }
    }

    public short getShort(Object object, String string) throws TestAccessException {
        try {
            Field field = this.getProxiedClass().getField(string);
            short s = 0;
            boolean bl = field.isAccessible();
            ((AccessibleObject)field).setAccessible(true);
            s = field.getShort(object);
            ((AccessibleObject)field).setAccessible(bl);
            return s;
        }
        catch (Exception exception) {
            throw new TestAccessException("could not access field", object, string, "", exception);
        }
    }

    public void dumpKeys() {
        this.getProxiedClass().dumpKeys();
    }
}

