/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLErrorMessage
extends Exception
implements IXMLEncodable {
    public static final int ERR_OK = 0;
    public static final int ERR_INTERNAL_SERVER_ERROR = 1;
    public static final int ERR_WRONG_FORMAT = 2;
    public static final int ERR_WRONG_DATA = 3;
    public static final int ERR_KEY_NOT_FOUND = 4;
    public static final int ERR_BAD_SIGNATURE = 5;
    public static final int ERR_BAD_REQUEST = 6;
    public static final int ERR_NO_ACCOUNTCERT = 7;
    public static final int ERR_NO_BALANCE = 8;
    public static final int ERR_NO_CONFIRMATION = 9;
    public static final int ERR_ACCOUNT_EMPTY = 10;
    public static final int ERR_CASCADE_LENGTH = 11;
    public static final int ERR_DATABASE_ERROR = 12;
    public static final int ERR_INSUFFICIENT_BALANCE = 13;
    public static final int ERR_NO_FLATRATE_OFFERED = 14;
    public static final int ERR_INVALID_CODE = 15;
    public static final int ERR_OUTDATED_CC = 16;
    public static final int ERR_INVALID_PRICE_CERTS = 17;
    public static final int ERR_MULTIPLE_LOGIN = 18;
    public static final int ERR_NO_RECORD_FOUND = 19;
    public static final int ERR_SUCCESS_BUT_WITH_ERRORS = 20;
    public static final int ERR_BLOCKED = 21;
    private int m_iErrorCode;
    private String m_strErrMsg;
    private IXMLEncodable m_oMessageObject;
    private static final String[] m_errStrings = new String[]{"Success", "Internal Server Error", "Wrong format", "Wrong Data", "Key not found", "Bad Signature", "Bad request", "No account certificate", "No balance", "No cost confirmation", "Account is empty", "Cascade too long", "Database error", "Insufficient balance", "No flatrate offered", "Invalid code", "outdated CC", "Invalid price certificates", "multiple login is not allowed", "no record found", "operation succeeded, but there were errors", "this account is blocked"};
    private static final String[] m_messageObjectTypes = new String[]{"none", "none", "none", "none", "none", "none", "none", "none", "none", "none", "XMLGenericText", "none", "none", "none", "none", "none", "XMLEasyCC", "none", "none", "none", "none", "none"};
    public static final String XML_ELEMENT_NAME = "ErrorMessage";

    public XMLErrorMessage(Document document) throws Exception {
        Element element = document.getDocumentElement();
        this.setValues(element);
    }

    public XMLErrorMessage(Element element) throws Exception {
        this.setValues(element);
    }

    public XMLErrorMessage(int n, String string) {
        this.m_iErrorCode = n;
        this.m_strErrMsg = string;
    }

    public XMLErrorMessage(int n, String string, IXMLEncodable iXMLEncodable) {
        this.m_iErrorCode = n;
        this.m_strErrMsg = string;
        this.m_oMessageObject = iXMLEncodable;
    }

    public XMLErrorMessage(int n) {
        this.m_iErrorCode = n;
        this.m_strErrMsg = this.m_iErrorCode < 0 || this.m_iErrorCode > m_errStrings.length ? "Unknown Message" : m_errStrings[n];
    }

    public Element toXmlElement(Document document) {
        Element element = document.createElement(XML_ELEMENT_NAME);
        element.setAttribute("code", Integer.toString(this.m_iErrorCode));
        XMLUtil.setValue((Node)element, this.m_strErrMsg);
        if (this.m_oMessageObject != null) {
            Element element2 = document.createElement("MessageObject");
            Element element3 = this.m_oMessageObject.toXmlElement(document);
            element2.appendChild(element3);
            element.appendChild(element2);
        }
        return element;
    }

    public String getErrorDescription() {
        return this.m_strErrMsg;
    }

    public int getErrorCode() {
        return this.m_iErrorCode;
    }

    public String getMessage() {
        return this.m_strErrMsg;
    }

    public IXMLEncodable getMessageObject() {
        return this.m_oMessageObject;
    }

    public Class getMessageObjectType() {
        String string = m_messageObjectTypes[this.m_iErrorCode];
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public void setMessageObject(IXMLEncodable iXMLEncodable) {
        this.m_oMessageObject = iXMLEncodable;
    }

    private void setValues(Element element) throws Exception {
        if (!element.getTagName().equals(XML_ELEMENT_NAME)) {
            throw new Exception("Format error: Root element wrong tagname");
        }
        this.m_iErrorCode = Integer.parseInt(element.getAttribute("code"));
        this.m_strErrMsg = XMLUtil.parseValue((Node)element, "");
        String string = m_messageObjectTypes[this.m_iErrorCode];
    }
}

