/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import gui.TitledGridBagPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import logging.LogHolder;
import logging.LogType;
import mixconfig.panels.MixConfigPanel;
import mixconfig.tools.EmailComposer;

public class WizardFinishPanel
extends MixConfigPanel
implements ActionListener {
    private String[] options = new String[]{"- Click the 'Finish' button to save the configuration and quit this wizard.", "- Click the 'Back' button if you want to make changes before saving.", "- Click the 'Cancel' button to quit without saving."};

    public WizardFinishPanel() {
        super("Finish");
        GridBagConstraints c = this.getInitialConstraints();
        c.weightx = 0.0;
        c.anchor = 10;
        this.add((Component)new JLabel("Congratulations, your mix configuration is now complete!"), c);
        TitledGridBagPanel panelMessage = new TitledGridBagPanel();
        panelMessage.removeInsets();
        for (int i = 0; i < this.options.length; ++i) {
            panelMessage.addRow(new JLabel(this.options[i]), null);
        }
        ++c.gridy;
        this.add((Component)panelMessage, c);
        JButton buttonEmail = new JButton("Click here to send certificates to JonDos");
        buttonEmail.setActionCommand("email");
        buttonEmail.addActionListener(this);
        c.fill = 0;
        ++c.gridy;
        this.add((Component)buttonEmail, c);
    }

    @Override
    public Vector<String> check() {
        return null;
    }

    @Override
    protected void enableComponents() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("email")) {
            try {
                LogHolder.log(7, LogType.MISC, "Composing email ..");
                EmailComposer.composeEmail();
            }
            catch (URISyntaxException use) {
                LogHolder.log(7, LogType.MISC, "Error while composing email: " + use.getMessage());
            }
            catch (IOException ioe) {
                LogHolder.log(7, LogType.MISC, "Error while composing email: " + ioe.getMessage());
            }
        }
    }

    @Override
    public String getHelpContext() {
        return "index";
    }

    @Override
    public Container getHelpExtractionDisplayContext() {
        return null;
    }
}

