/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import anon.crypto.JAPCertificate;
import gui.JAPJIntField;
import gui.MixConfigTextField;
import gui.TitledGridBagPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import logging.LogHolder;
import logging.LogType;
import mixconfig.ConfigurationEvent;
import mixconfig.MixConfiguration;
import mixconfig.panels.CertPanel;
import mixconfig.panels.MixConfigPanel;
import mixconfig.panels.PriceCertPanel;

public class PaymentPanel
extends MixConfigPanel
implements ChangeListener {
    public static final String XMLPATH_ACCOUNTING = "Accounting";
    public static final String XMLPATH_SOFTLIMIT = "Accounting/SoftLimit";
    public static final String XMLPATH_HARDLIMIT = "Accounting/HardLimit";
    public static final String XMLPATH_PREPAIDINTERVAL = "Accounting/PrepaidInterval";
    public static final String XMLPATH_SETTLEINTERVAL = "Accounting/SettleInterval";
    public static final String XMLPATH_PAYMENT_INSTANCE = "Accounting/PaymentInstance";
    public static final String XMLPATH_PI_HOST = "Accounting/PaymentInstance/Network/ListenerInterfaces/ListenerInterface/Host";
    public static final String XMLPATH_PI_PORT = "Accounting/PaymentInstance/Network/ListenerInterfaces/ListenerInterface/Port";
    public static final String XMLPATH_PI_CERT = "Accounting/PaymentInstance/Certificate";
    public static final String XMLPATH_PRICE_CERT = "Accounting/PriceCertificate";
    public static final String XMLPATH_DATABASE = "Accounting/Database";
    public static final String XMLPATH_DATABASE_HOST = "Accounting/Database/Host";
    public static final String XMLPATH_DATABASE_PORT = "Accounting/Database/Port";
    public static final String XMLPATH_DATABASE_NAME = "Accounting/Database/DBName";
    public static final String XMLPATH_DATABASE_USERNAME = "Accounting/Database/Username";
    public static final String XMLPATH_DATABASE_PASSWORD = "Accounting/Database/Password";
    public static final String XML_ATTRIBUTE_ID = "id";
    public static final String FILESYSTEM_PATH_PI_CERT = "certificates/Payment_Instance.cer";
    private static final int VISIBLE_PASSWORD_LENGTH = 15;
    private PriceCertPanel m_panelPriceCert;
    private CertPanel m_panelJPICert;
    private TitledGridBagPanel m_panelJPI;
    private MixConfigTextField m_tfJPIHost;
    private JAPJIntField m_tfJPIPort;
    private TitledGridBagPanel m_panelDatabase;
    private MixConfigTextField m_tfDatabaseHost;
    private JAPJIntField m_tfDatabasePort;
    private MixConfigTextField m_tfDatabaseName;
    private MixConfigTextField m_tfDatabaseUsername;
    private JPasswordField m_pwfDatabasePassword;
    private TitledGridBagPanel m_panelGeneral;
    private JAPJIntField m_tfSoftLimit;
    private JAPJIntField m_tfHardLimit;
    private JAPJIntField m_tfPrepaidInterval;
    private JAPJIntField m_tfSettleInterval;

    public PaymentPanel() throws IOException {
        super("Payment");
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = this.getInitialConstraints();
        this.m_panelJPICert = new CertPanel("JPI Certificate", "If you have the public certificate of a running JPI, you can import it here.", (JAPCertificate)null, 2, 7);
        this.m_panelJPICert.setName(XMLPATH_PI_CERT);
        this.m_panelJPICert.addChangeListener(this);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.m_panelJPICert, c);
        this.m_panelJPI = new TitledGridBagPanel("JPI (Java Payment Instance)");
        this.m_panelJPI.setToolTipText("<html>Please enter the hostname or IP-address and port number of the JPI<br/> the mix should use.</html>");
        this.m_tfJPIHost = new MixConfigTextField();
        this.m_tfJPIHost.setName(XMLPATH_PI_HOST);
        this.m_tfJPIHost.addFocusListener(this);
        this.m_panelJPI.addRow(new JLabel("JPI Hostname:"), this.m_tfJPIHost);
        this.m_tfJPIPort = new JAPJIntField(65535);
        this.m_tfJPIPort.setName(XMLPATH_PI_PORT);
        this.m_tfJPIPort.addFocusListener(this);
        this.m_panelJPI.addRow(new JLabel("JPI Portnumber:"), this.m_tfJPIPort);
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)this.m_panelJPI, c);
        this.m_panelGeneral = new TitledGridBagPanel("General Settings");
        this.m_panelGeneral.setToolTipText("General settings concerning the payment system");
        JLabel label = new JLabel("Soft Limit (bytes)");
        label.setToolTipText("<html>This is the soft limit for the number of bytes a Jap can use before <br/>sending a cost confirmation</html>");
        this.m_tfSoftLimit = new JAPJIntField(new JAPJIntField.IntFieldWithoutZeroBounds(-1));
        this.m_tfSoftLimit.setName(XMLPATH_SOFTLIMIT);
        this.m_tfSoftLimit.addFocusListener(this);
        this.m_panelGeneral.addRow(label, this.m_tfSoftLimit);
        label = new JLabel("Hard Limit (bytes)");
        label.setToolTipText("<html>This is the hard limit for the number of bytes a JAP can use without <br/>sending a cost confirmation, before he will be kicked.</html>");
        this.m_tfHardLimit = new JAPJIntField(new JAPJIntField.IntFieldWithoutZeroBounds(-1));
        this.m_tfHardLimit.setName(XMLPATH_HARDLIMIT);
        this.m_tfHardLimit.addFocusListener(this);
        this.m_panelGeneral.addRow(label, this.m_tfHardLimit);
        label = new JLabel("Prepaid Interval (bytes)");
        label.setToolTipText("<html>The prepaid interval is given in bytes</html>");
        this.m_tfPrepaidInterval = new JAPJIntField(new JAPJIntField.IntFieldWithoutZeroBounds(-1));
        this.m_tfPrepaidInterval.setName(XMLPATH_PREPAIDINTERVAL);
        this.m_tfPrepaidInterval.addFocusListener(this);
        this.m_panelGeneral.addRow(label, this.m_tfPrepaidInterval);
        label = new JLabel("Settle Interval (s)");
        label.setToolTipText("<html>This is the interval in seconds that the SettleThread will sleep beforeeach<br/> cycle of transmitting all the open cost confirmations to the PI</html>");
        this.m_tfSettleInterval = new JAPJIntField(new JAPJIntField.IntFieldWithoutZeroBounds(-1));
        this.m_tfSettleInterval.setName(XMLPATH_SETTLEINTERVAL);
        this.m_tfSettleInterval.addFocusListener(this);
        this.m_panelGeneral.addRow(label, this.m_tfSettleInterval);
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)this.m_panelGeneral, c);
        this.m_panelPriceCert = new PriceCertPanel("Price Certificate", "Import the price certificate here", null);
        this.m_panelPriceCert.setName(XMLPATH_PRICE_CERT);
        this.m_panelPriceCert.addChangeListener(this);
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 0;
        this.add((Component)this.m_panelPriceCert, c);
        this.m_panelDatabase = new TitledGridBagPanel("PostgreSQL Database for Accounting");
        this.m_panelDatabase.setToolTipText("<html>The accounting instance inside a FirstMix needs a PostgreSQL<br/> database to store some internal accounting data. Before you start<br/> the FirstMix with payment enabled, setup a PostgreSQL DB and enter<br/> its connection data here.</html>");
        this.m_tfDatabaseHost = new MixConfigTextField();
        this.m_tfDatabaseHost.setName(XMLPATH_DATABASE_HOST);
        this.m_tfDatabaseHost.addFocusListener(this);
        this.m_panelDatabase.addRow(new JLabel("Database Hostname:"), this.m_tfDatabaseHost);
        this.m_tfDatabasePort = new JAPJIntField(65535);
        this.m_tfDatabasePort.setName(XMLPATH_DATABASE_PORT);
        this.m_tfDatabasePort.addFocusListener(this);
        this.m_panelDatabase.addRow((Component)new JLabel("Database Portnumber:"), (Component)this.m_tfDatabasePort, 0);
        this.m_tfDatabaseName = new MixConfigTextField();
        this.m_tfDatabaseName.setName(XMLPATH_DATABASE_NAME);
        this.m_tfDatabaseName.addFocusListener(this);
        this.m_panelDatabase.addRow(new JLabel("Database Name:"), this.m_tfDatabaseName);
        this.m_tfDatabaseUsername = new MixConfigTextField();
        this.m_tfDatabaseUsername.setName(XMLPATH_DATABASE_USERNAME);
        this.m_tfDatabaseUsername.addFocusListener(this);
        this.m_panelDatabase.addRow(new JLabel("Database Username:"), this.m_tfDatabaseUsername);
        this.m_pwfDatabasePassword = new JPasswordField(15);
        this.m_pwfDatabasePassword.setName(XMLPATH_DATABASE_PASSWORD);
        this.m_pwfDatabasePassword.addFocusListener(this);
        JTextField m_txtHashedPassword = new JTextField(15);
        m_txtHashedPassword.setEditable(false);
        this.m_panelDatabase.addRow(new JLabel("Database Password:"), this.m_pwfDatabasePassword);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 1;
        c.gridheight = 2;
        this.add((Component)this.m_panelDatabase, c);
        c.gridheight = 1;
        c.fill = 1;
        c.gridy = 3;
        c.weighty = 1.0;
        this.add((Component)new JLabel(), c);
        this.setEnabled(true);
    }

    private boolean isPaymentEnabled() {
        boolean ret = false;
        String sEnablePayment = this.getConfiguration().getAttributeValue("General/MixType", "payment");
        if (sEnablePayment != null && sEnablePayment.equalsIgnoreCase("true")) {
            ret = true;
        }
        return ret;
    }

    @Override
    protected void enableComponents() {
        int i;
        boolean compEnabled = true;
        this.m_panelPriceCert.setEnabled(compEnabled);
        this.m_panelJPICert.setEnabled(compEnabled);
        this.m_panelGeneral.setEnabled(compEnabled);
        Component[] components = this.m_panelGeneral.getComponents();
        for (i = 0; i < components.length; ++i) {
            components[i].setEnabled(compEnabled);
        }
        this.m_panelJPI.setEnabled(compEnabled);
        components = this.m_panelJPI.getComponents();
        for (i = 0; i < components.length; ++i) {
            components[i].setEnabled(compEnabled);
        }
        if (this.getConfiguration() != null && this.getConfiguration().getMixType() != 1) {
            compEnabled = false;
        }
        this.m_panelDatabase.setEnabled(compEnabled);
        components = this.m_panelDatabase.getComponents();
        for (i = 0; i < components.length; ++i) {
            components[i].setEnabled(compEnabled);
        }
    }

    @Override
    public void setConfiguration(MixConfiguration a_conf) throws IOException {
        this.enableComponents();
        super.setConfiguration(a_conf);
        a_conf.removeChangeListener(this);
        a_conf.addChangeListener(this);
        this.setAutoSaveEnabled(false);
        this.setEnabled(this.isPaymentEnabled());
        this.enableComponents();
        this.setAutoSaveEnabled(true);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            ConfigurationEvent c;
            if (e instanceof ConfigurationEvent && (c = (ConfigurationEvent)e).getModifiedXMLPath().equals("General/MixType")) {
                if (this.isPaymentEnabled() && !this.getConfiguration().isAccountingNodePresent()) {
                    this.getConfiguration().addAccounting();
                    this.load();
                }
                this.setEnabled(this.isPaymentEnabled());
                this.enableComponents();
            }
            if (e.getSource() instanceof CertPanel) {
                CertPanel panel = (CertPanel)e.getSource();
                this.save(panel);
                JAPCertificate cert = (JAPCertificate)panel.getCert();
                if (cert != null) {
                    String ski = cert.getSubjectKeyIdentifierConcatenated();
                    if (ski != null) {
                        this.getConfiguration().setAttribute(XMLPATH_PAYMENT_INSTANCE, XML_ATTRIBUTE_ID, ski);
                    }
                } else {
                    try {
                        this.getConfiguration().removeAttribute(XMLPATH_PAYMENT_INSTANCE, XML_ATTRIBUTE_ID);
                    }
                    catch (Exception a_e) {
                        LogHolder.log(4, LogType.GUI, a_e);
                    }
                }
            } else if (e.getSource() instanceof PriceCertPanel) {
                this.save((PriceCertPanel)e.getSource());
            }
        }
        catch (IOException ioe) {
            LogHolder.log(3, LogType.PAY, "Error: " + ioe.getMessage());
        }
    }

    @Override
    public String getHelpContext() {
        return PaymentPanel.class.getName();
    }

    @Override
    public Vector<String> check() {
        Vector<String> errors = new Vector<String>();
        MixConfiguration mixConf = this.getConfiguration();
        String value = mixConf.getValue(XMLPATH_PI_CERT);
        if (value == null) {
            errors.add("The JPI certificate is required!");
        }
        if ((value = mixConf.getValue(XMLPATH_PRICE_CERT)) == null) {
            errors.add("The price certificate is required!");
        }
        if ((value = mixConf.getValue(XMLPATH_PREPAIDINTERVAL)) != null && new Integer(value) > 3000000) {
            errors.add("The 'Prepaid Interval' can at most be specified to 3000000 bytes!");
        }
        if ((value = mixConf.getValue(XMLPATH_SETTLEINTERVAL)) != null && new Integer(value) < 1) {
            errors.add("The 'Settle Interval' needs to be specified to at least 1 second!");
        }
        String sPort = mixConf.getValue(XMLPATH_PI_PORT);
        String sHost = mixConf.getValue(XMLPATH_PI_HOST);
        if ((sHost == null || sHost.equals("")) && (sPort == null || sPort.equals(""))) {
            errors.add("You need to specify a JPI hostname and portnumber!");
        } else {
            if (sPort != null && sHost == null) {
                errors.add("You entered a port, but no host for Java Payment Instance!");
            }
            if (sPort == null && sHost != null) {
                errors.add("You entered a host, but no port for Java Payment Instance!");
            }
            if (sHost != null && (sHost.equals("") || sHost.indexOf(" ") != -1)) {
                errors.add("The JPI hostname is invalid!");
            }
        }
        if (this.m_panelDatabase.isEnabled()) {
            value = mixConf.getValue(XMLPATH_DATABASE_HOST);
            if (value == null) {
                errors.add("Database hostname is missing!");
            } else if (value.indexOf(" ") != -1) {
                errors.add("Database hostname is invalid!");
            }
            value = mixConf.getValue(XMLPATH_DATABASE_PORT);
            if (value == null) {
                errors.add("Database portnumber is missing!");
            }
            if ((value = mixConf.getValue(XMLPATH_DATABASE_NAME)) == null) {
                errors.add("Database name is missing!");
            }
            if ((value = mixConf.getValue(XMLPATH_DATABASE_USERNAME)) == null) {
                errors.add("Database username is missing!");
            }
        }
        return errors;
    }

    @Override
    public Container getHelpExtractionDisplayContext() {
        return null;
    }
}

