/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import anon.crypto.CertificateInfoStructure;
import anon.crypto.CertificateStore;
import anon.crypto.ICertificate;
import anon.crypto.IMyPublicKey;
import anon.crypto.JAPCertificate;
import anon.crypto.MyDSAPublicKey;
import anon.crypto.MyRSAPublicKey;
import anon.crypto.PKCS10CertificationRequest;
import anon.crypto.PKCS12;
import anon.crypto.SignatureVerifier;
import anon.util.IMiscPasswordReader;
import anon.util.JAPMessages;
import anon.util.XMLUtil;
import gui.CertDetailsDialog;
import gui.ClipFrame;
import gui.GUIUtils;
import gui.dialog.DialogContentPane;
import gui.dialog.DialogContentPaneOptions;
import gui.dialog.FinishedContentPane;
import gui.dialog.JAPDialog;
import gui.dialog.PasswordContentPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import logging.LogHolder;
import logging.LogType;
import mixconfig.ICertCreationValidator;
import mixconfig.ICertificateView;
import mixconfig.MixConfig;
import mixconfig.MixConfiguration;
import mixconfig.SimpleFileFilter;
import mixconfig.panels.ChooseStorageMethodPane;
import mixconfig.panels.OwnCertificatesPanel;
import mixconfig.tools.CertificateGenerator;
import mixconfig.wizard.CannotContinueException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CertPanel
extends JPanel
implements ActionListener,
ChangeListener {
    public static final int CERT_ALGORITHM_RSA = 1;
    public static final int CERT_ALGORITHM_DSA = 2;
    public static final int CERT_ALGORITHM_BOTH = 3;
    private static final String STRING_ZERO = new String(new char[]{'\u0000'});
    private static CertificateStore m_trustedCertificates;
    private int m_certType = 0;
    public static final String XMLPATH_CERTIFICATES = "Certificates";
    public static final String XMLPATH_CERTIFICATES_PATH_VERIFICATION = "Certificates/MixCertificateVerification";
    public static final String XML_ELEM_TRUSTED_ROOT_CERTS = "TrustedRootCertificates";
    private static final String CERTPATH = "certificates/";
    public static final String CERTPATH_MIX = "certificates/acceptedMixCAs/";
    public static final String CERTPATH_PAYMENT = "certificates/acceptedPaymentInstances/";
    public static final String CERTPATH_TERMS = "certificates/acceptedTaCTemplates/";
    public static final String CERTPATH_INFOSERVICES = "certificates/acceptedInfoServiceCAs/";
    private static final String CERT_VALID = "cert.gif";
    private static final String CERT_INVALID = "certinvalid.gif";
    private static final String CERT_VALID_INACTIVE = "certinactive.gif";
    private static final String CERT_INVALID_INACTIVE = "certinvalidinactive.gif";
    private static final String CERT_DISABLED = "certdisabled.gif";
    private static final String MSG_MANDATORY_ALGO;
    private static final String MSG_CERT_TYPE_UNKNOWN;
    private static final String MSG_CONFIRM_DELETION;
    private static final String MSG_CHOOSE_LOAD_METHOD;
    private static final String MSG_CHOOSE_SAVE_METHOD;
    private static final String MSG_CHOOSE_CERT_TYPE;
    private static final String MSG_NO_PRIVATE_CERT;
    private static Vector<CertPanel> ms_certpanels;
    private static boolean m_autoSign;
    private String m_strChangedCertNotVerifyable;
    private JAPDialog.ILinkedInformation m_linkedInformation;
    private JButton m_bttnCreateCert;
    private JButton m_bttnImportCert;
    private JButton m_bttnExportCert;
    private JButton m_bttnSignCert;
    private JButton m_bttnChangePasswd;
    private JButton m_bttnRemoveCert;
    private JLabel m_certLabel;
    private JLabel m_textCertValidity;
    private JTextPane m_lblSubjectKeyIdentifier;
    private boolean m_bCertIsPKCS12 = false;
    private int m_certAlgorithm;
    private boolean m_bCreateDSACerts;
    private int m_nKeySize = 1024;
    private boolean m_bCertificateSaved = true;
    private ICertificate m_cert;
    private ICertificate m_additionalVerifier;
    private String m_privCertPasswd;
    private String m_name;
    private ICertCreationValidator m_validator;
    private ICertificateView m_certView;
    private Vector<ChangeListener> m_changeListeners = new Vector();

    public CertPanel(String a_name, String a_toolTip, JAPCertificate a_certificate, int a_certAlgorithm, int a_certType) {
        this(a_name, a_toolTip, a_certificate, false, a_certAlgorithm, a_certType, 1024);
    }

    public CertPanel(String a_name, String a_toolTip, PKCS12 a_certificate, int a_certAlgorithm, int a_certType) {
        this(a_name, a_toolTip, a_certificate, true, a_certAlgorithm, a_certType, 1024);
    }

    public CertPanel(String a_name, String a_toolTip, PKCS12 a_certificate, int a_certAlgorithm, int a_certType, int keysize) {
        this(a_name, a_toolTip, a_certificate, true, a_certAlgorithm, a_certType, keysize);
    }

    private CertPanel(String a_name, String a_toolTip, ICertificate a_certificate, boolean a_pkcs12, int a_certAlgorithm, int a_certType, int keysize) {
        ms_certpanels.addElement(this);
        this.m_bCreateDSACerts = true;
        if (a_certAlgorithm == 2) {
            this.m_certAlgorithm = 2;
        } else if (a_certAlgorithm == 1) {
            this.m_certAlgorithm = 1;
            this.m_bCreateDSACerts = false;
        } else {
            this.m_certAlgorithm = 3;
        }
        this.m_bCertIsPKCS12 = a_pkcs12;
        this.m_certType = a_certType;
        this.m_name = a_name;
        this.m_nKeySize = keysize;
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.setBorder(new TitledBorder(this.m_name));
        if (a_toolTip != null) {
            this.setToolTipText(a_toolTip);
        }
        this.m_bttnImportCert = new JButton("Import");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        this.m_bttnImportCert.addActionListener(this);
        layout.setConstraints(this.m_bttnImportCert, constraints);
        this.add(this.m_bttnImportCert);
        this.m_bttnExportCert = new JButton("Export");
        constraints.gridx = 1;
        constraints.gridy = 0;
        this.m_bttnExportCert.addActionListener(this);
        layout.setConstraints(this.m_bttnExportCert, constraints);
        this.add(this.m_bttnExportCert);
        this.m_bttnRemoveCert = new JButton("Remove");
        constraints.gridx = 2;
        constraints.gridy = 0;
        this.m_bttnRemoveCert.addActionListener(this);
        this.m_bttnRemoveCert.setEnabled(false);
        layout.setConstraints(this.m_bttnRemoveCert, constraints);
        this.add(this.m_bttnRemoveCert);
        if (this.m_bCertIsPKCS12) {
            this.m_bttnCreateCert = new JButton("Create");
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.fill = 2;
            this.m_bttnCreateCert.addActionListener(this);
            layout.setConstraints(this.m_bttnCreateCert, constraints);
            this.add(this.m_bttnCreateCert);
            if (a_name.equals("Own Mix Certificate")) {
                this.m_bttnSignCert = new JButton("Sign");
                constraints.gridx = 1;
                this.m_bttnSignCert.addActionListener(this);
                this.add((Component)this.m_bttnSignCert, constraints);
                this.m_bttnChangePasswd = new JButton("Password");
                constraints.gridx = 2;
                this.m_bttnChangePasswd.addActionListener(this);
                this.add((Component)this.m_bttnChangePasswd, constraints);
                constraints.fill = 0;
            } else {
                this.m_bttnChangePasswd = new JButton("Change Password");
                constraints.gridx = 1;
                constraints.gridy = 1;
                constraints.gridwidth = 2;
                constraints.fill = 2;
                this.m_bttnChangePasswd.addActionListener(this);
                layout.setConstraints(this.m_bttnChangePasswd, constraints);
                this.add(this.m_bttnChangePasswd);
                constraints.fill = 0;
            }
        }
        this.m_certLabel = new JLabel(GUIUtils.loadImageIcon(CERT_DISABLED));
        this.m_certLabel.setBorder(null);
        this.m_certLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.m_certLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent a_event) {
                if (CertPanel.this.m_certLabel.isEnabled()) {
                    CertDetailsDialog dialog = new CertDetailsDialog(CertPanel.this.getParent(), CertPanel.this.m_cert.getX509Certificate(), CertPanel.this.isCertificateVerifyable(), null);
                    dialog.pack();
                    dialog.setVisible(true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent a_event) {
                if (CertPanel.this.m_certLabel.isEnabled()) {
                    CertPanel.this.updateCertificateIcon(true);
                }
            }
        });
        constraints.gridy = 2;
        constraints.gridheight = 3;
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        this.add((Component)this.m_certLabel, constraints);
        constraints.gridheight = 2;
        constraints.gridwidth = 3;
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.m_lblSubjectKeyIdentifier = GUIUtils.createSelectableAndResizeableLabel(this);
        this.m_lblSubjectKeyIdentifier.setFont(new Font(this.m_lblSubjectKeyIdentifier.getFont().getName(), 1, 10));
        this.m_lblSubjectKeyIdentifier.setText("00 00 00 00 00 00 00 00 00 00 00 ");
        this.m_lblSubjectKeyIdentifier.setPreferredSize(new Dimension(this.m_lblSubjectKeyIdentifier.getPreferredSize().width, (int)(2.5 * (double)this.m_lblSubjectKeyIdentifier.getFontMetrics(this.m_lblSubjectKeyIdentifier.getFont()).getHeight())));
        this.m_lblSubjectKeyIdentifier.setText("");
        this.m_lblSubjectKeyIdentifier.setToolTipText("SubjectKeyIdentifier");
        this.add((Component)this.m_lblSubjectKeyIdentifier, constraints);
        constraints.insets = new Insets(0, 5, 5, 0);
        constraints.gridx = 1;
        ++constraints.gridy;
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 3;
        this.add((Component)new JLabel(), constraints);
        constraints.weighty = 0.0;
        ++constraints.gridy;
        this.m_textCertValidity = new JLabel();
        this.m_textCertValidity.setToolTipText("Validity");
        this.m_textCertValidity.setPreferredSize(new JLabel("00.00.0000 - 00.00.0000").getPreferredSize());
        this.add((Component)this.m_textCertValidity, constraints);
        constraints.weightx = 0.0;
        this.enableButtons();
        if (a_certificate != null) {
            this.setCert(a_certificate.toByteArray());
        }
    }

    private static void addDefaultCertificates(String sPath, int iType) {
        if (m_trustedCertificates == null) {
            m_trustedCertificates = new CertificateStore();
        }
        LogHolder.log(7, LogType.MISC, "Loading certificates of type '" + iType + "' from '" + sPath + "'");
        Enumeration certificates = JAPCertificate.getInstance(sPath, true).elements();
        JAPCertificate cert = null;
        while (certificates.hasMoreElements()) {
            cert = (JAPCertificate)certificates.nextElement();
            m_trustedCertificates.addCertificateWithoutVerification(cert, iType, true, true);
            SignatureVerifier.getInstance().getVerificationCertificateStore().addCertificateWithoutVerification(cert, iType, true, true);
        }
        if (cert == null) {
            LogHolder.log(4, LogType.MISC, "No certificates of type '" + iType + "'");
        }
    }

    public void setCertCreationValidator(ICertCreationValidator a_cg) {
        this.m_validator = a_cg;
        this.enableButtons();
    }

    public boolean isCertificateSaved() {
        return this.getCert() == null || !this.m_bCertIsPKCS12 || this.m_bCertificateSaved;
    }

    public boolean isCertificateVerifyable() {
        LogHolder.log(7, LogType.CRYPTO, "Verifying certificate: " + this.m_cert.getX509Certificate().getSubjectKeyIdentifier());
        Enumeration certInfoEnum = m_trustedCertificates.getAvailableCertificatesByType(this.m_certType).elements();
        Vector<JAPCertificate> certs = new Vector<JAPCertificate>();
        while (certInfoEnum.hasMoreElements()) {
            certs.add(((CertificateInfoStructure)certInfoEnum.nextElement()).getCertificate());
        }
        if (this.m_additionalVerifier != null && this.m_cert.getX509Certificate().verify(this.m_additionalVerifier.getPublicKey())) {
            return this.m_additionalVerifier.getX509Certificate().verify(certs.elements());
        }
        return this.m_cert.getX509Certificate().verify(certs.elements());
    }

    public void setChangedCertNotVerifyableMessage(String a_strChangedCertNotVerifyable, JAPDialog.ILinkedInformation a_linkedInformation) {
        this.m_strChangedCertNotVerifyable = a_strChangedCertNotVerifyable;
        this.m_linkedInformation = a_linkedInformation;
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof JButton) continue;
            components[i].setEnabled(enabled);
        }
        if (this.getBorder() instanceof TitledBorder) {
            TitledBorder border = new TitledBorder(((TitledBorder)this.getBorder()).getTitle());
            if (!enabled) {
                border.setTitleColor(Color.gray);
            }
            this.setBorder(border);
        }
        super.setEnabled(enabled);
        this.enableButtons();
    }

    public static boolean isAutoSign() {
        return m_autoSign;
    }

    public static void setAutoSign(boolean b_autoSign) {
        m_autoSign = b_autoSign;
    }

    @Override
    public void actionPerformed(ActionEvent a_event) {
        Object source = a_event.getSource();
        try {
            boolean bCertChanged = false;
            if (source == this.m_bttnChangePasswd) {
                this.changePasswd();
            } else if (source == this.m_bttnCreateCert) {
                bCertChanged = this.generateNewCert();
            } else if (source == this.m_bttnExportCert) {
                this.exportCert();
            } else if (source == this.m_bttnSignCert) {
                this.signCert();
            } else if (source == this.m_bttnRemoveCert) {
                if (JAPDialog.showConfirmDialog((Component)this, JAPMessages.getString(MSG_CONFIRM_DELETION), 2, 3) == 0) {
                    this.removeCert();
                }
            } else if (source == this.m_bttnImportCert) {
                bCertChanged = this.m_bCertIsPKCS12 ? this.importPrivCert() : this.importPubCert();
            }
            this.enableButtons();
            if (bCertChanged && !this.isCertificateVerifyable() && this.m_strChangedCertNotVerifyable != null) {
                JAPDialog.showMessageDialog((Component)this, this.m_strChangedCertNotVerifyable, (Icon)GUIUtils.loadImageIcon(CERT_INVALID), this.m_linkedInformation);
            }
        }
        catch (Exception ex) {
            JAPDialog.showErrorDialog((Component)this, (Throwable)ex);
        }
    }

    public char[] getPrivateCertPassword() {
        if (this.m_privCertPasswd == null) {
            return new char[0];
        }
        return this.m_privCertPasswd.toCharArray();
    }

    public ICertificate getCert() {
        return this.m_cert;
    }

    public void setCert(JAPCertificate a_certificate) {
        this.setCert(a_certificate.toByteArray());
    }

    public ICertificateView getCertificateView() {
        return this.m_certView;
    }

    public void setCertificateView(ICertificateView a_certificateView) {
        this.m_certView = a_certificateView;
    }

    public boolean setCert(byte[] cert) throws IllegalArgumentException {
        boolean bChanged;
        JAPCertificate x509cert = JAPCertificate.getInstance(cert);
        if (cert == null) {
            bChanged = this.m_cert != null;
            this.m_cert = null;
            this.clearCertInfo();
        } else if (this.m_bCertIsPKCS12) {
            if (x509cert != null) {
                if (this.m_cert == null) {
                    throw new IllegalArgumentException(JAPMessages.getString(MSG_NO_PRIVATE_CERT));
                }
                bChanged = ((PKCS12)this.m_cert).setX509Certificate(x509cert);
                if (bChanged) {
                    this.setCertInfo(x509cert);
                }
            } else {
                JAPDialog dialog = new JAPDialog(GUIUtils.getParentWindow(this), "Enter the certificate password", true);
                dialog.setResizable(false);
                dialog.setDefaultCloseOperation(1);
                PasswordContentPane pb = new PasswordContentPane(dialog, 2, "Please enter your certificate password.");
                pb.setDefaultButtonOperation(1);
                pb.updateDialog();
                dialog.pack();
                CertPanelPasswordReader pwReader = new CertPanelPasswordReader(pb);
                PKCS12 privateCertificate = null;
                while (privateCertificate == null) {
                    privateCertificate = PKCS12.getInstance(cert, (IMiscPasswordReader)pwReader);
                    if (privateCertificate != null || pb.hasValidValue()) continue;
                    if (pb.getButtonValue() == Integer.MIN_VALUE) {
                        JAPDialog.showErrorDialog((Component)GUIUtils.getParentWindow(this), "Your private certificate was not loaded for some unknown reason! It might be damaged.");
                        break;
                    }
                    int returnValue = JAPDialog.showConfirmDialog((Component)GUIUtils.getParentWindow(this), "Are you sure you want to cancel? Your private certificate will not be loaded!", "Certificate not loaded", 2, 2);
                    if (returnValue != 0) continue;
                    break;
                }
                dialog.dispose();
                bChanged = this.setCertificate(privateCertificate, pwReader.getPassword());
            }
        } else if (x509cert != null) {
            this.checkPublicKeyAlgorithm(x509cert.getPublicKey());
            this.setCertInfo(x509cert);
            this.m_cert = x509cert;
            bChanged = true;
        } else {
            throw new IllegalArgumentException(JAPMessages.getString(MSG_CERT_TYPE_UNKNOWN));
        }
        this.enableButtons();
        CertPanel.setAutoSign(false);
        this.fireStateChanged();
        CertPanel.setAutoSign(true);
        return bChanged;
    }

    public void setAdditionalVerifier(ICertificate a_cert) {
        this.m_additionalVerifier = a_cert;
    }

    public static boolean hasRootCertificates(MixConfiguration a_conf) {
        Node node = XMLUtil.getFirstChildByName(a_conf.getDocument().getDocumentElement(), XMLPATH_CERTIFICATES);
        return (node = XMLUtil.getFirstChildByName(node, XML_ELEM_TRUSTED_ROOT_CERTS)) != null && XMLUtil.getElementsByTagName(node, "X509Certificate").getLength() > 0;
    }

    public static void resetRootCertificates(MixConfiguration a_conf) {
        Vector certificates = SignatureVerifier.getInstance().getVerificationCertificateStore().getAvailableCertificatesByType(1);
        Document doc = a_conf.getDocument();
        Element elem = doc.createElement(XML_ELEM_TRUSTED_ROOT_CERTS);
        for (int i = 0; i < certificates.size(); ++i) {
            elem.appendChild(((CertificateInfoStructure)certificates.elementAt(i)).getCertificate().toXmlElement(doc));
        }
        a_conf.setValue(XMLPATH_CERTIFICATES, elem);
    }

    public void removeCert() {
        this.m_cert = null;
        this.clearCertInfo();
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener a_cl) {
        this.m_changeListeners.addElement(a_cl);
    }

    private void checkPublicKeyAlgorithm(IMyPublicKey a_publicKey) throws IllegalArgumentException {
        if (this.m_certAlgorithm == 3 || this.m_certAlgorithm == 2 && a_publicKey instanceof MyDSAPublicKey || this.m_certAlgorithm == 1 && a_publicKey instanceof MyRSAPublicKey) {
            return;
        }
        if (this.m_certAlgorithm == 2) {
            throw new IllegalArgumentException(JAPMessages.getString(MSG_MANDATORY_ALGO, "DSA"));
        }
        throw new IllegalArgumentException(JAPMessages.getString(MSG_MANDATORY_ALGO, "RSA"));
    }

    private void fireStateChanged() {
        if (this.m_certView != null) {
            this.m_certView.update(this.getCert());
        }
        this.validate();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < this.m_changeListeners.size(); ++i) {
            this.m_changeListeners.elementAt(i).stateChanged(event);
        }
    }

    private boolean setCertificate(PKCS12 pkcs12, char[] strPrivCertPasswd) throws IllegalArgumentException {
        if (pkcs12 == null) {
            return false;
        }
        JAPCertificate x509cs = pkcs12.getX509Certificate();
        this.checkPublicKeyAlgorithm(x509cs.getPublicKey());
        this.setCertInfo(x509cs);
        this.m_cert = pkcs12;
        this.m_privCertPasswd = strPrivCertPasswd != null ? new String(strPrivCertPasswd) : new String();
        if (this.m_privCertPasswd.equals(STRING_ZERO)) {
            this.m_privCertPasswd = new String();
        }
        this.m_bCertificateSaved = true;
        this.enableButtons();
        this.fireStateChanged();
        return true;
    }

    public void updateCertificateIcon(boolean a_bActive) {
        if (this.m_cert != null) {
            boolean bValid = this.isCertificateVerifyable();
            if (a_bActive) {
                if (bValid) {
                    this.m_certLabel.setIcon(GUIUtils.loadImageIcon(CERT_VALID));
                } else {
                    this.m_certLabel.setIcon(GUIUtils.loadImageIcon(CERT_INVALID));
                }
            } else if (bValid) {
                this.m_certLabel.setIcon(GUIUtils.loadImageIcon(CERT_VALID_INACTIVE));
            } else {
                this.m_certLabel.setIcon(GUIUtils.loadImageIcon(CERT_INVALID_INACTIVE));
            }
            if (bValid) {
                this.m_certLabel.setToolTipText("");
            } else {
                this.m_certLabel.setToolTipText("Click to see the details...");
            }
        } else {
            this.m_certLabel.setIcon(GUIUtils.loadImageIcon(CERT_DISABLED));
            this.m_certLabel.setToolTipText("");
        }
    }

    private void enableButtons() {
        boolean cert = this.m_cert != null;
        boolean enabled = this.isEnabled();
        if (this.m_bttnCreateCert != null) {
            this.m_bttnCreateCert.setEnabled(this.m_validator != null && enabled && !cert);
        }
        if (this.m_bttnImportCert != null) {
            this.m_bttnImportCert.setEnabled(enabled);
        }
        if (this.m_bttnExportCert != null) {
            this.m_bttnExportCert.setEnabled(enabled && cert);
        }
        if (this.m_bttnSignCert != null) {
            boolean opCert = false;
            if (this.getParent() instanceof OwnCertificatesPanel) {
                opCert = ((OwnCertificatesPanel)this.getParent()).hasOperatorCert();
            }
            this.m_bttnSignCert.setEnabled(enabled && cert && opCert);
        }
        if (this.m_bttnRemoveCert != null) {
            this.m_bttnRemoveCert.setEnabled(enabled && cert);
        }
        if (this.m_bttnChangePasswd != null) {
            this.m_bttnChangePasswd.setEnabled(enabled && cert);
        }
        if (this.m_certLabel != null) {
            this.m_certLabel.setEnabled(enabled && cert);
        }
        this.updateCertificateIcon(false);
        if (!cert || this.m_cert.getX509Certificate().getValidity().isValid(Calendar.getInstance().getTime())) {
            this.m_textCertValidity.setForeground(new JLabel().getForeground());
            this.m_textCertValidity.setToolTipText("");
        } else {
            this.m_textCertValidity.setForeground(Color.red);
            this.m_textCertValidity.setToolTipText("The certificate has expired.");
        }
    }

    private boolean importPubCert() throws IOException {
        byte[] cert = null;
        JAPDialog dialog = new JAPDialog(this, "Import certificate");
        ChooseStorageMethodPane pane = new ChooseStorageMethodPane(dialog, JAPMessages.getString(MSG_CHOOSE_LOAD_METHOD));
        pane.updateDialog();
        dialog.pack();
        dialog.setResizable(false);
        dialog.setVisible(true);
        if (pane.getButtonValue() != 0) {
            return false;
        }
        if (pane.isMethodFile()) {
            cert = MixConfig.openFile(this, 1);
            if (cert == null) {
                return false;
            }
        } else {
            cert = GUIUtils.getTextFromClipboard(this).getBytes();
        }
        return this.setCert(cert);
    }

    private boolean importPrivCert() throws IOException {
        JAPCertificate cert1;
        byte[] buff;
        PKCS12 pkcs12 = (PKCS12)this.m_cert;
        JAPDialog dialog = new JAPDialog(this, "Import certificate");
        ChooseStorageMethodPane pane = new ChooseStorageMethodPane(dialog, JAPMessages.getString(MSG_CHOOSE_LOAD_METHOD));
        pane.updateDialog();
        dialog.pack();
        dialog.setResizable(false);
        dialog.setVisible(true);
        if (pane.getButtonValue() != 0) {
            return false;
        }
        if (pane.isMethodFile()) {
            int filter = 4;
            if (this.m_cert != null) {
                filter |= 1;
            }
            if ((buff = MixConfig.openFile(this, filter)) == null) {
                return false;
            }
        } else {
            buff = GUIUtils.getTextFromClipboard(this).getBytes();
        }
        if (pkcs12 != null && (cert1 = JAPCertificate.getInstance(buff)) != null) {
            if (pkcs12.setX509Certificate(cert1)) {
                this.setCertificate(pkcs12, this.m_privCertPasswd.toCharArray());
                return true;
            }
            JAPDialog.showErrorDialog((Component)this, "This public key certificate does not belong to your private key!", "Wrong certificate!");
            return false;
        }
        return this.setCert(buff);
    }

    private void changePasswd() {
        String strMessage = null;
        if (this.m_validator != null) {
            strMessage = this.m_validator.getPasswordInfoMessage();
        }
        JAPDialog dialog = new JAPDialog(this, "Change password", true);
        dialog.setResizable(false);
        PasswordContentPane pb = new PasswordContentPane(dialog, 3, strMessage){

            @Override
            public char[] getComparedPassword() {
                return CertPanel.this.m_privCertPasswd.toCharArray();
            }
        };
        pb.updateDialog();
        dialog.pack();
        dialog.setVisible(true);
        if (pb.hasValidValue()) {
            this.m_privCertPasswd = new String(pb.getPassword());
            CertPanel.setAutoSign(false);
            this.fireStateChanged();
            CertPanel.setAutoSign(true);
        }
    }

    private boolean generateNewCert() throws NullPointerException, CannotContinueException {
        if (!this.m_validator.isValid()) {
            throw new CannotContinueException(this.m_validator.getInvalidityMessages());
        }
        final JAPDialog dialog = new JAPDialog(this, "Create new certificate", true);
        dialog.setDefaultCloseOperation(0);
        PasswordContentPane passwordContentPane = new PasswordContentPane(dialog, 1, this.m_validator.getPasswordInfoMessage());
        final CertificateGenerator.CertificateWorker worker = CertificateGenerator.createWorker(dialog, passwordContentPane, this.m_validator.getSigName(), this.m_validator.getExtensions(), this.m_bCreateDSACerts, this.m_nKeySize);
        final CertPanelFinishedContentPane finishedContentPane = new CertPanelFinishedContentPane(dialog, (DialogContentPane)worker);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent a_event) {
                if (!(worker.isVisible() || finishedContentPane.isVisible() && finishedContentPane.checkCancel() != null)) {
                    dialog.dispose();
                }
            }
        });
        passwordContentPane.pack();
        dialog.setResizable(false);
        dialog.setVisible(true);
        if (finishedContentPane.getButtonValue() != 0 || worker.getCertificateGenerator().getCertificate() == null) {
            return false;
        }
        this.setCertificate(worker.getCertificateGenerator().getCertificate(), passwordContentPane.getPassword());
        this.m_bCertificateSaved = false;
        return true;
    }

    private void exportCert() {
        int type;
        if (this.m_cert == null) {
            throw new IllegalArgumentException("No certificate to export.");
        }
        File file = null;
        JAPDialog dialog = new JAPDialog(this, "Export certificate");
        ChooseStorageMethodPane pane = new ChooseStorageMethodPane(dialog, JAPMessages.getString(MSG_CHOOSE_SAVE_METHOD));
        FileFilterSelectionPane typePane = new FileFilterSelectionPane(dialog, JAPMessages.getString(MSG_CHOOSE_CERT_TYPE), pane);
        pane.pack();
        dialog.setResizable(false);
        dialog.setVisible(true);
        if (typePane.getButtonValue() != 0) {
            return;
        }
        if (pane.isMethodFile()) {
            int filter = typePane.getSelectionType() == 0 ? 17 : (typePane.getSelectionType() == 1 ? 96 : 4);
            do {
                String fname;
                JFileChooser fd;
                if ((fd = MixConfig.showFileDialog(this, 1, filter)) == null) {
                    type = 0;
                    file = null;
                    continue;
                }
                FileFilter ff = fd.getFileFilter();
                type = ff instanceof SimpleFileFilter ? ((SimpleFileFilter)ff).getFilterType() : (typePane.getSelectionType() == 0 ? 16 : (typePane.getSelectionType() == 1 ? 64 : 4));
                file = fd.getSelectedFile();
                if (file == null || (fname = file.getName()).indexOf(46) >= 0) continue;
                String[] extensions = new String[]{".pfx", ".b64.pfx", ".der.cer", ".b64.cer", ".csr", ".b64.csr"};
                int ext = 0;
                switch (type) {
                    case 4: {
                        ext = 0;
                        break;
                    }
                    case 8: {
                        ext = 1;
                        break;
                    }
                    case 1: {
                        ext = 2;
                        break;
                    }
                    case 16: {
                        ext = 3;
                        break;
                    }
                    case 32: {
                        ext = 4;
                        break;
                    }
                    case 64: {
                        ext = 5;
                        break;
                    }
                }
                file = new File(file.getParent(), fname + extensions[ext]);
            } while (file != null && file.exists() && JAPDialog.showConfirmDialog((Component)this, JAPMessages.getString(ChooseStorageMethodPane.MSG_CONFIRM_OVERWRITE), 2, 3) != 0);
        } else {
            type = typePane.getSelectionType() == 0 ? 16 : (typePane.getSelectionType() == 1 ? 64 : 8);
        }
        byte[] output = null;
        switch (type) {
            case 4: {
                output = ((PKCS12)this.m_cert).toByteArray(this.getPrivateCertPassword());
                this.m_bCertificateSaved = true;
                break;
            }
            case 8: {
                output = ((PKCS12)this.m_cert).toByteArray(this.getPrivateCertPassword(), true);
                this.m_bCertificateSaved = true;
                break;
            }
            case 1: {
                output = this.m_cert.getX509Certificate().toByteArray();
                break;
            }
            case 16: {
                output = this.m_cert.getX509Certificate().toByteArray(true);
                break;
            }
            case 32: {
                output = new PKCS10CertificationRequest((PKCS12)this.m_cert).toByteArray(false);
            }
            case 64: {
                output = new PKCS10CertificationRequest((PKCS12)this.m_cert).toByteArray(true);
                break;
            }
        }
        try {
            if (file != null) {
                FileOutputStream fout = new FileOutputStream(file);
                fout.write(output);
                fout.close();
            } else if (!pane.isMethodFile()) {
                GUIUtils.saveTextToClipboard(new String(output), this);
            }
            return;
        }
        catch (IOException a_e) {
            JAPDialog.showErrorDialog((Component)this, "Could not export certificate", (Throwable)a_e);
            ClipFrame save = new ClipFrame(this, "I/O error while saving, try clipboard. Copy and Save this file in a new Location.", false);
            save.setText(new String(output));
            save.setVisible(true);
            return;
        }
    }

    private void signCert() {
        Container parent = this.getParent();
        if (this.getParent() instanceof OwnCertificatesPanel) {
            ((OwnCertificatesPanel)parent).signMixCertificate(true);
        }
    }

    private void setCertInfo(JAPCertificate a_x509cs) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(a_x509cs.getValidity().getValidFrom());
        int day = cal.get(5);
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        String startDate = day + "." + month + "." + year;
        cal.setTime(a_x509cs.getValidity().getValidTo());
        day = cal.get(5);
        month = cal.get(2) + 1;
        year = cal.get(1);
        String endDate = day + "." + month + "." + year;
        this.m_textCertValidity.setText(startDate + " - " + endDate);
        String ski = a_x509cs.getSubjectKeyIdentifier();
        if (ski == null) {
            ski = a_x509cs.getSHA1Fingerprint().replace(':', ' ');
            this.m_lblSubjectKeyIdentifier.setToolTipText("SHA-1 Fingerprint");
        }
        try {
            this.m_lblSubjectKeyIdentifier.setText(ski);
            this.m_lblSubjectKeyIdentifier.setVisible(false);
            this.m_lblSubjectKeyIdentifier.setVisible(true);
        }
        catch (Throwable a_e) {
            LogHolder.log(7, LogType.GUI, a_e);
        }
    }

    private void clearCertInfo() {
        this.m_textCertValidity.setText("");
        this.m_lblSubjectKeyIdentifier.setText("");
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        this.enableButtons();
    }

    public String getCertName() {
        return this.m_name;
    }

    public static Vector<CertPanel> getCertPanels() {
        return ms_certpanels;
    }

    static /* synthetic */ Vector access$300() {
        return ms_certpanels;
    }

    static {
        CertPanel.addDefaultCertificates(CERTPATH_MIX, 2);
        CertPanel.addDefaultCertificates(CERTPATH_MIX, 1);
        CertPanel.addDefaultCertificates(CERTPATH_PAYMENT, 7);
        CertPanel.addDefaultCertificates(CERTPATH_TERMS, 9);
        CertPanel.addDefaultCertificates(CERTPATH_INFOSERVICES, 5);
        CertPanel.addDefaultCertificates("certificates/acceptedMixCAs/gpf_jondonym_ca.cer", 2);
        CertPanel.addDefaultCertificates("certificates/acceptedMixCAs/japmixroot.cer", 2);
        CertPanel.addDefaultCertificates("certificates/acceptedMixCAs/Operator_CA.cer", 2);
        CertPanel.addDefaultCertificates("certificates/acceptedPaymentInstances/Payment_Instance.cer", 7);
        CertPanel.addDefaultCertificates("certificates/acceptedTaCTemplates/Terms_and_Conditions.b64.cer", 9);
        CertPanel.addDefaultCertificates("certificates/acceptedMixCAs/gpf_jondonym_ca.cer", 1);
        CertPanel.addDefaultCertificates("certificates/acceptedMixCAs/japmixroot.cer", 1);
        CertPanel.addDefaultCertificates("certificates/acceptedMixCAs/Operator_CA.cer", 1);
        CertPanel.addDefaultCertificates("certificates/acceptedInfoServiceCAs/InfoService_CA.cer", 5);
        CertPanel.addDefaultCertificates("certificates/acceptedInfoServiceCAs/japinfoserviceroot.cer", 5);
        MSG_MANDATORY_ALGO = CertPanel.class.getName() + "_mandatoryAlgorithm";
        MSG_CERT_TYPE_UNKNOWN = CertPanel.class.getName() + "_certTypeUnknown";
        MSG_CONFIRM_DELETION = CertPanel.class.getName() + "_confirmDeletion";
        MSG_CHOOSE_LOAD_METHOD = CertPanel.class.getName() + "_chooseLoadMethod";
        MSG_CHOOSE_SAVE_METHOD = CertPanel.class.getName() + "_chooseSaveMethod";
        MSG_CHOOSE_CERT_TYPE = CertPanel.class.getName() + "_chooseCertType";
        MSG_NO_PRIVATE_CERT = CertPanel.class.getName() + "_noPrivateCert";
        ms_certpanels = new Vector();
        m_autoSign = false;
    }

    private class CertPanelFinishedContentPane
    extends FinishedContentPane {
        public CertPanelFinishedContentPane(JAPDialog a_parentDialog, DialogContentPane a_previousContentPane) {
            super(a_parentDialog, "You have successfully created the certificate!", a_previousContentPane);
        }

        @Override
        public DialogContentPane.CheckError checkCancel() {
            return this.showConfirmDialog();
        }

        @Override
        public DialogContentPane.CheckError checkNo() {
            return this.showConfirmDialog();
        }

        private DialogContentPane.CheckError showConfirmDialog() {
            int returnValue = JAPDialog.showConfirmDialog((JAPDialog)this.getDialog(), "This will delete your newly created certificate. Do you really want to continue?", 2, 2);
            if (returnValue != 0) {
                return new DialogContentPane.CheckError();
            }
            return null;
        }
    }

    private class FileFilterSelectionPane
    extends DialogContentPane
    implements DialogContentPane.IWizardSuitable {
        public static final int X509 = 0;
        public static final int PKCS10 = 1;
        public static final int PKCS12 = 2;
        private JRadioButton m_btnPublicCert;
        private JRadioButton m_btnCertRequest;
        private JRadioButton m_btnPrivateCert;
        private ChooseStorageMethodPane m_previousPane;

        public FileFilterSelectionPane(JAPDialog a_dialog, String a_strText, ChooseStorageMethodPane a_previousPane) {
            super(a_dialog, a_strText, new DialogContentPaneOptions(2, (DialogContentPane)a_previousPane));
            this.m_previousPane = a_previousPane;
            GridBagConstraints constr = new GridBagConstraints();
            ButtonGroup group = new ButtonGroup();
            this.m_btnPublicCert = new JRadioButton("X509 public certificate");
            this.m_btnCertRequest = new JRadioButton("PKCS10 certification request");
            this.m_btnPrivateCert = new JRadioButton("PKCS12 private certificate");
            group.add(this.m_btnPublicCert);
            group.add(this.m_btnCertRequest);
            group.add(this.m_btnPrivateCert);
            this.m_btnPublicCert.setSelected(true);
            constr.gridx = 0;
            constr.gridy = 0;
            constr.anchor = 17;
            constr.fill = 2;
            constr.weightx = 0.0;
            this.getContentPane().setLayout(new GridBagLayout());
            this.getContentPane().add((Component)this.m_btnPublicCert, constr);
            ++constr.gridy;
            this.getContentPane().add((Component)this.m_btnCertRequest, constr);
            ++constr.gridy;
            this.getContentPane().add((Component)this.m_btnPrivateCert, constr);
        }

        @Override
        public DialogContentPane.CheckError checkUpdate() {
            if (CertPanel.this.m_cert instanceof PKCS12) {
                this.m_btnCertRequest.setEnabled(true);
                this.m_btnPrivateCert.setEnabled(true);
                if (this.m_btnPrivateCert.isSelected() && !this.m_previousPane.isMethodFile()) {
                    this.m_btnPublicCert.setSelected(true);
                }
            } else {
                this.m_btnPublicCert.setSelected(true);
                this.m_btnCertRequest.setEnabled(false);
                this.m_btnPrivateCert.setEnabled(false);
            }
            return super.checkUpdate();
        }

        public int getSelectionType() {
            if (this.m_btnPublicCert.isSelected()) {
                return 0;
            }
            if (this.m_btnCertRequest.isSelected()) {
                return 1;
            }
            return 2;
        }
    }

    private class CertPanelPasswordReader
    implements IMiscPasswordReader {
        private char[] m_password;
        private Vector m_certPanels = (Vector)CertPanel.access$300().clone();
        private boolean m_triedOwnPassword = false;
        private IMiscPasswordReader m_passwordReader;

        public CertPanelPasswordReader(IMiscPasswordReader a_passwordReader) {
            this.m_passwordReader = a_passwordReader;
        }

        @Override
        public String readPassword(Object message) {
            if (!this.m_triedOwnPassword && CertPanel.this.getPrivateCertPassword() != null) {
                this.m_triedOwnPassword = true;
                this.m_password = CertPanel.this.getPrivateCertPassword();
            } else {
                this.m_password = null;
                while (this.m_certPanels.size() > 0) {
                    this.m_password = ((CertPanel)this.m_certPanels.elementAt(0)).getPrivateCertPassword();
                    this.m_certPanels.removeElementAt(0);
                    if (this.m_password == null) continue;
                }
            }
            if (this.m_password == null) {
                this.m_password = this.m_passwordReader.readPassword("").toCharArray();
            }
            return new String(this.m_password);
        }

        public char[] getPassword() {
            return this.m_password;
        }
    }
}

