/*
 * Decompiled with CFR 0.152.
 */
package mixconfig;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class SimpleFileFilter
extends FileFilter {
    private String m_strDesc;
    private String m_strExtension;
    private String m_strExtensionTwo;
    private int filterType;

    public int getFilterType() {
        return this.filterType;
    }

    public SimpleFileFilter(int filter_type) {
        this.filterType = filter_type;
        switch (filter_type) {
            case 1: {
                this.m_strDesc = "Public X.509 Certificate (*.cer, *.crt)";
                this.m_strExtension = ".cer";
                this.m_strExtensionTwo = ".crt";
                break;
            }
            case 16: {
                this.m_strDesc = "Public X.509 Certificate, Base64 (*.cer, *.crt)";
                this.m_strExtension = ".cer";
                this.m_strExtensionTwo = ".crt";
                break;
            }
            case 2: {
                this.m_strDesc = "Mix Configuration (*.xml)";
                this.m_strExtension = ".xml";
                break;
            }
            case 32: {
                this.m_strDesc = "PKCS10 Certification Request (*.csr)";
                this.m_strExtension = ".csr";
                break;
            }
            case 64: {
                this.m_strDesc = "PKCS10 Certification Request, Base64 (*.csr)";
                this.m_strExtension = ".csr";
                break;
            }
            case 4: {
                this.m_strDesc = "Private Key with Certificate (*.pfx)";
                this.m_strExtension = ".pfx";
                break;
            }
            case 8: {
                this.m_strDesc = "Private Key with Certificate, Base64 (*.pfx)";
                this.m_strExtension = ".pfx";
                break;
            }
            default: {
                this.m_strDesc = "";
                this.m_strExtension = "";
            }
        }
    }

    @Override
    public boolean accept(File f) {
        return f.isDirectory() || f.getName().endsWith(this.m_strExtension) || this.m_strExtensionTwo != null && f.getName().endsWith(this.m_strExtensionTwo);
    }

    @Override
    public String getDescription() {
        return this.m_strDesc;
    }
}

