/*
 * Decompiled with CFR 0.152.
 */
package gui.dialog;

import gui.TitledGridBagPanel;
import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetSocketAddress;
import java.net.Proxy;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProxyDialog
extends JAPDialog
implements ActionListener {
    private TitledGridBagPanel panel = new TitledGridBagPanel();
    private JLabel hostLabel = new JLabel("Host");
    private JLabel portLabel = new JLabel("Port");
    private JTextField hostTextField = new JTextField(20);
    private JTextField portTextField = new JTextField(20);
    private JButton cancelButton = new JButton("Cancel");
    private JButton disableButton = new JButton("Disable");
    private JButton okButton = new JButton("OK");
    private Proxy returnProxy = null;

    public ProxyDialog(Component component) {
        this(component, (Proxy)null);
    }

    public ProxyDialog(Component component, Proxy presetProxy) {
        super(component, "Proxy Configuration");
        this.setDefaultCloseOperation(2);
        this.panel.addRow(this.hostLabel, this.hostTextField);
        this.panel.addRow(this.portLabel, this.portTextField);
        JPanel buttonPanel = new JPanel();
        if (presetProxy != null && presetProxy.address() != null && presetProxy.address() instanceof InetSocketAddress) {
            this.hostTextField.setText(((InetSocketAddress)presetProxy.address()).getHostName());
            this.portTextField.setText("" + ((InetSocketAddress)presetProxy.address()).getPort());
        }
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.disableButton);
        buttonPanel.add(this.okButton);
        this.panel.addRow(buttonPanel);
        this.okButton.addActionListener(this);
        this.disableButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.getContentPane().add(this.panel);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.disableButton) {
            this.returnProxy = Proxy.NO_PROXY;
            this.dispose();
        }
        if (e.getSource() == this.cancelButton) {
            this.returnProxy = null;
            this.dispose();
        }
        if (e.getSource() == this.okButton) {
            String hostText = this.hostTextField.getText();
            String portText = this.portTextField.getText();
            if (hostText == null || hostText.equals("")) {
                JAPDialog.showErrorDialog((JAPDialog)this, "No host specified.");
            } else if (portText == null || portText.equals("")) {
                JAPDialog.showErrorDialog((JAPDialog)this, "No port specified.");
            } else {
                try {
                    InetSocketAddress proxyAddress = new InetSocketAddress(hostText, Integer.parseInt(portText));
                    this.returnProxy = new Proxy(Proxy.Type.HTTP, proxyAddress);
                    this.dispose();
                }
                catch (NumberFormatException nfe) {
                    JAPDialog.showErrorDialog((JAPDialog)this, "Bad proxy port: " + portText + ". Port must be a number between 0 and 65535");
                }
                catch (IllegalArgumentException ila) {
                    JAPDialog.showErrorDialog((JAPDialog)this, ila.getMessage());
                }
            }
        }
    }

    public static Proxy showProxyDialog(Component component, Proxy presetProxy) {
        ProxyDialog d = new ProxyDialog(component, presetProxy);
        d.setVisible(true);
        return d.returnProxy;
    }
}

