/*
 * Decompiled with CFR 0.152.
 */
package gui;

import anon.infoservice.ServiceLocation;
import anon.platform.AbstractOS;
import anon.util.ClassUtil;
import anon.util.CountryMapper;
import anon.util.IReturnRunnable;
import anon.util.JAPMessages;
import anon.util.JobQueue;
import anon.util.ResourceLoader;
import gui.ClipFrame;
import gui.ILocationSettings;
import gui.JAPAWTMsgBox;
import gui.JAPHtmlMultiLineLabel;
import gui.dialog.JAPDialog;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import logging.LogHolder;
import logging.LogType;

public final class GUIUtils
implements ILocationSettings {
    public static final String aktVersion = "00.00.213";
    public static final String MSG_DEFAULT_IMGAGE_PATH = (class$gui$GUIUtils == null ? (class$gui$GUIUtils = GUIUtils.class$("gui.GUIUtils")) : class$gui$GUIUtils).getName() + "_imagePath";
    public static final String MSG_DEFAULT_IMGAGE_PATH_LOWCOLOR = (class$gui$GUIUtils == null ? (class$gui$GUIUtils = GUIUtils.class$("gui.GUIUtils")) : class$gui$GUIUtils).getName() + "_imagePathLowColor";
    public static final String FILE_CHOOSER_OPEN = "__FILE_CHOOSER_OPEN";
    public static final String FILE_CHOOSER_SAVE = "__FILE_CHOOSER_SAVE";
    private static final String MSG_PASTE_FILE = (class$gui$GUIUtils == null ? (class$gui$GUIUtils = GUIUtils.class$("gui.GUIUtils")) : class$gui$GUIUtils).getName() + "_pasteFile";
    private static final String MSG_COPY_FROM_CLIP = (class$gui$GUIUtils == null ? (class$gui$GUIUtils = GUIUtils.class$("gui.GUIUtils")) : class$gui$GUIUtils).getName() + "_copyFromClip";
    private static final String MSG_SAVED_TO_CLIP = (class$gui$GUIUtils == null ? (class$gui$GUIUtils = GUIUtils.class$("gui.GUIUtils")) : class$gui$GUIUtils).getName() + "_savedToClip";
    private static final int MAXIMUM_TEXT_LENGTH = 60;
    private static boolean ms_loadImages = true;
    private static boolean ms_bCapturingAWTEvents = false;
    private static Point ms_mousePosition;
    private static final Object SYNC_MOUSE_POSITION;
    private static AWTEventListener ms_mouseListener;
    private static final Vector AWT_EVENT_LISTENERS;
    private static final IIconResizer DEFAULT_RESIZER;
    private static IIconResizer ms_resizer;
    private static final NativeGUILibrary DUMMY_GUI_LIBRARY;
    private static NativeGUILibrary ms_nativeGUILibrary;
    private static final IIconResizer RESIZER;
    private static Hashtable ms_iconCache;
    static /* synthetic */ Class class$gui$GUIUtils;
    static /* synthetic */ Class class$java$awt$Window;
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$java$awt$Toolkit;
    static /* synthetic */ Class class$javax$swing$LookAndFeel;

    public static final Point getEventLocation(Component a_parentComponent, MouseEvent a_event) {
        Component component = null;
        if (a_event.getSource() instanceof Component) {
            component = (Component)a_event.getSource();
        }
        Window window = GUIUtils.getParentWindow(component);
        int xPlus = a_parentComponent.getLocation().x;
        int yPlus = a_parentComponent.getLocation().y;
        while (component != window && component != null) {
            xPlus += component.getLocation().x;
            yPlus += component.getLocation().y;
            component = component.getParent();
        }
        return new Point(a_event.getX() + xPlus, a_event.getY() + yPlus);
    }

    public static final IIconResizer getIconResizer() {
        return RESIZER;
    }

    public static void setLoadImages(boolean a_bLoadImages) {
        if (ms_loadImages && !a_bLoadImages) {
            LogHolder.log(5, LogType.GUI, "Loading of images has been stopped!");
        }
        ms_loadImages = a_bLoadImages;
    }

    public static boolean isLoadingImagesStopped() {
        return !ms_loadImages;
    }

    public static final void setIconResizer(IIconResizer a_resizer) {
        ms_resizer = a_resizer != null ? a_resizer : DEFAULT_RESIZER;
    }

    public static ImageIcon loadImageIcon(String a_strRelativeImagePath) {
        return GUIUtils.loadImageIcon(a_strRelativeImagePath, true, true);
    }

    public static ImageIcon loadImageIcon(String a_strRelativeImagePath, boolean a_bSync) {
        return GUIUtils.loadImageIcon(a_strRelativeImagePath, a_bSync, true);
    }

    public static ImageIcon loadImageIcon(String a_strRelativeImagePath, boolean a_bSync, boolean a_bScale) {
        ImageIcon img = null;
        boolean bScalingDone = false;
        String strScaledRelativeImagePath = null;
        if (a_strRelativeImagePath == null) {
            return null;
        }
        if (a_bScale && ms_resizer.getResizeFactor() != 1.0) {
            strScaledRelativeImagePath = (int)(100.0 * ms_resizer.getResizeFactor()) + "/" + a_strRelativeImagePath;
        }
        if (strScaledRelativeImagePath != null && ms_iconCache.containsKey(strScaledRelativeImagePath)) {
            img = new ImageIcon((Image)ms_iconCache.get(strScaledRelativeImagePath));
            if (img != null) {
                bScalingDone = true;
            }
        } else if (ms_iconCache.containsKey(a_strRelativeImagePath)) {
            img = new ImageIcon((Image)ms_iconCache.get(a_strRelativeImagePath));
        }
        if (img == null && ms_loadImages) {
            int statusBits;
            if (strScaledRelativeImagePath != null && (img = GUIUtils.loadImageIconInternal(ResourceLoader.getResourceURL(strScaledRelativeImagePath))) != null) {
                bScalingDone = true;
            }
            if (img == null) {
                img = GUIUtils.loadImageIconInternal(ResourceLoader.getResourceURL(a_strRelativeImagePath));
            }
            ColorModel colorModel = null;
            try {
                colorModel = Toolkit.getDefaultToolkit().getColorModel();
            }
            catch (Throwable t1) {
                // empty catch block
            }
            if (img == null && (colorModel == null || colorModel.getPixelSize() <= 16)) {
                if (strScaledRelativeImagePath != null && (img = GUIUtils.loadImageIconInternal(ResourceLoader.getResourceURL(JAPMessages.getString(MSG_DEFAULT_IMGAGE_PATH_LOWCOLOR) + strScaledRelativeImagePath))) != null) {
                    bScalingDone = true;
                }
                if (img == null) {
                    img = GUIUtils.loadImageIconInternal(ResourceLoader.getResourceURL(JAPMessages.getString(MSG_DEFAULT_IMGAGE_PATH_LOWCOLOR) + a_strRelativeImagePath));
                }
            }
            if (img == null || img.getImageLoadStatus() == 4) {
                if (strScaledRelativeImagePath != null && (img = GUIUtils.loadImageIconInternal(ResourceLoader.getResourceURL(JAPMessages.getString(MSG_DEFAULT_IMGAGE_PATH) + strScaledRelativeImagePath))) != null) {
                    bScalingDone = true;
                }
                if (img == null) {
                    img = GUIUtils.loadImageIconInternal(ResourceLoader.getResourceURL(JAPMessages.getString(MSG_DEFAULT_IMGAGE_PATH) + a_strRelativeImagePath));
                }
            }
            if (img != null) {
                if (a_bSync) {
                    statusBits = 14;
                    while ((img.getImageLoadStatus() & statusBits) == 0) {
                        Thread.yield();
                    }
                }
                if (strScaledRelativeImagePath != null && bScalingDone) {
                    ms_iconCache.put(strScaledRelativeImagePath, img.getImage());
                } else {
                    ms_iconCache.put(a_strRelativeImagePath, img.getImage());
                }
            }
            statusBits = 6;
            if (img == null || (img.getImageLoadStatus() & statusBits) != 0) {
                LogHolder.log(6, LogType.GUI, "Could not load requested image '" + a_strRelativeImagePath + "'!");
            }
        }
        if (a_bScale && !bScalingDone && ms_loadImages && ms_resizer.getResizeFactor() != 1.0) {
            final ImageIcon image = img;
            IReturnRunnable run = new IReturnRunnable(){
                private ImageIcon m_icon;

                public void run() {
                    this.m_icon = GUIUtils.createScaledImageIcon(image, ms_resizer);
                }

                public Object getValue() {
                    return this.m_icon;
                }
            };
            Thread thread = new Thread(run);
            thread.setDaemon(true);
            thread.start();
            try {
                thread.join(1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            while (thread.isAlive()) {
                thread.interrupt();
                try {
                    thread.join();
                }
                catch (InterruptedException a_e) {}
            }
            if (run.getValue() != null) {
                return (ImageIcon)run.getValue();
            }
            if (img != null && run.getValue() == null) {
                LogHolder.log(3, LogType.GUI, "Interrupted while scaling image icon!");
            }
        }
        return img;
    }

    private static ImageIcon loadImageIconInternal(URL a_imageURL) {
        try {
            return new ImageIcon(a_imageURL);
        }
        catch (NullPointerException a_e) {
            return null;
        }
    }

    public static ImageIcon combine(ImageIcon a_one, ImageIcon a_two) {
        if (a_one == null) {
            return a_two;
        }
        if (a_two == null) {
            return a_one;
        }
        int totalWidth = a_one.getIconWidth() + a_two.getIconWidth();
        int totalHeight = Math.max(a_one.getIconHeight(), a_two.getIconHeight());
        try {
            Class<?> classBufferedImage = Class.forName("java.awt.image.BufferedImage");
            Field fieldTYPE_INT_ARGB = classBufferedImage.getField("TYPE_INT_ARGB");
            Constructor<?> constructorBufferedImage = classBufferedImage.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Image objectBufferedImage = (Image)constructorBufferedImage.newInstance(new Integer(totalWidth), new Integer(totalHeight), new Integer(fieldTYPE_INT_ARGB.getInt(classBufferedImage)));
            Graphics objectGraphics2D = (Graphics)classBufferedImage.getMethod("createGraphics", null).invoke((Object)objectBufferedImage, (Object[])null);
            objectGraphics2D.drawImage(a_one.getImage(), 0, 0, null);
            objectGraphics2D.drawImage(a_two.getImage(), a_one.getIconWidth(), 0, null);
            objectGraphics2D.dispose();
            return new ImageIcon(objectBufferedImage);
        }
        catch (Exception a_e) {
            return a_one;
        }
    }

    public static void setLocationRelativeTo(Component a_component, Window a_movedWindow, int a_position) {
        if (a_component == null && a_movedWindow == null) {
            return;
        }
        if (a_position < 0 || a_position > 13) {
            a_position = 0;
        }
        Container root = null;
        if (a_component != null) {
            if (a_component instanceof Window || a_component instanceof Applet) {
                root = (Container)a_component;
            } else {
                for (Container parent = a_component.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof Window) && !(parent instanceof Applet)) continue;
                    root = parent;
                    break;
                }
            }
        }
        if (a_component != null && !a_component.isShowing() || root == null || !root.isShowing()) {
            Dimension paneSize = a_movedWindow.getSize();
            Dimension screenSize = a_movedWindow.getToolkit().getScreenSize();
            a_movedWindow.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
        } else {
            Point invokerScreenLocation;
            Dimension invokerSize = a_component.getSize();
            if (root instanceof Applet) {
                invokerScreenLocation = a_component.getLocationOnScreen();
            } else {
                invokerScreenLocation = new Point(0, 0);
                for (Component tc = a_component; tc != null; tc = tc.getParent()) {
                    Point tcl = tc.getLocation();
                    invokerScreenLocation.x += tcl.x;
                    invokerScreenLocation.y += tcl.y;
                    if (tc == root) break;
                }
            }
            Rectangle windowBounds = a_movedWindow.getBounds();
            int dx = invokerScreenLocation.x + (invokerSize.width - windowBounds.width >> 1);
            int dy = invokerScreenLocation.y + (invokerSize.height - windowBounds.height >> 1);
            switch (a_position) {
                case 1: {
                    dx -= invokerSize.width / 2;
                    break;
                }
                case 2: {
                    dx += invokerSize.width / 2;
                    break;
                }
                case 3: {
                    dy -= invokerSize.height / 2;
                    break;
                }
                case 4: {
                    dy += invokerSize.height / 2;
                    break;
                }
                case 5: {
                    dy = invokerScreenLocation.y + 40;
                    break;
                }
                case 6: {
                    dy = invokerScreenLocation.y - windowBounds.height;
                    break;
                }
                case 7: {
                    dy = invokerScreenLocation.y + invokerSize.height;
                    break;
                }
                case 9: {
                    dx = invokerScreenLocation.x - windowBounds.width;
                    break;
                }
                case 8: {
                    dx = invokerScreenLocation.x + invokerSize.width;
                    break;
                }
                case 10: {
                    dx -= invokerSize.width / 2;
                    dy += invokerSize.height / 2;
                    break;
                }
                case 12: {
                    dx += invokerSize.width / 2;
                    dy += invokerSize.height / 2;
                    break;
                }
                case 13: {
                    dx += invokerSize.width / 2;
                    dy -= invokerSize.height / 2;
                    break;
                }
                case 11: {
                    dx -= invokerSize.width / 2;
                    dy -= invokerSize.height / 2;
                }
            }
            Dimension ss = a_movedWindow.getToolkit().getScreenSize();
            if (dy + windowBounds.height > ss.height) {
                dy = ss.height - windowBounds.height;
                int n = dx = invokerScreenLocation.x < ss.width >> 1 ? invokerScreenLocation.x + invokerSize.width : invokerScreenLocation.x - windowBounds.width;
            }
            if (dx + windowBounds.width > ss.width) {
                dx = ss.width - windowBounds.width;
            }
            if (dx < 0) {
                dx = 0;
            }
            if (dy < 0) {
                dy = 0;
            }
            a_movedWindow.setLocation(dx, dy);
        }
    }

    public static Window getParentWindow(Component a_component) {
        Component component = a_component;
        if (component == null) {
            component = new JOptionPane().createDialog(component, "").getParent();
        }
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    public static void moveToUpRightCorner(Window a_window) {
        Screen currentScreen = GUIUtils.getCurrentScreen(a_window);
        Dimension ownSize = a_window.getSize();
        a_window.setLocation(currentScreen.getX() + (currentScreen.getWidth() - ownSize.width), currentScreen.getY());
    }

    public static void setNativeGUILibrary(NativeGUILibrary a_library) {
        if (a_library != null) {
            ms_nativeGUILibrary = a_library;
        }
    }

    public static boolean isAlwaysOnTop(Component a_component) {
        return GUIUtils.isAlwaysOnTop(GUIUtils.getParentWindow(a_component));
    }

    public static boolean isAlwaysOnTop(Window a_Window) {
        if (a_Window == null) {
            return false;
        }
        try {
            Method m = (class$java$awt$Window == null ? (class$java$awt$Window = GUIUtils.class$("java.awt.Window")) : class$java$awt$Window).getMethod("isAlwaysOnTop", new Class[0]);
            return (Boolean)m.invoke((Object)a_Window, new Object[0]);
        }
        catch (Throwable throwable) {
            return ms_nativeGUILibrary.isAlwaysOnTop(a_Window);
        }
    }

    public static void setFontStyle(Component a_component, int a_style) {
        if (a_component == null) {
            return;
        }
        a_component.setFont(new Font(a_component.getFont().getName(), a_style, a_component.getFont().getSize()));
    }

    public static boolean setAlwaysOnTop(Component a_component, boolean a_bOnTop) {
        return GUIUtils.setAlwaysOnTop(GUIUtils.getParentWindow(a_component), a_bOnTop);
    }

    public static boolean hasJavaOnTop() {
        try {
            Class[] c = new Class[]{Boolean.TYPE};
            (class$java$awt$Window == null ? (class$java$awt$Window = GUIUtils.class$("java.awt.Window")) : class$java$awt$Window).getMethod("setAlwaysOnTop", c);
        }
        catch (NoSuchMethodException a_e) {
            return false;
        }
        return true;
    }

    public static boolean setAlwaysOnTop(Window a_Window, boolean a_bOnTop) {
        if (a_Window == null) {
            return false;
        }
        try {
            Class[] c = new Class[]{Boolean.TYPE};
            Method m = (class$java$awt$Window == null ? (class$java$awt$Window = GUIUtils.class$("java.awt.Window")) : class$java$awt$Window).getMethod("setAlwaysOnTop", c);
            Object[] args = new Object[]{new Boolean(a_bOnTop)};
            m.invoke((Object)a_Window, args);
            return true;
        }
        catch (Throwable throwable) {
            return ms_nativeGUILibrary.setAlwaysOnTop(a_Window, a_bOnTop);
        }
    }

    public static boolean restoreSize(Window a_window, Dimension a_size) {
        if (a_window == null || a_size == null) {
            return false;
        }
        a_window.setSize(a_size);
        Screen currentScreen = GUIUtils.getCurrentScreen(a_window);
        int width = a_window.getSize().width;
        int height = a_window.getSize().height;
        if (a_window.getLocation().x + width > currentScreen.getX() + currentScreen.getWidth()) {
            width = currentScreen.getX() + currentScreen.getWidth() - a_window.getLocation().x;
        }
        if (a_window.getLocation().y + height > currentScreen.getY() + currentScreen.getHeight()) {
            height = currentScreen.getY() + currentScreen.getHeight() - a_window.getLocation().y;
        }
        if (width == 0) {
            width = a_window.getSize().width;
        }
        if (height == 0) {
            height = a_window.getSize().height;
        }
        a_window.setSize(width, height);
        return true;
    }

    public static Point getMiddlePoint(Window a_window) {
        if (a_window == null) {
            return new Point(0, 0);
        }
        return new Point(a_window.getLocation().x + a_window.getSize().width / 2, a_window.getLocation().y + a_window.getSize().height / 2);
    }

    public static boolean restoreLocation(Window a_window, Point a_location) {
        if (a_window == null || a_location == null) {
            return false;
        }
        double bestArea = -1.0;
        double bestDistance = Double.MAX_VALUE;
        Screen currentScreen = null;
        a_window.setLocation(a_location);
        Point windowCenter = GUIUtils.getMiddlePoint(a_window);
        Screen[] screens = GUIUtils.getScreens(a_window);
        int x = a_location.x;
        int width = a_window.getSize().width;
        int y = a_location.y;
        int height = a_window.getSize().height;
        if (screens.length == 0) {
            return false;
        }
        for (int i = 0; i < screens.length; ++i) {
            boolean bRightDown;
            if (windowCenter.x >= screens[i].getX() && windowCenter.y >= screens[i].getY() && windowCenter.x <= screens[i].getX() + screens[i].getWidth() && windowCenter.y <= screens[i].getY() + screens[i].getHeight()) {
                currentScreen = screens[i];
                break;
            }
            boolean bLeftUp = x >= screens[i].getX() && x <= screens[i].getX() + screens[i].getWidth() && y >= screens[i].getY() && y <= screens[i].getY() + screens[i].getHeight();
            boolean bRightUp = x + width >= screens[i].getX() && x + width <= screens[i].getX() + screens[i].getWidth() && y >= screens[i].getY() && y <= screens[i].getY() + screens[i].getHeight();
            boolean bLeftDown = y + height >= screens[i].getY() && y + height <= screens[i].getY() + screens[i].getHeight() && x >= screens[i].getX() && x <= screens[i].getX() + screens[i].getWidth();
            boolean bl = bRightDown = y + height >= screens[i].getY() && x + width >= screens[i].getX() && y + height <= screens[i].getY() + screens[i].getHeight() && x + width <= screens[i].getX() + screens[i].getWidth();
            if (!bLeftUp && !bRightUp && !bLeftDown && !bRightDown) continue;
            int areaX1 = bLeftUp || bLeftDown ? x : screens[i].getX();
            int areaX2 = bRightUp || bRightDown ? x + width : screens[i].getX() + screens[i].getWidth();
            int areaY1 = bLeftUp || bRightUp ? y : screens[i].getY();
            int areaY2 = bLeftDown || bRightDown ? y + height : screens[i].getY() + screens[i].getHeight();
            int area = (areaX2 - areaX1) * (areaY2 - areaY1);
            LogHolder.log(6, LogType.GUI, "Calculated partial overlapping area for restoring window location: " + area);
            if (!((double)area >= bestArea)) continue;
            bestArea = area;
            currentScreen = screens[i];
        }
        if (currentScreen == null) {
            for (int i = 0; i < screens.length; ++i) {
                Point screenCenter = new Point(screens[i].getX() + screens[i].getWidth() / 2, screens[i].getY() + screens[i].getHeight() / 2);
                double currentDistanceVector = Math.sqrt(Math.pow(windowCenter.x - screenCenter.x, 2.0) + Math.pow(windowCenter.y - screenCenter.y, 2.0));
                LogHolder.log(6, LogType.GUI, "Calculated distance vector for restoring window location: " + currentDistanceVector);
                if (!(currentDistanceVector < bestDistance)) continue;
                currentScreen = screens[i];
                bestDistance = currentDistanceVector;
            }
        }
        LogHolder.log(5, LogType.GUI, "The following screen was chosen for restoring a window location:\n" + currentScreen);
        if (x + a_window.getSize().width > currentScreen.getX() + currentScreen.getWidth()) {
            x = currentScreen.getX() + currentScreen.getWidth() - a_window.getSize().width;
        }
        if (y + a_window.getSize().height > currentScreen.getY() + currentScreen.getHeight()) {
            y = currentScreen.getY() + currentScreen.getHeight() - a_window.getSize().height;
        }
        if (x < currentScreen.getX()) {
            x = currentScreen.getX();
        }
        if (y < currentScreen.getY()) {
            y = currentScreen.getY();
        }
        a_window.setLocation(x, y);
        return true;
    }

    public static MouseListener addTimedTooltipListener(JComponent c) {
        try {
            Class<?> classInputMap = Class.forName("javax.swing.InputMap");
            Object imap = (class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = GUIUtils.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).getMethod("getInputMap", new Class[0]).invoke((Object)c, new Object[0]);
            (class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = GUIUtils.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).getMethod("getActionMap", new Class[0]).invoke((Object)c, new Object[0]);
            boolean removeKeyStroke = false;
            KeyStroke[] ks = (KeyStroke[])classInputMap.getMethod("keys", new Class[0]).invoke(imap, new Object[0]);
            if (ks == null || ks.length == 0) {
                classInputMap.getMethod("put", class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = GUIUtils.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$java$lang$Object == null ? (class$java$lang$Object = GUIUtils.class$("java.lang.Object")) : class$java$lang$Object).invoke(imap, KeyStroke.getKeyStroke(92, 0), "backSlash");
                removeKeyStroke = true;
            }
            ToolTipManager.sharedInstance().registerComponent(c);
            if (removeKeyStroke) {
                classInputMap.getMethod("remove", class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = GUIUtils.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke).invoke(imap, KeyStroke.getKeyStroke(92, 0));
            }
            ToolTipMouseListener listener = new ToolTipMouseListener();
            c.addMouseListener(listener);
            return listener;
        }
        catch (Exception a_e) {
            LogHolder.log(5, LogType.GUI, "Could not register component for timed tooltip!", a_e);
            return null;
        }
    }

    public static Screen[] getScreens(Window a_window) {
        try {
            Object graphicsEnvironment = Class.forName("java.awt.GraphicsEnvironment").getMethod("getLocalGraphicsEnvironment", null).invoke((Object)null, (Object[])null);
            Object[] graphicsDevices = (Object[])graphicsEnvironment.getClass().getMethod("getScreenDevices", null).invoke(graphicsEnvironment, (Object[])null);
            Screen[] screens = new Screen[graphicsDevices.length];
            for (int i = 0; i < graphicsDevices.length; ++i) {
                Object graphicsConfiguration = graphicsDevices[i].getClass().getMethod("getDefaultConfiguration", null).invoke(graphicsDevices[i], (Object[])null);
                Frame screenFrame = (Frame)(class$java$awt$Frame == null ? GUIUtils.class$("java.awt.Frame") : class$java$awt$Frame).getConstructor(Class.forName("java.awt.GraphicsConfiguration")).newInstance(graphicsConfiguration);
                screens[i] = new Screen(screenFrame.getLocation(), (Rectangle)graphicsConfiguration.getClass().getMethod("getBounds", null).invoke(graphicsConfiguration, (Object[])null));
            }
            return screens;
        }
        catch (Exception a_e) {
            return new Screen[]{new Screen(new Point(0, 0), GUIUtils.getDefaultScreenBounds(a_window))};
        }
    }

    public static Screen getCurrentScreen(Component a_component) {
        return GUIUtils.getCurrentScreen(GUIUtils.getParentWindow(a_component));
    }

    public static Screen getCurrentScreen(Window a_window) {
        if (a_window == null) {
            return null;
        }
        try {
            Object graphicsEnvironment = Class.forName("java.awt.GraphicsEnvironment").getMethod("getLocalGraphicsEnvironment", null).invoke((Object)null, (Object[])null);
            Object[] graphicsDevices = (Object[])graphicsEnvironment.getClass().getMethod("getScreenDevices", null).invoke(graphicsEnvironment, (Object[])null);
            Point windowMiddleLocation = GUIUtils.getMiddlePoint(a_window);
            for (int i = 0; i < graphicsDevices.length; ++i) {
                Object graphicsConfiguration = graphicsDevices[i].getClass().getMethod("getDefaultConfiguration", null).invoke(graphicsDevices[i], (Object[])null);
                Frame screenFrame = (Frame)(class$java$awt$Frame == null ? GUIUtils.class$("java.awt.Frame") : class$java$awt$Frame).getConstructor(Class.forName("java.awt.GraphicsConfiguration")).newInstance(graphicsConfiguration);
                Point screenLocation = screenFrame.getLocation();
                Rectangle screenBounds = (Rectangle)graphicsConfiguration.getClass().getMethod("getBounds", null).invoke(graphicsConfiguration, (Object[])null);
                if (windowMiddleLocation.x < screenLocation.x || windowMiddleLocation.x > screenLocation.x + screenBounds.width || windowMiddleLocation.y < screenLocation.y || windowMiddleLocation.y > screenLocation.y + screenBounds.height) continue;
                return GUIUtils.getOverlappingScreen(new Screen(screenLocation, screenBounds), a_window);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Screen(new Point(0, 0), GUIUtils.getDefaultScreenBounds(a_window));
    }

    public static void centerOnScreen(Window a_window) {
        Rectangle screenBounds = GUIUtils.getDefaultScreenBounds(a_window);
        Dimension ownSize = a_window.getSize();
        a_window.setLocation(screenBounds.x + (screenBounds.width - ownSize.width) / 2, screenBounds.y + (screenBounds.height - ownSize.height) / 2);
    }

    public static void centerOnWindow(Window a_window, Window a_parent) {
        if (a_window == null || a_parent == null) {
            return;
        }
        Dimension parentSize = a_parent.getSize();
        Dimension ownSize = a_window.getSize();
        Point parentLocation = a_parent.getLocationOnScreen();
        a_window.setLocation(parentLocation.x + parentSize.width / 2 - ownSize.width / 2, parentLocation.y + parentSize.height / 2 - ownSize.height / 2);
    }

    public static JTextPane createSelectableAndResizeableLabel(Component a_parent) {
        JTextPane selectableLabel = new JTextPane();
        selectableLabel.setBackground(a_parent.getBackground());
        selectableLabel.setEditable(false);
        selectableLabel.setDisabledTextColor(selectableLabel.getCaretColor());
        Font jlFont = new JLabel().getFont();
        selectableLabel.setFont(new Font(jlFont.getName(), 1, jlFont.getSize()));
        return selectableLabel;
    }

    public static JLabel createMultiLineLabel(String messageKey, int width) {
        JAPHtmlMultiLineLabel mLable = new JAPHtmlMultiLineLabel();
        mLable.setText(JAPMessages.getString(messageKey));
        mLable.setPreferredWidth(width);
        return mLable;
    }

    public static JLabel createLabel(String messageKey) {
        return GUIUtils.createLabel(new String[]{messageKey});
    }

    public static JLabel createLabel(String messageKey1, String messageKey2) {
        return GUIUtils.createLabel(new String[]{messageKey1, messageKey2});
    }

    public static JButton createButton(String messageKey) {
        return new JButton(JAPMessages.getString(messageKey));
    }

    public static JLabel createLabel(String[] messageKeys) {
        StringBuffer labelName = new StringBuffer("");
        for (int i = 0; i < messageKeys.length; ++i) {
            labelName.append(JAPMessages.getString(messageKeys[i]) + (i < messageKeys.length - 1 ? "/" : ""));
        }
        return new JLabel(labelName.toString());
    }

    public static boolean isMouseButton(MouseEvent a_event, int a_buttonMask) {
        return (a_event.getModifiers() & a_buttonMask) == a_buttonMask;
    }

    public static Clipboard getSystemClipboard() {
        Clipboard r_cb = null;
        try {
            Method getSystemSelection = (class$java$awt$Toolkit == null ? (class$java$awt$Toolkit = GUIUtils.class$("java.awt.Toolkit")) : class$java$awt$Toolkit).getMethod("getSystemSelection", new Class[0]);
            r_cb = (Clipboard)getSystemSelection.invoke((Object)Toolkit.getDefaultToolkit(), new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (r_cb == null) {
            r_cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return r_cb;
    }

    public static Vector registerLookAndFeelClasses(File a_file) throws IllegalAccessException {
        Vector<File> newFiles;
        int i;
        File file;
        if (a_file == null) {
            return new Vector();
        }
        UIManager.LookAndFeelInfo[] lnfOldInfo = UIManager.getInstalledLookAndFeels();
        Vector<File> oldFiles = new Vector<File>(lnfOldInfo.length);
        for (int i2 = 0; i2 < lnfOldInfo.length; ++i2) {
            file = ClassUtil.getClassDirectory(lnfOldInfo[i2].getClassName());
            if (file == null) continue;
            oldFiles.addElement(file);
        }
        ClassUtil.addFileToClasspath(a_file);
        ClassUtil.loadClasses(a_file);
        Vector tempLnfClasses = ClassUtil.findSubclasses(class$javax$swing$LookAndFeel == null ? (class$javax$swing$LookAndFeel = GUIUtils.class$("javax.swing.LookAndFeel")) : class$javax$swing$LookAndFeel);
        for (i = 0; i < tempLnfClasses.size(); ++i) {
            LookAndFeel lnf;
            try {
                lnf = (LookAndFeel)((Class)tempLnfClasses.elementAt(i)).newInstance();
            }
            catch (IllegalAccessException ex) {
                continue;
            }
            catch (InstantiationException ex) {
                continue;
            }
            catch (ClassCastException a_e) {
                continue;
            }
            try {
                if (!lnf.isSupportedLookAndFeel()) continue;
                UIManager.LookAndFeelInfo[] installed = UIManager.getInstalledLookAndFeels();
                boolean bInstalled = false;
                for (int j = 0; j < installed.length; ++j) {
                    if (!installed[j].getClassName().equals(lnf.getClass().getName())) continue;
                    bInstalled = true;
                }
                if (bInstalled) continue;
                UIManager.installLookAndFeel(lnf.getName(), lnf.getClass().getName());
                continue;
            }
            catch (Throwable a_e) {
                // empty catch block
            }
        }
        UIManager.LookAndFeelInfo[] lnfNewInfo = UIManager.getInstalledLookAndFeels();
        if (lnfNewInfo.length > lnfOldInfo.length) {
            newFiles = new Vector(lnfNewInfo.length - lnfOldInfo.length);
            for (i = 0; i < lnfNewInfo.length; ++i) {
                file = ClassUtil.getClassDirectory(lnfNewInfo[i].getClassName());
                if (oldFiles.contains(file)) continue;
                newFiles.addElement(file);
            }
        } else {
            newFiles = new Vector<File>();
        }
        return newFiles;
    }

    public static void resizeAllFonts(float a_resize) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            GUIUtils.adjustFontSize(key.toString(), a_resize);
        }
    }

    public static String getTextFromClipboard(Component a_requestingComponent) {
        return GUIUtils.getTextFromClipboard(a_requestingComponent, true);
    }

    public static void saveTextToClipboard(String strText, Component a_requestingComponent) {
        try {
            Clipboard cb = GUIUtils.getSystemClipboard();
            cb.setContents(new StringSelection(strText), new ClipboardOwner(){

                public void lostOwnership(Clipboard cb, Transferable co) {
                }
            });
            if (strText.equals(GUIUtils.getTextFromClipboard(a_requestingComponent, false))) {
                JAPDialog.showMessageDialog(a_requestingComponent, JAPMessages.getString(MSG_SAVED_TO_CLIP));
                return;
            }
        }
        catch (Exception e) {
            LogHolder.log(5, LogType.GUI, e);
        }
        ClipFrame cf = new ClipFrame(a_requestingComponent, JAPMessages.getString(MSG_COPY_FROM_CLIP), false);
        cf.setText(strText);
        cf.setVisible(true, false);
    }

    public static ImageIcon createScaledImageIcon(ImageIcon a_icon, IIconResizer a_resizer) {
        if (a_icon == null) {
            return null;
        }
        if (a_resizer == null) {
            return a_icon;
        }
        return new ImageIcon(a_icon.getImage().getScaledInstance((int)((double)a_icon.getIconWidth() * a_resizer.getResizeFactor()), -1, 8));
    }

    public static Icon createScaledIcon(Icon a_icon, IIconResizer a_resizer) {
        if (a_icon == null) {
            return a_icon;
        }
        return new IconScaler(a_icon, a_resizer.getResizeFactor());
    }

    public static String trim(String a_strOriginal, int a_maximumLength) {
        if (a_strOriginal == null || a_maximumLength < 4) {
            return null;
        }
        if ((a_strOriginal = JAPHtmlMultiLineLabel.removeTagsAndNewLines(a_strOriginal)).length() > a_maximumLength) {
            a_strOriginal = a_strOriginal.substring(0, a_maximumLength - 2) + "...";
        }
        return a_strOriginal;
    }

    public static String trim(String a_strOriginal) {
        return GUIUtils.trim(a_strOriginal, 60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAWTEventListener(AWTEventListener a_listener) {
        Vector vector = AWT_EVENT_LISTENERS;
        synchronized (vector) {
            if (!ms_bCapturingAWTEvents) {
                Runnable run = new Runnable(){

                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                EventQueue theQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                                while (!JAPDialog.isConsoleOnly()) {
                                    try {
                                        Class<?> classActiveEvent;
                                        AWTEvent event = theQueue.getNextEvent();
                                        try {
                                            classActiveEvent = Class.forName("java.awt.ActiveEvent");
                                        }
                                        catch (ClassNotFoundException a_e) {
                                            classActiveEvent = null;
                                        }
                                        if (classActiveEvent != null && classActiveEvent.isInstance(event)) {
                                            classActiveEvent.getMethod("dispatch", null).invoke((Object)event, (Object[])null);
                                        } else if (event.getSource() instanceof Component) {
                                            try {
                                                ((Component)event.getSource()).dispatchEvent(event);
                                            }
                                            catch (IllegalMonitorStateException a_e) {
                                                LogHolder.log(5, LogType.GUI, a_e);
                                            }
                                        } else if (event.getSource() instanceof MenuComponent) {
                                            ((MenuComponent)event.getSource()).dispatchEvent(event);
                                        }
                                        Vector vector = AWT_EVENT_LISTENERS;
                                        synchronized (vector) {
                                            for (int i = 0; i < AWT_EVENT_LISTENERS.size(); ++i) {
                                                ((AWTEventListener)AWT_EVENT_LISTENERS.elementAt(i)).eventDispatched(event);
                                            }
                                        }
                                        Thread.yield();
                                    }
                                    catch (Exception a_e) {
                                        LogHolder.log(2, LogType.GUI, a_e);
                                    }
                                }
                            }
                        });
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    new Thread(run).start();
                } else {
                    run.run();
                }
                ms_bCapturingAWTEvents = true;
            }
            if (a_listener == null) {
                return;
            }
            if (!AWT_EVENT_LISTENERS.contains(a_listener)) {
                AWT_EVENT_LISTENERS.addElement(a_listener);
            }
        }
    }

    public static void removeAWTEventListener(AWTEventListener a_listener) {
        AWT_EVENT_LISTENERS.removeElement(a_listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Point getMousePosition() {
        Object object = SYNC_MOUSE_POSITION;
        synchronized (object) {
            if (ms_mouseListener == null) {
                ms_mouseListener = new AWTEventListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void eventDispatched(AWTEvent a_event) {
                        if (a_event instanceof MouseEvent) {
                            MouseEvent mouseEvent = (MouseEvent)a_event;
                            if (a_event.getSource() != null && a_event.getSource() instanceof Component) {
                                Component component = (Component)a_event.getSource();
                                try {
                                    Object object = SYNC_MOUSE_POSITION;
                                    synchronized (object) {
                                        ms_mousePosition = component.getLocationOnScreen();
                                        ms_mousePosition.x += mouseEvent.getX();
                                        ms_mousePosition.y += mouseEvent.getY();
                                    }
                                }
                                catch (IllegalComponentStateException a_e) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                };
                GUIUtils.addAWTEventListener(ms_mouseListener);
            }
        }
        if (ms_mousePosition == null) {
            return null;
        }
        return new Point(GUIUtils.ms_mousePosition.x, GUIUtils.ms_mousePosition.y);
    }

    public static Point getRelativePosition(Point a_positionOnScreen, Component a_component) {
        Point componentPoint;
        if (a_positionOnScreen == null || a_component == null) {
            return null;
        }
        Point currentPoint = a_positionOnScreen;
        if (currentPoint == null) {
            return null;
        }
        try {
            componentPoint = a_component.getLocationOnScreen();
        }
        catch (IllegalComponentStateException a_e) {
            componentPoint = a_component.getLocation();
        }
        if (currentPoint.x < componentPoint.x - 1 || currentPoint.x > componentPoint.x + a_component.getSize().width + 1 || currentPoint.y < componentPoint.y - 1 || currentPoint.y > componentPoint.y + a_component.getSize().height + 1) {
            return null;
        }
        currentPoint.x -= componentPoint.x;
        currentPoint.y -= componentPoint.y;
        return currentPoint;
    }

    public static Point getMousePosition(Component a_component) {
        return GUIUtils.getRelativePosition(GUIUtils.getMousePosition(), a_component);
    }

    private static Screen getOverlappingScreen(Screen a_screen, Window a_window) {
        if (a_screen == null) {
            return null;
        }
        Screen defaultScreen = new Screen(new Point(0, 0), GUIUtils.getDefaultScreenBounds(a_window));
        if (defaultScreen.getX() == a_screen.getX() && defaultScreen.getY() == a_screen.getY() && defaultScreen.getWidth() == a_screen.getWidth() && defaultScreen.getHeight() == a_screen.getHeight()) {
            return a_screen;
        }
        int x = a_screen.getX();
        int y = a_screen.getY();
        int width = a_screen.getWidth();
        int height = a_screen.getHeight();
        boolean bOverlap = false;
        if (a_screen.getY() < defaultScreen.getY() && a_screen.getY() + a_screen.getHeight() > defaultScreen.getY() || defaultScreen.getY() < a_screen.getY() && defaultScreen.getY() + defaultScreen.getHeight() > a_screen.getY()) {
            bOverlap = true;
            LogHolder.log(5, LogType.GUI, "Found overlapping screen.");
            y = Math.max(a_screen.getY(), defaultScreen.getY());
            height = Math.min(a_screen.getY() + a_screen.getHeight(), defaultScreen.getY() + defaultScreen.getHeight() - Math.abs(a_screen.getY() - defaultScreen.getY()));
        }
        if (a_screen.getX() < defaultScreen.getX() && a_screen.getX() + a_screen.getWidth() > defaultScreen.getX() || defaultScreen.getX() < a_screen.getX() && defaultScreen.getX() + defaultScreen.getWidth() > a_screen.getX()) {
            bOverlap = true;
            x = Math.max(a_screen.getX(), defaultScreen.getX());
            width = Math.min(a_screen.getX() + a_screen.getWidth(), defaultScreen.getX() + defaultScreen.getWidth() - Math.abs(a_screen.getX() - defaultScreen.getX()));
        }
        if (bOverlap) {
            a_screen = new Screen(new Point(x, y), new Rectangle(width, height));
        }
        return a_screen;
    }

    private static String getTextFromClipboard(Component a_requestingComponent, boolean a_bUseTextArea) {
        Clipboard cb = GUIUtils.getSystemClipboard();
        String strText = null;
        Transferable data = cb.getContents(a_requestingComponent);
        if (data != null && data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                strText = (String)data.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception a_e) {
                LogHolder.log(5, LogType.GUI, a_e);
            }
        }
        if (a_bUseTextArea && strText == null) {
            ClipFrame cf = new ClipFrame(a_requestingComponent, JAPMessages.getString(MSG_PASTE_FILE), true);
            cf.setVisible(true, false);
            strText = cf.getText();
        }
        return strText;
    }

    private static Rectangle getDefaultScreenBounds(Window a_window) {
        Rectangle screenBounds;
        if (a_window == null) {
            return null;
        }
        try {
            Object graphicsEnvironment = Class.forName("java.awt.GraphicsEnvironment").getMethod("getLocalGraphicsEnvironment", null).invoke(null, (Object[])null);
            Object graphicsDevice = graphicsEnvironment.getClass().getMethod("getDefaultScreenDevice", null).invoke(graphicsEnvironment, (Object[])null);
            Object graphicsConfiguration = graphicsDevice.getClass().getMethod("getDefaultConfiguration", null).invoke(graphicsDevice, (Object[])null);
            screenBounds = (Rectangle)graphicsConfiguration.getClass().getMethod("getBounds", null).invoke(graphicsConfiguration, (Object[])null);
        }
        catch (Exception a_e) {
            screenBounds = new Rectangle(new Point(0, 0), a_window.getToolkit().getScreenSize());
        }
        return screenBounds;
    }

    private static void adjustFontSize(Object a_fontObject, float a_resize) {
        try {
            UIDefaults defaults = UIManager.getDefaults();
            Font font = defaults.getFont(a_fontObject);
            defaults.put(a_fontObject, new FontUIResource(font.getName(), font.getStyle(), Math.round((float)font.getSize() * a_resize)));
        }
        catch (Exception a_e) {
            LogHolder.log(3, LogType.GUI, a_e);
        }
    }

    public static Dimension getMaxSize(Vector aComponents) {
        Dimension targetSize = new Dimension(0, 0);
        int targetWidth = 0;
        int targetHeight = 0;
        Enumeration widgets = aComponents.elements();
        while (widgets.hasMoreElements()) {
            JComponent curWidget = (JComponent)widgets.nextElement();
            targetWidth = Math.max(targetSize.width, curWidget.getPreferredSize().width);
            targetHeight = Math.max(targetSize.height, curWidget.getPreferredSize().height);
            targetSize.setSize(targetWidth, targetHeight);
        }
        targetSize.setSize(targetWidth, targetHeight);
        return targetSize;
    }

    public static Dimension getTotalSize(Vector aComponents) {
        int totalWidth = 0;
        int totalHeight = 0;
        Enumeration widgets = aComponents.elements();
        while (widgets.hasMoreElements()) {
            JComponent curWidget = (JComponent)widgets.nextElement();
            totalWidth += curWidget.getPreferredSize().width;
            totalHeight += curWidget.getPreferredSize().height;
        }
        return new Dimension(totalWidth, totalHeight);
    }

    public static int showMonitoredFileChooser(JFileChooser a_chooser, Component a_parent, String a_dialogType) {
        int result;
        if (a_chooser == null) {
            throw new NullPointerException("No file chooser given!");
        }
        LogHolder.log(4, LogType.GUI, "Showing monitored file chooser...");
        final class Class_showMonitoredFileChooser_Runnable
        implements Runnable {
            public volatile boolean m_bFinished;
            private final /* synthetic */ JFileChooser val$a_chooser;

            Class_showMonitoredFileChooser_Runnable(boolean b, JFileChooser jFileChooser) {
                this.val$a_chooser = jFileChooser;
                this.m_bFinished = b;
            }

            public void run() {
                try {
                    Thread.sleep(2000L);
                    LogHolder.log(4, LogType.GUI, "Waiting in timeout thread of monitored file chooser...");
                    if (!(this.val$a_chooser.isVisible() && this.val$a_chooser.isShowing() || this.m_bFinished)) {
                        LogHolder.log(1, LogType.GUI, "File chooser dialog blocked and is now interrupted!");
                        GUIUtils.interruptAWTEventThread();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        Class_showMonitoredFileChooser_Runnable _showMonitoredFileChooser_Runnable = new Class_showMonitoredFileChooser_Runnable(false, a_chooser);
        Thread timeoutThread = new Thread(_showMonitoredFileChooser_Runnable);
        timeoutThread.start();
        try {
            result = a_dialogType == FILE_CHOOSER_OPEN ? a_chooser.showOpenDialog(a_parent) : (a_dialogType == FILE_CHOOSER_SAVE ? a_chooser.showSaveDialog(a_parent) : a_chooser.showDialog(a_parent, a_dialogType));
        }
        catch (Exception a_e) {
            LogHolder.log(1, LogType.GUI, a_e);
            result = -1;
        }
        LogHolder.log(4, LogType.GUI, "Finished monitored file chooser. Stopping thread.");
        _showMonitoredFileChooser_Runnable.m_bFinished = true;
        timeoutThread.interrupt();
        LogHolder.log(4, LogType.GUI, "Stopped monitored file chooser thread.");
        return result;
    }

    public static void setSizes(Vector aComponents, Dimension aDimension) {
        Enumeration components = aComponents.elements();
        while (components.hasMoreElements()) {
            JComponent curComp = (JComponent)components.nextElement();
            curComp.setPreferredSize(new Dimension(aDimension.width, aDimension.height));
            curComp.setMaximumSize(new Dimension(aDimension.width, aDimension.height));
        }
    }

    public static void setEqualWidths(Vector aComponents, Dimension aDimension) {
        Enumeration components = aComponents.elements();
        while (components.hasMoreElements()) {
            JComponent curComp = (JComponent)components.nextElement();
            double oldHeight = curComp.getPreferredSize().height;
            curComp.setPreferredSize(new Dimension(aDimension.width, (int)oldHeight));
            curComp.setMaximumSize(new Dimension(aDimension.width, (int)oldHeight));
        }
    }

    public static JAPDialog.ILinkedInformation createURLLink(URL a_url, String a_optionalText) {
        return GUIUtils.createURLLink(a_url, a_optionalText, null);
    }

    public static JAPDialog.ILinkedInformation createURLLink(final URL a_url, final String a_optionalText, String a_helpContext) {
        if (a_url == null) {
            return null;
        }
        JAPDialog.LinkedHelpContext link = new JAPDialog.LinkedHelpContext(a_helpContext){

            public int getType() {
                return 1;
            }

            public void clicked(boolean a_bState) {
                AbstractOS.getInstance().openURL(a_url);
            }

            public String getMessage() {
                if (a_optionalText == null || a_optionalText.trim().length() == 0) {
                    return a_url.toString();
                }
                return a_optionalText;
            }
        };
        return link;
    }

    public static void exitWithNoMessagesError(String a_resourceBundleFilename) {
        JAPAWTMsgBox.MsgBox("File not found: " + a_resourceBundleFilename + "_en" + ".properties\nYour package of JAP may be corrupted.\n" + "Try again to download or install the package.", "Error");
        System.exit(1);
    }

    public static String getCountryFromServiceLocation(ServiceLocation a_loc) {
        if (a_loc == null) {
            return "";
        }
        String strLocation = "";
        if (a_loc.getCity() != null && a_loc.getCity().trim().length() > 0) {
            strLocation = a_loc.getCity().trim();
        }
        if (a_loc.getState() != null && a_loc.getState().trim().length() > 0 && !strLocation.equals(a_loc.getState().trim())) {
            if (strLocation.length() > 0) {
                strLocation = strLocation + ", ";
            }
            strLocation = strLocation + a_loc.getState().trim();
        }
        if (a_loc.getCountryCode() != null && a_loc.getCountryCode().trim().length() > 0) {
            if (strLocation.length() > 0) {
                strLocation = strLocation + ", ";
            }
            try {
                strLocation = strLocation + new CountryMapper(a_loc.getCountryCode(), JAPMessages.getLocale()).toString();
            }
            catch (IllegalArgumentException a_e) {
                strLocation = strLocation + a_loc.getCountryCode().trim();
            }
        }
        if (strLocation.trim().length() == 0) {
            return "N/A";
        }
        return strLocation;
    }

    private static void interruptAWTEventThread() {
        Thread[] allThreads = new Thread[Thread.activeCount()];
        Thread.enumerate(allThreads);
        for (int i = 0; i < allThreads.length; ++i) {
            if (!allThreads[i].getName().startsWith("AWT-EventQueue-")) continue;
            try {
                LogHolder.log(0, LogType.GUI, "Interrupting AWT event dispatch thread!");
                allThreads[i].interrupt();
                continue;
            }
            catch (Throwable a_e) {
                LogHolder.log(0, LogType.GUI, a_e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SYNC_MOUSE_POSITION = new Object();
        AWT_EVENT_LISTENERS = new Vector();
        ms_resizer = DEFAULT_RESIZER = new IIconResizer(){

            public double getResizeFactor() {
                return 1.0;
            }
        };
        ms_nativeGUILibrary = DUMMY_GUI_LIBRARY = new NativeGUILibrary(){

            public boolean setAlwaysOnTop(Window a_window, boolean a_bOnTop) {
                return false;
            }

            public boolean isAlwaysOnTop(Window a_window) {
                return false;
            }
        };
        RESIZER = new IIconResizer(){

            public double getResizeFactor() {
                return ms_resizer.getResizeFactor();
            }
        };
        ms_iconCache = new Hashtable();
    }

    private static class IconScaler
    implements Icon {
        private static Class GRAPHICS_2D;
        private Icon m_icon;
        private double m_scaleWidth;
        private double m_scaleHeight;

        public IconScaler(Icon icon, double a_scale) {
            this(icon, a_scale, a_scale);
        }

        public IconScaler(Icon icon, double a_scaleWidth, double a_scaleHeight) {
            this.m_icon = icon;
            if (GRAPHICS_2D != null) {
                this.m_scaleWidth = a_scaleWidth;
                this.m_scaleHeight = a_scaleHeight;
            } else {
                this.m_scaleWidth = 1.0;
                this.m_scaleHeight = 1.0;
            }
        }

        public int getIconHeight() {
            return (int)((double)this.m_icon.getIconHeight() * this.m_scaleHeight);
        }

        public int getIconWidth() {
            return (int)((double)this.m_icon.getIconWidth() * this.m_scaleWidth);
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            IconScaler.scale(g, this.m_scaleWidth, this.m_scaleHeight);
            this.m_icon.paintIcon(c, g, x, y);
            IconScaler.scale(g, 1.0 / this.m_scaleWidth, 1.0 / this.m_scaleHeight);
        }

        private static void scale(Graphics a_graphics, double a_scaleWidth, double a_scaleHeight) {
            if (GRAPHICS_2D != null) {
                try {
                    GRAPHICS_2D.getMethod("scale", Double.TYPE, Double.TYPE).invoke((Object)a_graphics, new Double(a_scaleWidth), new Double(a_scaleHeight));
                }
                catch (Exception a_e) {
                    LogHolder.log(3, LogType.GUI, a_e);
                }
            }
        }

        static {
            try {
                GRAPHICS_2D = Class.forName("java.awt.Graphics2D");
            }
            catch (ClassNotFoundException a_e) {
                GRAPHICS_2D = null;
            }
        }
    }

    private static class ToolTipMouseListener
    extends MouseAdapter {
        private ToolTipMouseListener() {
        }

        public void mouseEntered(MouseEvent e) {
            if (!(e.getComponent() instanceof JComponent)) {
                return;
            }
            JComponent c = (JComponent)e.getComponent();
            ActionListener action = null;
            try {
                Class<?> classActionMap = Class.forName("javax.swing.ActionMap");
                Object map = (class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = GUIUtils.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).getMethod("getActionMap", new Class[0]).invoke((Object)c, new Object[0]);
                action = (Action)classActionMap.getMethod("get", class$java$lang$Object == null ? (class$java$lang$Object = GUIUtils.class$("java.lang.Object")) : class$java$lang$Object).invoke(map, "postTip");
            }
            catch (Exception a_e) {
                LogHolder.log(2, LogType.GUI, a_e);
            }
            if (action != null) {
                action.actionPerformed(new ActionEvent(c, 1001, "postTip"));
            }
        }
    }

    public static class Screen {
        private Point m_location;
        private Rectangle m_bounds;

        public Screen(Point a_location, Rectangle a_bounds) {
            this.m_location = a_location;
            this.m_bounds = a_bounds;
        }

        public int getX() {
            return this.m_location.x;
        }

        public int getY() {
            return this.m_location.y;
        }

        public int getWidth() {
            return this.m_bounds.width;
        }

        public int getHeight() {
            return this.m_bounds.height;
        }

        public Point getLocation() {
            return this.m_location;
        }

        public Rectangle getBounds() {
            return this.m_bounds;
        }

        public String toString() {
            return "x=" + this.getX() + " " + "y=" + this.getY() + " " + "width=" + this.getWidth() + " " + "height=" + this.getHeight();
        }
    }

    public static interface AWTEventListener {
        public void eventDispatched(AWTEvent var1);
    }

    public static class WindowDocker {
        private JobQueue m_queue;
        private Component m_component;
        private InternalListener m_listener;
        private Window m_parentWindow;

        public WindowDocker(Component a_window) {
            this.m_component = a_window;
            this.m_listener = new InternalListener();
            this.m_component.addMouseListener(this.m_listener);
            this.m_component.addMouseMotionListener(this.m_listener);
            this.m_parentWindow = GUIUtils.getParentWindow(a_window);
            this.m_queue = new JobQueue("Docking queue for window: " + a_window.getName());
        }

        public void finalize() {
            this.m_queue.stop();
            this.m_queue = null;
            this.m_component.removeMouseListener(this.m_listener);
            this.m_component.removeMouseMotionListener(this.m_listener);
            this.m_component.removeComponentListener(this.m_listener);
            this.m_listener = null;
        }

        private class InternalListener
        extends MouseAdapter
        implements MouseMotionListener,
        ComponentListener,
        IDockInterface {
            private boolean m_bIsDragging = false;
            private Point m_startPoint;
            private final Object SYNC = new Object();

            private InternalListener() {
            }

            public void componentHidden(ComponentEvent a_event) {
            }

            public void componentResized(ComponentEvent a_event) {
            }

            public void componentShown(ComponentEvent a_event) {
            }

            public void componentMoved(ComponentEvent a_event) {
                if (!this.m_bIsDragging) {
                    this.move(null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseReleased(MouseEvent e) {
                Object object = this.SYNC;
                synchronized (object) {
                    this.m_bIsDragging = false;
                }
            }

            public void mouseMoved(MouseEvent e) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseDragged(MouseEvent e) {
                Object object = this.SYNC;
                synchronized (object) {
                    if (!this.m_bIsDragging) {
                        this.m_bIsDragging = true;
                        this.m_startPoint = e.getPoint();
                    } else {
                        Point endPoint = e.getPoint();
                        Point aktLocation = WindowDocker.this.m_parentWindow.getLocationOnScreen();
                        int x = aktLocation.x + endPoint.x - this.m_startPoint.x;
                        int y = aktLocation.y + endPoint.y - this.m_startPoint.y;
                        this.move(new Point(x, y));
                    }
                }
            }

            private void move(final Point a_location) {
                WindowDocker.this.m_queue.addJob(new JobQueue.Job(){

                    public void runJob() {
                        Screen currentScreen = GUIUtils.getCurrentScreen(WindowDocker.this.m_parentWindow);
                        boolean bMove = a_location != null;
                        Point location = a_location;
                        if (location == null) {
                            location = WindowDocker.this.m_parentWindow.getLocationOnScreen();
                        }
                        int x = location.x;
                        int y = location.y;
                        int maxX = currentScreen.getWidth() + currentScreen.getX();
                        int maxY = currentScreen.getHeight() + currentScreen.getY();
                        if (x != currentScreen.getX() && Math.abs(x - currentScreen.getX()) < 10) {
                            bMove = true;
                            x = currentScreen.getX();
                        } else if (x + ((WindowDocker)((InternalListener)InternalListener.this).WindowDocker.this).m_parentWindow.getSize().width > maxX - 10 && x + ((WindowDocker)((InternalListener)InternalListener.this).WindowDocker.this).m_parentWindow.getSize().width <= maxX + 10) {
                            bMove = true;
                            x = maxX - ((WindowDocker)((InternalListener)InternalListener.this).WindowDocker.this).m_parentWindow.getSize().width;
                        }
                        if (y != currentScreen.getY() && Math.abs(y - currentScreen.getY()) < 10) {
                            bMove = true;
                            y = currentScreen.getY();
                        } else if (y + ((WindowDocker)((InternalListener)InternalListener.this).WindowDocker.this).m_parentWindow.getSize().height > maxY - 10 && y + ((WindowDocker)((InternalListener)InternalListener.this).WindowDocker.this).m_parentWindow.getSize().height <= maxY + 10) {
                            bMove = true;
                            y = maxY - ((WindowDocker)((InternalListener)InternalListener.this).WindowDocker.this).m_parentWindow.getSize().height;
                        }
                        if (bMove) {
                            WindowDocker.this.m_parentWindow.setLocation(x, y);
                        }
                    }
                });
            }
        }

        private static interface IDockInterface {
            public static final int DOCK_DISTANCE = 10;
        }
    }

    public static interface IIconResizer {
        public double getResizeFactor();
    }

    public static interface NativeGUILibrary {
        public boolean setAlwaysOnTop(Window var1, boolean var2);

        public boolean isAlwaysOnTop(Window var1);
    }
}

