/*
 * Decompiled with CFR 0.152.
 */
package anon.tor.cells;

import anon.tor.cells.CreatedCell;
import anon.tor.cells.DestroyCell;
import anon.tor.cells.PaddingCell;
import anon.tor.cells.RelayCell;

public abstract class Cell {
    public static final int CELL_SIZE = 512;
    public static final int CELL_PAYLOAD_SIZE = 509;
    private int m_circID = 0;
    private int m_command;
    protected byte[] m_payload;

    protected Cell(int command) {
        this.m_command = command;
        this.m_payload = new byte[509];
    }

    protected Cell(int command, int circID) {
        this(command);
        this.m_circID = circID;
    }

    protected Cell(int command, int circID, byte[] payload) {
        this(command, circID);
        this.setPayload(payload, 0);
    }

    protected Cell(int command, int circID, byte[] payload, int offset) {
        this(command, circID);
        this.setPayload(payload, offset);
    }

    public byte[] getCellData() {
        byte[] buff = new byte[512];
        buff[0] = (byte)(this.m_circID >> 8 & 0xFF);
        buff[1] = (byte)(this.m_circID & 0xFF);
        buff[2] = (byte)(this.m_command & 0xFF);
        System.arraycopy(this.m_payload, 0, buff, 3, 509);
        return buff;
    }

    public int getCommand() {
        return this.m_command;
    }

    public int getCircuitID() {
        return this.m_circID;
    }

    public byte[] getPayload() {
        return this.m_payload;
    }

    public void setPayload(byte[] payload, int offset) {
        int len = Math.min(509, payload.length);
        System.arraycopy(payload, offset, this.m_payload, 0, len);
    }

    public static Cell createCell(byte[] cellData) {
        if (cellData.length != 512) {
            return null;
        }
        Cell cell = null;
        int cid = (cellData[0] & 0xFF) << 8 | cellData[1] & 0xFF;
        int type = cellData[2] & 0xFF;
        switch (type) {
            case 2: {
                cell = new CreatedCell(cid, cellData, 3);
                break;
            }
            case 3: {
                cell = new RelayCell(cid, cellData, 3);
                break;
            }
            case 4: {
                cell = new DestroyCell(cid, cellData, 3);
                break;
            }
            case 0: {
                cell = new PaddingCell(cid, cellData, 3);
                break;
            }
            default: {
                cell = null;
            }
        }
        return cell;
    }
}

