/*
 * Decompiled with CFR 0.152.
 */
package anon.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import logging.LogHolder;
import logging.LogType;

final class DirectProxyResponse
implements Runnable {
    private int m_threadNumber;
    private static int ms_threadCount;
    private OutputStream m_outputStream;
    private InputStream m_inputStream;

    public DirectProxyResponse(InputStream in, OutputStream out) {
        this.m_inputStream = in;
        this.m_outputStream = out;
    }

    public void run() {
        this.m_threadNumber = this.getThreadNumber();
        LogHolder.log(7, LogType.NET, "R(" + this.m_threadNumber + ") - Response thread started.");
        try {
            int len;
            byte[] buff = new byte[1000];
            while ((len = this.m_inputStream.read(buff)) != -1) {
                if (len <= 0) continue;
                if (LogHolder.isLogged(7, LogType.NET)) {
                    LogHolder.log(7, LogType.NET, "R(" + this.m_threadNumber + ") - " + new String(buff, 0, len));
                }
                this.m_outputStream.write(buff, 0, len);
                this.m_outputStream.flush();
            }
            LogHolder.log(7, LogType.NET, "R(" + this.m_threadNumber + ") - EOF from Server.");
        }
        catch (IOException ioe) {
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, "R(" + this.m_threadNumber + ") - Exception during transmission: " + e);
        }
        try {
            this.m_inputStream.close();
            this.m_outputStream.close();
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.NET, "R(" + this.m_threadNumber + ") - Exception while closing: " + e.toString());
        }
        LogHolder.log(7, LogType.NET, "R(" + this.m_threadNumber + ") - Response thread stopped.");
    }

    private synchronized int getThreadNumber() {
        return ms_threadCount++;
    }
}

