/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.AnonServerDescription;
import anon.crypto.CertPath;
import anon.crypto.IVerifyable;
import anon.crypto.MultiCertPath;
import anon.crypto.SignatureVerifier;
import anon.crypto.X509DistinguishedName;
import anon.crypto.XMLSignature;
import anon.infoservice.AbstractDistributableCertifiedDatabaseEntry;
import anon.infoservice.DataRetentionInformation;
import anon.infoservice.Database;
import anon.infoservice.IServiceContextContainer;
import anon.infoservice.InfoServiceHolder;
import anon.infoservice.ListenerInterface;
import anon.infoservice.MixInfo;
import anon.infoservice.MixPosition;
import anon.infoservice.PerformanceEntry;
import anon.infoservice.ServiceLocation;
import anon.infoservice.ServiceOperator;
import anon.infoservice.StatusInfo;
import anon.pay.PaymentInstanceDBEntry;
import anon.pay.xml.XMLEasyCC;
import anon.util.CountryMapper;
import anon.util.Util;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import anon.util.ZLibTools;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MixCascade
extends AbstractDistributableCertifiedDatabaseEntry
implements AnonServerDescription,
IVerifyable,
IServiceContextContainer,
Database.IWebInfo,
ListenerInterface.IListenerInterfaceGetter {
    public static final String SUPPORTED_PAYMENT_PROTOCOL_VERSION = "2.0";
    public static final String TC_REQUIRED_VERSION_SUFFIX = "tc";
    public static final int DISTRIBUTION_MIN = 0;
    public static final int DISTRIBUTION_MAX = 6;
    public static final String XML_ELEMENT_NAME = "MixCascade";
    public static final String XML_ELEMENT_CONTAINER_NAME = "MixCascades";
    private static final String XML_ATTR_USER_DEFINED = "userDefined";
    private static final String XML_ATTR_STUDY = "study";
    private static final String XML_ATTR_MAX_USERS = "maxUsers";
    private static final String XML_ATTR_PAYMENT = "payment";
    public static final String XML_ELEMENT_WEBINFO_CONTAINER = "CascadeWebInfos";
    public static final String XML_ELEMENT_WEBINFO = "CascadeWebInfo";
    public static final String XML_ELEMENT_WEBINFO_CASCADE_NAME = "CascadeName";
    public static final String XML_ELEMENT_WEBINFO_NAME = "Name";
    public static final String XML_ELEMENT_WEBINFO_COMPOSED_NAME = "ComposedName";
    public static final String XML_ELEMENT_WEBINFO_CURR_USERS = "CurrentUsers";
    public static final String XML_ATTR_WEBINFO_OPERATOR_COUNT = "operatorCount";
    public static final String XML_ATTR_WEBINFO_DISTRIBUTION = "distribution";
    public static final String XML_ATTR_WEBINFO_MIX_COUNTRY = "mixCountry";
    public static final String XML_ATTR_WEBINFO_MIX_POSITION = "mixPosition";
    public static final String XML_ATTR_WEBINFO_OP_COUNTRY = "operatorCountry";
    public static final String INFOSERVICE_COMMAND_WEBINFOS = "/cascadewebinfos";
    public static final String INFOSERVICE_COMMAND_WEBINFO = "/cascadewebinfo/";
    public static final int MAX_CASCADE_NAME_LENGTH = 35;
    private final Object CACHE_HOSTS_PORT = new Object();
    private boolean m_bDefaultVerified = false;
    private boolean m_bImplicitTrust = false;
    private boolean m_bSock5Support = false;
    private String m_strConcatenatedPriceCertHashes;
    private DataRetentionInformation m_dataRetentionInfo;
    private String m_mixCascadeId;
    private long m_lastUpdate;
    private String m_strName;
    private final Object SYNC_NAME = new Object();
    private Vector m_decomposedCascadeName;
    private Vector m_listenerInterfaces;
    private Hashtable m_hashListenerInterfaces;
    private Vector m_mixIds;
    private String m_strMixIds;
    private String m_piid = "";
    private MixInfo[] m_mixInfos;
    private String m_strMixNames;
    private int m_nrPriceCerts = 0;
    private Vector m_mixNodes;
    private long m_serial;
    private Element m_xmlStructure;
    private byte[] m_compressedXmlStructure;
    private XMLSignature m_signature;
    private MultiCertPath m_certPath;
    private int m_nrCountries = 0;
    private int m_nrOperators = 0;
    private int m_nrOperatorsCountForDistribution = 0;
    private int m_nrOperatorsShown = 0;
    private int m_distributionPoints = 0;
    private boolean[] m_mixCertVerifiedAndValid;
    private Object SYNC_OPERATORS_AND_COUNTRIES = new Object();
    private volatile boolean termsAndConditionsConfirmationRequired = false;
    private boolean m_userDefined;
    private boolean m_bStudy = false;
    private int m_maxUsers = 0;
    private String m_strPorts;
    private String m_strHosts;
    private boolean m_isPayment;
    private long m_prepaidInterval = 4000000L;
    private String m_mixProtocolVersion;
    private String m_paymentProtocolVersion;
    private Hashtable m_priceCertificateHashes = new Hashtable();
    private Vector m_priceCertificates = new Vector();
    private boolean m_bFromCascade;
    private String m_context;
    private String m_strAccessControlPreSharedSecret = null;
    static /* synthetic */ Class class$anon$pay$PaymentInstanceDBEntry;
    static /* synthetic */ Class class$anon$infoservice$StatusInfo;
    static /* synthetic */ Class class$anon$infoservice$PerformanceEntry;

    public MixCascade(byte[] a_bCompressedMixCascadeNode) throws XMLParseException {
        this(a_bCompressedMixCascadeNode, null, 0L, null);
    }

    public MixCascade(Element a_mixCascadeNode) throws XMLParseException {
        this(null, a_mixCascadeNode, 0L, null);
    }

    public MixCascade(Element a_mixCascadeNode, long a_expireTime) throws XMLParseException {
        this(null, a_mixCascadeNode, a_expireTime, null);
    }

    public MixCascade(Element a_mixCascadeNode, long a_expireTime, String a_mixIDFromCascade) throws XMLParseException {
        this(null, a_mixCascadeNode, a_expireTime, a_mixIDFromCascade);
    }

    private MixCascade(byte[] a_compressedMixCascadeNode, Element a_mixCascadeNode, long a_expireTime, String a_mixIDFromCascade) throws XMLParseException {
        super(a_expireTime <= 0L ? System.currentTimeMillis() + 900000L : a_expireTime);
        Vector visibleAddresses;
        NodeList mixesNodes;
        boolean bl = this.m_bFromCascade = a_mixIDFromCascade != null;
        if (a_mixCascadeNode == null && a_compressedMixCascadeNode == null) {
            throw new XMLParseException("##__null__##");
        }
        if (a_mixCascadeNode == null) {
            a_mixCascadeNode = (Element)XMLUtil.getFirstChildByName(XMLUtil.toXMLDocument(ZLibTools.decompress(a_compressedMixCascadeNode)), XML_ELEMENT_NAME);
        }
        try {
            this.m_signature = SignatureVerifier.getInstance().getVerifiedXml(a_mixCascadeNode, 1);
            if (this.m_signature != null) {
                this.m_certPath = this.m_signature.getMultiCertPath();
            } else {
                LogHolder.log(7, LogType.MISC, "No signature node found while looking for MixCascade certificate.");
            }
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.MISC, "Error while looking for appended certificates in the MixCascade structure: " + e.toString());
        }
        this.m_userDefined = XMLUtil.parseAttribute((Node)a_mixCascadeNode, XML_ATTR_USER_DEFINED, false);
        this.m_bStudy = XMLUtil.parseAttribute((Node)a_mixCascadeNode, XML_ATTR_STUDY, false);
        this.m_maxUsers = XMLUtil.parseAttribute((Node)a_mixCascadeNode, XML_ATTR_MAX_USERS, 0);
        this.m_maxUsers = Math.min(this.m_maxUsers, 9999);
        if (a_mixCascadeNode == null || !a_mixCascadeNode.getNodeName().equals(XML_ELEMENT_NAME)) {
            throw new XMLParseException(XML_ELEMENT_NAME);
        }
        this.m_mixCascadeId = XMLUtil.parseAttribute((Node)a_mixCascadeNode, "id", null);
        if (this.m_mixCascadeId == null) {
            Node nodeMix = XMLUtil.getFirstChildByName(XMLUtil.getFirstChildByName(a_mixCascadeNode, "Mixes"), "Mix");
            this.m_mixCascadeId = XMLUtil.parseAttribute(nodeMix, "id", a_mixIDFromCascade);
        }
        if (!this.checkId()) {
            throw new XMLParseException("##__root__##", "Malformed Mix-Cascade ID: " + this.m_mixCascadeId);
        }
        this.m_mixProtocolVersion = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_mixCascadeNode, "MixProtocolVersion"), null);
        if (this.m_mixProtocolVersion != null) {
            this.m_mixProtocolVersion = this.m_mixProtocolVersion.trim();
            if (this.m_mixProtocolVersion.endsWith(TC_REQUIRED_VERSION_SUFFIX)) {
                this.m_mixProtocolVersion = this.m_mixProtocolVersion.substring(0, this.m_mixProtocolVersion.length() - TC_REQUIRED_VERSION_SUFFIX.length());
                this.termsAndConditionsConfirmationRequired = true;
            }
        }
        Node payNode = XMLUtil.getFirstChildByName(a_mixCascadeNode, "Payment");
        this.m_isPayment = XMLUtil.parseAttribute(payNode, "required", false);
        this.m_paymentProtocolVersion = XMLUtil.parseAttribute(payNode, "version", SUPPORTED_PAYMENT_PROTOCOL_VERSION);
        this.m_prepaidInterval = XMLUtil.parseAttribute(payNode, "prepaidInterval", 4000001L);
        this.m_piid = XMLUtil.parseAttribute(payNode, "piid", "");
        this.m_context = XMLUtil.parseAttribute((Node)a_mixCascadeNode, "context", null);
        if (this.m_context == null || this.m_context.equals("de.jondos.jondonym")) {
            this.m_context = this.m_isPayment ? "jondonym.premium" : "jondonym";
        }
        if (!this.m_bFromCascade) {
            NodeList networkNodes = a_mixCascadeNode.getElementsByTagName("Network");
            if (networkNodes.getLength() == 0) {
                throw new XMLParseException("Network");
            }
            Element networkNode = (Element)networkNodes.item(0);
            NodeList listenerInterfacesNodes = networkNode.getElementsByTagName("ListenerInterfaces");
            if (listenerInterfacesNodes.getLength() == 0) {
                throw new XMLParseException("ListenerInterfaces");
            }
            Element listenerInterfacesNode = (Element)listenerInterfacesNodes.item(0);
            NodeList listenerInterfaceNodes = listenerInterfacesNode.getElementsByTagName("ListenerInterface");
            if (listenerInterfaceNodes.getLength() == 0) {
                throw new XMLParseException("ListenerInterface");
            }
            this.m_listenerInterfaces = new Vector();
            this.m_hashListenerInterfaces = new Hashtable();
            for (int i = 0; i < listenerInterfaceNodes.getLength(); ++i) {
                Element listenerInterfaceNode = (Element)listenerInterfaceNodes.item(i);
                ListenerInterface listenerInterface = new ListenerInterface(listenerInterfaceNode);
                this.m_listenerInterfaces.addElement(listenerInterface);
                this.m_hashListenerInterfaces.put(listenerInterface.getId(), listenerInterface);
            }
            ListenerInterface.blockInterfacesFromDatabase(this);
        }
        if ((mixesNodes = a_mixCascadeNode.getElementsByTagName("Mixes")).getLength() == 0) {
            throw new XMLParseException("Mixes");
        }
        Element mixesNode = (Element)mixesNodes.item(0);
        int nrOfMixes = Integer.parseInt(mixesNode.getAttribute("count"));
        NodeList mixNodes = mixesNode.getElementsByTagName("Mix");
        if (mixNodes.getLength() == 0 || nrOfMixes != mixNodes.getLength()) {
            throw new XMLParseException("Mix");
        }
        this.m_mixIds = new Vector();
        this.m_mixNodes = new Vector();
        for (int i = 0; i < mixNodes.getLength(); ++i) {
            Element mixNode = (Element)mixNodes.item(i);
            this.m_mixIds.addElement(mixNode.getAttribute("id"));
            if (i == 0 && !this.isUserDefined() && !this.m_mixIds.lastElement().equals(this.m_mixCascadeId)) {
                throw new XMLParseException("##__root__##", "Cascade ID not ID of first mix: " + this.m_mixCascadeId);
            }
            this.m_mixNodes.addElement(mixNode);
        }
        this.m_mixInfos = new MixInfo[mixNodes.getLength()];
        int countDataRetentionMixes = 0;
        for (int i = 0; i < mixNodes.getLength(); ++i) {
            try {
                this.m_mixInfos[i] = new MixInfo((Element)mixNodes.item(i), a_expireTime, true);
                if (i + 1 == mixNodes.getLength()) {
                    this.m_bSock5Support = this.m_mixInfos[i].isSocks5Supported();
                }
                if (this.m_mixInfos[i].getPriceCertificate() != null) {
                    if (i == 0) {
                        this.m_piid = this.m_mixInfos[i].getPriceCertificate().getBiID();
                    }
                    if (i == 0 && this.m_prepaidInterval > 4000000L) {
                        this.m_prepaidInterval = this.m_mixInfos[i].getPrepaidInterval();
                    }
                    this.m_priceCertificates.addElement(this.m_mixInfos[i].getPriceCertificate());
                    this.m_priceCertificateHashes.put(new MixPosition(i, this.m_mixInfos[i].getId()), this.m_mixInfos[i].getPriceCertificate().getHashValue());
                    ++this.m_nrPriceCerts;
                }
                if (this.m_mixInfos[i].getDataRetentionInformation() == null) continue;
                ++countDataRetentionMixes;
                continue;
            }
            catch (XMLParseException a_e) {
                this.m_mixInfos[i] = null;
            }
        }
        this.m_strConcatenatedPriceCertHashes = XMLEasyCC.createConcatenatedPriceCertHashes(this.m_priceCertificateHashes, true);
        this.m_strName = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_mixCascadeNode, XML_ELEMENT_WEBINFO_NAME), null);
        if (!this.m_bFromCascade) {
            this.getDecomposedCascadeName();
        }
        if (a_expireTime == 0L && this.m_mixInfos.length > 0 && (visibleAddresses = this.m_mixInfos[this.m_mixInfos.length - 1].getVisibleAddresses()).size() == 0) {
            visibleAddresses = this.m_mixInfos[this.m_mixInfos.length - 1].getListenerAddresses();
        }
        if (this.m_mixCascadeId == null) {
            this.m_mixCascadeId = (String)this.m_mixIds.elementAt(0);
        }
        Node lastUpdateNode = XMLUtil.getFirstChildByName(a_mixCascadeNode, "LastUpdate");
        if (this.m_bFromCascade) {
            this.m_lastUpdate = 0L;
            this.m_serial = 0L;
        } else {
            if (lastUpdateNode == null) {
                throw new XMLParseException("LastUpdate");
            }
            this.m_lastUpdate = XMLUtil.parseValue(lastUpdateNode, System.currentTimeMillis() - 900000L);
            this.m_serial = XMLUtil.parseAttribute((Node)a_mixCascadeNode, "serial", this.m_lastUpdate);
        }
        this.m_compressedXmlStructure = a_compressedMixCascadeNode != null ? a_compressedMixCascadeNode : ZLibTools.compress(XMLSignature.toCanonical(a_mixCascadeNode));
        this.m_xmlStructure = a_mixCascadeNode;
        if (this.m_bFromCascade && a_mixIDFromCascade.trim().length() > 0) {
            this.m_mixCascadeId = a_mixIDFromCascade;
        }
        this.createMixIDString();
        this.calculateOperatorsAndCountries();
        if (this.isPayment()) {
            if (this.m_piid == null || this.m_piid.trim().length() == 0) {
                throw new XMLParseException("Payment instance id is null on paid cascade!");
            }
            if (this.m_prepaidInterval > 4000000L) {
                LogHolder.log(4, LogType.PAY, "Prepaid interval of cascade " + this.getId() + "is too high: " + this.m_prepaidInterval);
            } else if (this.m_prepaidInterval < 5000L) {
                LogHolder.log(4, LogType.PAY, "Prepaid interval of cascade " + this.getId() + "is too low: " + this.m_prepaidInterval);
            }
        }
        this.m_prepaidInterval = Math.min(this.m_prepaidInterval, 4000000L);
        this.m_prepaidInterval = Math.max(this.m_prepaidInterval, 5000L);
        this.m_dataRetentionInfo = DataRetentionInformation.getCascadeDataRetentionInformation(this);
    }

    public MixCascade(String a_hostName, int a_port) throws Exception {
        this(null, null, a_hostName, a_port);
    }

    public MixCascade(String a_name, String a_id, String a_hostName, int a_port) throws Exception {
        this(a_name, a_id, new ListenerInterface(a_hostName, a_port, 2).toVector());
    }

    public MixCascade(String a_name, String a_id, Vector a_listenerInterfaces) throws Exception {
        this(a_name, a_id, null, a_listenerInterfaces);
    }

    public MixCascade(String a_name, String a_id, Vector a_mixIDs, Vector a_listenerInterfaces) throws Exception {
        this(a_name, a_id, a_mixIDs, a_listenerInterfaces, Long.MAX_VALUE);
    }

    public MixCascade(String a_name, String a_id, String a_hostName, int a_port, long a_timeout) throws Exception {
        this(a_name, a_id, null, new ListenerInterface(a_hostName, a_port, 2).toVector(), a_timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MixCascade(String a_name, String a_id, Vector a_mixIDs, Vector a_listenerInterfaces, long a_timeout) throws Exception {
        super(a_timeout);
        ListenerInterface listener = (ListenerInterface)a_listenerInterfaces.elementAt(0);
        String strHostName = listener.getHost();
        String strPort = Integer.toString(listener.getPort());
        this.m_mixCascadeId = a_id == null || a_id.length() == 0 ? "(user)" + strHostName + "%3A" + strPort : a_id;
        this.m_strName = a_name != null ? a_name : strHostName + ":" + strPort;
        this.m_listenerInterfaces = (Vector)a_listenerInterfaces.clone();
        if (this.m_listenerInterfaces != null) {
            this.m_hashListenerInterfaces = new Hashtable();
            Vector vector = this.m_listenerInterfaces;
            synchronized (vector) {
                for (int i = 0; i < this.m_listenerInterfaces.size(); ++i) {
                    ListenerInterface listenerInterface = (ListenerInterface)this.m_listenerInterfaces.elementAt(i);
                    this.m_hashListenerInterfaces.put(listenerInterface.getId(), listenerInterface);
                }
            }
        }
        ListenerInterface.blockInterfacesFromDatabase(this);
        this.m_lastUpdate = 0L;
        this.m_mixNodes = new Vector();
        if (a_mixIDs == null || a_mixIDs.size() == 0) {
            this.m_mixIds = new Vector();
            this.m_mixIds.addElement(this.m_mixCascadeId);
        } else {
            this.m_mixIds = (Vector)a_mixIDs.clone();
        }
        this.m_mixInfos = new MixInfo[this.m_mixIds.size()];
        for (int i = 0; i < this.m_mixInfos.length; ++i) {
            this.m_mixInfos[i] = null;
        }
        this.m_userDefined = true;
        this.m_bDefaultVerified = true;
        this.m_xmlStructure = this.generateXmlRepresentation();
        this.m_compressedXmlStructure = ZLibTools.compress(XMLSignature.toCanonical(this.m_xmlStructure));
        this.createMixIDString();
        this.calculateOperatorsAndCountries();
    }

    public boolean isPersistanceDeletionAllowed() {
        return XMLUtil.getStorageMode() == 2;
    }

    public void deletePersistence() {
        if (this.isPersistanceDeletionAllowed()) {
            this.m_signature = null;
            this.m_compressedXmlStructure = null;
            this.m_xmlStructure = null;
        }
    }

    public boolean compareMixIDs(MixCascade a_cascade) {
        if (a_cascade == null) {
            return false;
        }
        return a_cascade.getMixIDsAsString().equals(this.getMixIDsAsString());
    }

    public String getId() {
        return this.m_mixCascadeId;
    }

    public String getMixProtocolVersion() {
        return this.m_mixProtocolVersion;
    }

    public String getPaymentProtocolVersion() {
        return this.m_paymentProtocolVersion;
    }

    public PaymentInstanceDBEntry getPaymentInstance() {
        PaymentInstanceDBEntry pi = (PaymentInstanceDBEntry)Database.getInstance(class$anon$pay$PaymentInstanceDBEntry == null ? (class$anon$pay$PaymentInstanceDBEntry = MixCascade.class$("anon.pay.PaymentInstanceDBEntry")) : class$anon$pay$PaymentInstanceDBEntry).getEntryById(this.getPIID());
        return pi;
    }

    public String getPIID() {
        return this.m_piid;
    }

    public long getPrepaidInterval() {
        return this.m_prepaidInterval;
    }

    public boolean isFromCascade() {
        return this.m_bFromCascade;
    }

    public long getVersionNumber() {
        return this.m_serial;
    }

    public long getLastUpdate() {
        return this.m_lastUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMixNames() {
        MixInfo[] mixInfoArray = this.m_mixInfos;
        synchronized (this.m_mixInfos) {
            if (this.m_strMixNames == null) {
                this.m_strMixNames = "";
                for (int i = 0; i < this.m_mixInfos.length; ++i) {
                    if (this.m_mixInfos[i] == null) continue;
                    if (this.m_strMixNames.length() > 0) {
                        this.m_strMixNames = this.m_strMixNames + "-";
                    }
                    this.m_strMixNames = this.m_strMixNames + this.m_mixInfos[i].getName();
                }
                if (this.m_strMixNames.length() == 0) {
                    this.m_strMixNames = this.m_strName;
                } else if (!this.m_strName.equals(this.m_strMixNames)) {
                    this.m_strMixNames = this.m_strName + "|" + this.m_strMixNames;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_strMixNames;
        }
    }

    public String getName() {
        this.getDecomposedCascadeName();
        return this.m_strName;
    }

    public int getMaxUsers() {
        return this.m_maxUsers;
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkJAPTeamName() {
        Object object = this.SYNC_NAME;
        synchronized (object) {
            this.m_strName = Util.stripString(this.m_strName, "-/\\");
            boolean bJAP = false;
            int iMaxLen = 35;
            if (this.m_strName != null && this.m_strName.indexOf("JAP") < 0 && this.m_mixInfos[0] != null && this.m_mixInfos[0].getServiceOperator().getOrganization() != null && this.m_mixInfos[0].getServiceOperator().getOrganization().indexOf("JAP") >= 0 && this.m_mixInfos[this.m_mixInfos.length - 1].getServiceOperator().getOrganization() != null && this.m_mixInfos[this.m_mixInfos.length - 1].getServiceOperator().getOrganization().indexOf("JAP") >= 0) {
                bJAP = true;
                iMaxLen -= 6;
            }
            this.m_strName = Util.cutString(this.m_strName, iMaxLen);
            if (bJAP) {
                this.m_strName = this.m_strName + " (JAP)";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDecomposedCascadeName() {
        Object object = this.SYNC_NAME;
        synchronized (object) {
            if (this.m_decomposedCascadeName == null) {
                this.m_decomposedCascadeName = new Vector();
                if (this.m_strName != null && (this.isUserDefined() || this.m_mixInfos.length == 0 && this.isShownAsTrusted())) {
                    this.m_decomposedCascadeName.addElement(this.m_strName);
                    return this.m_decomposedCascadeName;
                }
                if (this.m_mixInfos.length == 0) {
                    this.m_decomposedCascadeName.addElement("Unknown");
                    return this.m_decomposedCascadeName;
                }
                boolean bResetName = false;
                boolean bUseDecomposition = true;
                Vector<ServiceOperator> ops = new Vector<ServiceOperator>();
                ServiceOperator currentOp = null;
                for (int i = 0; i < this.m_mixInfos.length; ++i) {
                    if (this.m_mixInfos[i] == null || this.m_mixInfos[i].getServiceOperator() == null) {
                        bResetName = true;
                        break;
                    }
                    currentOp = this.m_mixInfos[i].getServiceOperator();
                    if (ops.contains(currentOp)) {
                        bUseDecomposition = false;
                        break;
                    }
                    ops.addElement(currentOp);
                }
                if (this.m_strName != null) {
                    StringTokenizer tokenizer = new StringTokenizer(this.m_strName, "-/\\");
                    if (tokenizer.countTokens() == this.getNumberOfMixes()) {
                        String token;
                        StringTokenizer tempTokenizer;
                        while (tokenizer.hasMoreTokens() && (tempTokenizer = new StringTokenizer(token = tokenizer.nextToken().trim())).hasMoreTokens() && (token = tempTokenizer.nextToken().trim()).length() != 0) {
                            this.m_decomposedCascadeName.addElement(token);
                        }
                    }
                    if (this.m_decomposedCascadeName.size() == 0) {
                        int i;
                        for (i = 0; !(i >= this.m_mixInfos.length || this.m_mixInfos[i] != null && this.m_mixInfos[i].isCascadaNameFragmentUsed()); ++i) {
                        }
                        if (i == this.m_mixInfos.length) {
                            this.checkJAPTeamName();
                            this.m_decomposedCascadeName.addElement(this.m_strName);
                            return this.m_decomposedCascadeName;
                        }
                    }
                }
                if (bResetName || this.m_mixInfos[0].getServiceOperator().equals(this.m_mixInfos[this.m_mixInfos.length - 1].getServiceOperator())) {
                    this.m_strName = this.m_mixInfos[0] != null && this.m_mixInfos[0].isCascadaNameFragmentUsed() ? this.m_mixInfos[0].getNameFragmentForCascade() : (this.m_decomposedCascadeName.size() > 0 ? (String)this.m_decomposedCascadeName.elementAt(0) : (this.m_mixInfos[0] != null ? this.m_mixInfos[0].getName() : "Unknown"));
                    this.checkJAPTeamName();
                    this.m_decomposedCascadeName.removeAllElements();
                    this.m_decomposedCascadeName.addElement(this.m_strName);
                } else {
                    int i;
                    if (!bUseDecomposition) {
                        this.m_decomposedCascadeName.removeAllElements();
                    }
                    ops = new Vector();
                    boolean bDecomposed = this.m_decomposedCascadeName.size() > 0;
                    for (i = 0; i < this.m_mixInfos.length; ++i) {
                        currentOp = this.m_mixInfos[i].getServiceOperator();
                        if (ops.contains(currentOp)) continue;
                        ops.addElement(currentOp);
                        if (bDecomposed) {
                            if (this.m_mixInfos[i].isCascadaNameFragmentUsed()) {
                                this.m_decomposedCascadeName.setElementAt(this.m_mixInfos[i].getNameFragmentForCascade(), i);
                            }
                        } else {
                            if (this.m_mixInfos[i].isCascadaNameFragmentUsed()) {
                                this.m_decomposedCascadeName.addElement(this.m_mixInfos[i].getNameFragmentForCascade());
                            } else {
                                this.m_decomposedCascadeName.addElement(this.m_mixInfos[i].getName());
                            }
                            if (this.m_decomposedCascadeName.elementAt(i) == null) {
                                this.m_decomposedCascadeName.setElementAt("Unknown", i);
                            }
                        }
                        this.m_decomposedCascadeName.setElementAt(Util.stripString(this.m_decomposedCascadeName.elementAt(i).toString(), "-/\\"), i);
                    }
                    this.m_strName = "";
                    for (i = 0; i < this.m_decomposedCascadeName.size(); ++i) {
                        this.m_strName = this.m_strName + (this.m_strName.equals("") ? "" : "-");
                        this.m_strName = this.m_strName + this.m_decomposedCascadeName.elementAt(i);
                    }
                    int j = 15;
                    while (this.m_strName.length() > 35) {
                        this.m_strName = "";
                        for (int i2 = 0; i2 < this.m_decomposedCascadeName.size(); ++i2) {
                            this.m_strName = this.m_strName + (this.m_strName.equals("") ? "" : "-");
                            this.m_decomposedCascadeName.setElementAt(Util.cutString(this.m_decomposedCascadeName.elementAt(i2).toString(), j), i2);
                            this.m_strName = this.m_strName + this.m_decomposedCascadeName.elementAt(i2);
                        }
                        --j;
                    }
                }
            }
        }
        return this.m_decomposedCascadeName;
    }

    public boolean equals(Object a_object) {
        boolean objectEquals = false;
        if (a_object != null && a_object instanceof MixCascade) {
            objectEquals = this.getId().equals(((MixCascade)a_object).getId());
        }
        return objectEquals;
    }

    public boolean checkId() {
        return this.m_userDefined || super.checkId();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public int getNumberOfListenerInterfaces() {
        if (this.m_listenerInterfaces != null) {
            return this.m_listenerInterfaces.size();
        }
        return 0;
    }

    public ListenerInterface getListenerInterface(int i) {
        ListenerInterface returnedListener = null;
        if (i >= 0 && i < this.getNumberOfListenerInterfaces()) {
            returnedListener = (ListenerInterface)this.m_listenerInterfaces.elementAt(i);
        }
        return returnedListener;
    }

    public ListenerInterface getListenerInterface(String a_id) {
        if (this.m_hashListenerInterfaces != null) {
            return (ListenerInterface)this.m_hashListenerInterfaces.get(a_id);
        }
        return null;
    }

    public Vector getListenerInterfaces() {
        if (this.m_listenerInterfaces != null) {
            return (Vector)this.m_listenerInterfaces.clone();
        }
        return null;
    }

    public String getHostsAsString() {
        this.cacheHostAndPortsAsString();
        return this.m_strHosts;
    }

    public String getPortsAsString() {
        this.cacheHostAndPortsAsString();
        return this.m_strPorts;
    }

    public Vector getHosts() {
        Vector<String> hosts = new Vector<String>();
        for (int i = 0; i < this.getNumberOfListenerInterfaces(); ++i) {
            String host = ((ListenerInterface)this.m_listenerInterfaces.elementAt(0)).getHost();
            if (hosts.contains(host)) continue;
            hosts.addElement(host);
        }
        return hosts;
    }

    public int getNumberOfMixes() {
        return this.m_mixIds.size();
    }

    public String getMixIDsAsString() {
        return this.m_strMixIds;
    }

    public MixInfo getMixInfo(int a_mixNumber) {
        if (a_mixNumber < 0 || a_mixNumber >= this.getNumberOfMixes() || a_mixNumber >= this.m_mixInfos.length) {
            return null;
        }
        return this.m_mixInfos[a_mixNumber];
    }

    public MixInfo getMixInfo(String a_mixId) {
        if (a_mixId == null) {
            return null;
        }
        for (int i = 0; i < this.m_mixIds.size(); ++i) {
            if (!this.m_mixIds.elementAt(i).equals(a_mixId)) continue;
            return this.m_mixInfos[i];
        }
        return null;
    }

    public String getMixId(int a_mixNumber) {
        if (a_mixNumber < 0 || a_mixNumber >= this.getNumberOfMixes() || a_mixNumber >= this.m_mixIds.size()) {
            return null;
        }
        return this.m_mixIds.elementAt(a_mixNumber).toString();
    }

    public Vector getMixIds() {
        return (Vector)this.m_mixIds.clone();
    }

    public boolean isUserDefined() {
        return this.m_userDefined;
    }

    public boolean isSocks5Supported() {
        return this.m_bSock5Support;
    }

    public void showAsTrusted(boolean a_bImplicitTrust) {
        this.m_bImplicitTrust = a_bImplicitTrust;
    }

    public boolean isShownAsTrusted() {
        return this.m_bImplicitTrust;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserDefined(boolean a_bUserDefined, MixCascade a_oldMixCascade) throws XMLParseException {
        this.m_userDefined = a_bUserDefined;
        if (this.m_userDefined && a_oldMixCascade != null && a_oldMixCascade.getId().equals(this.getId())) {
            this.m_strName = a_oldMixCascade.m_strName;
            Object object = this.SYNC_NAME;
            synchronized (object) {
                this.m_decomposedCascadeName = new Vector();
                this.m_decomposedCascadeName.addElement(this.m_strName);
            }
            this.m_listenerInterfaces = a_oldMixCascade.m_listenerInterfaces;
            if (this.m_listenerInterfaces != null) {
                this.m_hashListenerInterfaces = new Hashtable();
                Vector vector = this.m_listenerInterfaces;
                synchronized (vector) {
                    for (int i = 0; i < this.m_listenerInterfaces.size(); ++i) {
                        ListenerInterface listenerInterface = (ListenerInterface)this.m_listenerInterfaces.elementAt(i);
                        this.m_hashListenerInterfaces.put(listenerInterface.getId(), listenerInterface);
                    }
                }
            }
            ListenerInterface.blockInterfacesFromDatabase(this);
            this.m_lastUpdate = 0L;
            this.m_serial = 0L;
        }
        if (this.m_xmlStructure != null) {
            this.m_xmlStructure = this.generateXmlRepresentation();
        }
        if (this.m_compressedXmlStructure != null) {
            this.m_compressedXmlStructure = ZLibTools.compress(XMLSignature.toCanonical(this.m_xmlStructure));
        }
        this.calculateOperatorsAndCountries();
    }

    public StatusInfo fetchCurrentStatus() {
        return this.fetchCurrentStatus(-1L);
    }

    public StatusInfo fetchCurrentStatus(long a_timeout) {
        String id = this.getMixId(0);
        if (id == null) {
            id = this.getId();
        }
        StatusInfo statusInfo = a_timeout <= 0L ? InfoServiceHolder.getInstance().getStatusInfo(this) : InfoServiceHolder.getInstance().getStatusInfo(this, a_timeout);
        return statusInfo;
    }

    public StatusInfo getCurrentStatus() {
        StatusInfo statusInfo = (StatusInfo)Database.getInstance(class$anon$infoservice$StatusInfo == null ? (class$anon$infoservice$StatusInfo = MixCascade.class$("anon.infoservice.StatusInfo")) : class$anon$infoservice$StatusInfo).getEntryById(this.getId());
        if (statusInfo == null) {
            statusInfo = StatusInfo.createDummyStatusInfo(this.getId());
        }
        return statusInfo;
    }

    public String getPostFile() {
        return "/cascade";
    }

    public int getPostEncoding() {
        return 1;
    }

    public byte[] getPostData() {
        return this.m_compressedXmlStructure;
    }

    public byte[] getCompressedData() {
        return this.m_compressedXmlStructure;
    }

    public Element getXmlStructure() {
        return this.m_xmlStructure;
    }

    public String getConcatenatedPriceCertHashes() {
        return this.m_strConcatenatedPriceCertHashes;
    }

    public Hashtable getPriceCertificateHashes() {
        return (Hashtable)this.m_priceCertificateHashes.clone();
    }

    public Vector getPriceCertificates() {
        return (Vector)this.m_priceCertificates.clone();
    }

    public int getNrOfPriceCerts() {
        return this.m_nrPriceCerts;
    }

    public XMLSignature getSignature() {
        return this.m_signature;
    }

    public MultiCertPath getCertPath() {
        return this.m_certPath;
    }

    public boolean isVerified() {
        if (this.m_certPath != null) {
            return this.m_certPath.isVerified();
        }
        return this.m_bDefaultVerified;
    }

    public boolean isDefaultVerified() {
        return this.m_bDefaultVerified;
    }

    public boolean isValid() {
        if (this.m_certPath != null) {
            return this.m_certPath.isValid(new Date());
        }
        return false;
    }

    public DataRetentionInformation getDataRetentionInformation() {
        return this.m_dataRetentionInfo;
    }

    public boolean isActiveStudy() {
        return this.m_bStudy || this.m_userDefined;
    }

    public int getNumberOfOperators() {
        this.calculateOperatorsAndCountries();
        return this.m_nrOperators;
    }

    public boolean areListenerInterfacesBlocked() {
        boolean bListenerInterfaceAvailable = false;
        for (int i = 0; i < this.getNumberOfListenerInterfaces(); ++i) {
            if (!this.getListenerInterface(i).isValid()) continue;
            bListenerInterfaceAvailable = true;
            break;
        }
        return !bListenerInterfaceAvailable && this.getNumberOfListenerInterfaces() > 0;
    }

    public int getNumberOfOperatorsShown() {
        this.calculateOperatorsAndCountries();
        return this.m_nrOperatorsShown;
    }

    public int getNumberOfCountries() {
        this.calculateOperatorsAndCountries();
        return this.m_nrCountries;
    }

    public int getDistribution() {
        this.calculateOperatorsAndCountries();
        return this.m_distributionPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheHostAndPortsAsString() {
        Object object = this.CACHE_HOSTS_PORT;
        synchronized (object) {
            int i;
            if (this.m_strPorts != null || this.m_strHosts != null) {
                return;
            }
            String interfaces = "";
            String ports = "";
            int[] portsArray = new int[this.getNumberOfListenerInterfaces()];
            for (i = 0; i < this.getNumberOfListenerInterfaces(); ++i) {
                if (interfaces.indexOf(this.getListenerInterface(i).getHost()) == -1) {
                    if (interfaces.length() > 0) {
                        interfaces = interfaces + "\n";
                    }
                    interfaces = interfaces + this.getListenerInterface(i).getHost();
                }
                portsArray[i] = this.getListenerInterface(i).getPort();
            }
            for (i = 0; i < portsArray.length; ++i) {
                for (int k = i + 1; k < portsArray.length; ++k) {
                    if (portsArray[i] <= portsArray[k]) continue;
                    int tmp = portsArray[k];
                    portsArray[k] = portsArray[i];
                    portsArray[i] = tmp;
                }
            }
            Vector<Integer> countPorts = new Vector<Integer>(portsArray.length);
            for (i = 0; i < portsArray.length; ++i) {
                Integer port = new Integer(portsArray[i]);
                if (countPorts.contains(port)) continue;
                countPorts.addElement(new Integer(portsArray[i]));
            }
            for (i = 0; i < countPorts.size(); ++i) {
                ports = ports + countPorts.elementAt(i).toString();
                if (i == countPorts.size() - 1) continue;
                ports = ports + ", ";
            }
            this.m_strHosts = interfaces;
            this.m_strPorts = ports;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateOperatorsAndCountries() {
        Object object = this.SYNC_OPERATORS_AND_COUNTRIES;
        synchronized (object) {
            String mixCountryCode;
            String operatorCountryCode;
            int i;
            Hashtable<String, String> operators = new Hashtable<String, String>();
            Hashtable<String, String> countries = new Hashtable<String, String>();
            Hashtable<String, String> mixIDs = new Hashtable<String, String>();
            boolean bNeedsRecalculation = this.m_mixCertVerifiedAndValid == null || this.m_mixCertVerifiedAndValid.length != this.getNumberOfMixes();
            if (bNeedsRecalculation) {
                this.m_mixCertVerifiedAndValid = new boolean[this.getNumberOfMixes()];
                for (i = 0; i < this.m_mixCertVerifiedAndValid.length; ++i) {
                    this.m_mixCertVerifiedAndValid[i] = false;
                }
            }
            for (i = 0; i < this.getNumberOfMixes(); ++i) {
                boolean bStatus;
                boolean bl = bStatus = this.getMixInfo(i) != null && this.getMixInfo(i).getCertPath() != null && this.getMixInfo(i).getCertPath().isVerified() && this.getMixInfo(i).getCertPath().isValid(new Date());
                if (this.m_mixCertVerifiedAndValid[i] != bStatus) {
                    bNeedsRecalculation = true;
                }
                this.m_mixCertVerifiedAndValid[i] = bStatus;
            }
            if (!bNeedsRecalculation) {
                return;
            }
            this.m_nrOperatorsCountForDistribution = 0;
            this.m_nrOperators = 0;
            this.m_nrOperatorsShown = 0;
            this.m_nrCountries = 0;
            for (i = 0; i < this.getNumberOfMixes(); ++i) {
                if (this.getMixInfo(i) == null || this.getMixInfo(i).getCertPath() == null) continue;
                X509DistinguishedName currentName = this.getMixInfo(i).getCertPath().getIssuer();
                if (currentName != null && currentName.getOrganisation() != null && !operators.contains(currentName.getOrganisation()) && !mixIDs.contains(this.getMixInfo(i).getId())) {
                    operatorCountryCode = currentName.getCountryCode();
                    mixCountryCode = this.getMixInfo(i).getCertPath().getSubject().getCountryCode();
                    try {
                        if (new CountryMapper(operatorCountryCode).toString() == operatorCountryCode) {
                            operatorCountryCode = null;
                        } else if (new CountryMapper(mixCountryCode).toString() == mixCountryCode) {
                            mixCountryCode = null;
                        }
                    }
                    catch (IllegalArgumentException a_e) {
                        operatorCountryCode = null;
                        mixCountryCode = null;
                    }
                    if (!(operatorCountryCode == null || mixCountryCode == null || countries.contains(mixCountryCode) || countries.contains(operatorCountryCode) || !this.m_mixCertVerifiedAndValid[i] || i > 1 && i + 1 != this.getNumberOfMixes())) {
                        ++this.m_nrCountries;
                    }
                    if (this.m_mixCertVerifiedAndValid[i]) {
                        if (operatorCountryCode != null) {
                            countries.put(operatorCountryCode, operatorCountryCode);
                        }
                        if (mixCountryCode != null) {
                            countries.put(mixCountryCode, mixCountryCode);
                        }
                    }
                    operators.put(currentName.getOrganisation(), currentName.getOrganisation());
                    mixIDs.put(this.getMixInfo(i).getId(), this.getMixInfo(i).getId());
                    if (this.m_mixCertVerifiedAndValid[i]) {
                        ++this.m_nrOperators;
                        if (i <= 1 || i + 1 == this.getNumberOfMixes()) {
                            ++this.m_nrOperatorsCountForDistribution;
                        }
                    }
                    ++this.m_nrOperatorsShown;
                    continue;
                }
                if (this.m_nrOperators <= 0) {
                    for (int j = 0; j < this.getNumberOfMixes(); ++j) {
                        if (!this.m_mixCertVerifiedAndValid[j]) continue;
                        this.m_nrOperators = 1;
                        this.m_nrOperatorsCountForDistribution = 1;
                        break;
                    }
                } else {
                    this.m_nrOperators = 1;
                    this.m_nrOperatorsCountForDistribution = 1;
                }
                this.m_nrOperatorsShown = 1;
                this.m_nrCountries = Math.min(this.m_nrOperatorsCountForDistribution, 1);
                break;
            }
            if (this.m_nrOperatorsCountForDistribution >= 2 && this.m_nrCountries == 1 && this.m_mixCertVerifiedAndValid[0] && this.m_mixCertVerifiedAndValid[this.getNumberOfMixes() - 1]) {
                operatorCountryCode = this.getMixInfo(0).getCertPath().getIssuer().getCountryCode();
                mixCountryCode = this.getMixInfo(0).getCertPath().getSubject().getCountryCode();
                String operatorCountryCode2 = this.getMixInfo(this.getNumberOfMixes() - 1).getCertPath().getIssuer().getCountryCode();
                String mixCountryCode2 = this.getMixInfo(this.getNumberOfMixes() - 1).getCertPath().getSubject().getCountryCode();
                if (!(operatorCountryCode2 == null || mixCountryCode2 == null || operatorCountryCode == null || mixCountryCode == null || operatorCountryCode2.equals(operatorCountryCode) || mixCountryCode2.equals(operatorCountryCode) || mixCountryCode2.equals(mixCountryCode) || operatorCountryCode2.equals(mixCountryCode))) {
                    ++this.m_nrCountries;
                }
            }
            this.m_distributionPoints = this.m_nrOperatorsCountForDistribution == 3 && this.m_nrCountries == 1 ? 3 : (this.m_nrOperatorsCountForDistribution == 2 && this.m_nrCountries == 1 ? 2 : (this.m_nrOperatorsCountForDistribution == 1 ? 1 : this.m_nrOperatorsCountForDistribution + this.m_nrCountries));
            if (this.m_distributionPoints > 1 && this.getNumberOfMixes() > 1 && this.getMixInfo(0) != null && this.getMixInfo(0).getCertPath() != null && this.getMixInfo(this.getNumberOfMixes() - 1) != null && this.getMixInfo(this.getNumberOfMixes() - 1).getCertPath() != null && this.getMixInfo(0).getCertPath().getIssuer().getCountryCode() != null && this.getMixInfo(this.getNumberOfMixes() - 1).getCertPath().getIssuer().getCountryCode() != null && this.getMixInfo(0).getCertPath().getIssuer().getCountryCode().equals(this.getMixInfo(this.getNumberOfMixes() - 1).getCertPath().getIssuer().getCountryCode())) {
                this.m_distributionPoints = Math.max(2, this.m_distributionPoints - 2);
            }
            this.calculateOperatorsAndCountries();
        }
    }

    private Element generateXmlRepresentation() {
        Document doc = XMLUtil.createDocument();
        Element mixCascadeNode = doc.createElement(XML_ELEMENT_NAME);
        XMLUtil.setAttribute(mixCascadeNode, "id", this.getId());
        if (this.m_isPayment) {
            Element elemPay = doc.createElement("Payment");
            XMLUtil.setAttribute(elemPay, "required", this.m_isPayment);
            XMLUtil.setAttribute(elemPay, "version", this.m_paymentProtocolVersion);
            mixCascadeNode.appendChild(elemPay);
        }
        Element nameNode = doc.createElement(XML_ELEMENT_WEBINFO_NAME);
        XMLUtil.setValue((Node)nameNode, this.getName());
        Element networkNode = doc.createElement("Network");
        Element listenerInterfacesNode = doc.createElement("ListenerInterfaces");
        for (int i = 0; i < this.getNumberOfListenerInterfaces(); ++i) {
            ListenerInterface currentListenerInterface = this.getListenerInterface(i);
            Element currentListenerInterfaceNode = currentListenerInterface.toXmlElement(doc);
            listenerInterfacesNode.appendChild(currentListenerInterfaceNode);
        }
        networkNode.appendChild(listenerInterfacesNode);
        Element mixesNode = doc.createElement("Mixes");
        XMLUtil.setAttribute(mixesNode, "count", this.getNumberOfMixes());
        Enumeration allMixIds = this.m_mixIds.elements();
        int i = 0;
        while (allMixIds.hasMoreElements()) {
            if (this.m_mixNodes.size() > i) {
                allMixIds.nextElement();
                try {
                    mixesNode.appendChild(XMLUtil.importNode(doc, (Node)this.m_mixNodes.elementAt(i), true));
                }
                catch (XMLParseException a_e) {
                    LogHolder.log(2, LogType.MISC, "Could not import node " + ((Node)this.m_mixNodes.elementAt(i)).getNodeName() + "!");
                }
            } else {
                Element mixNode = doc.createElement("Mix");
                XMLUtil.setAttribute(mixNode, "id", (String)allMixIds.nextElement());
                mixesNode.appendChild(mixNode);
            }
            ++i;
        }
        Element lastUpdateNode = doc.createElement("LastUpdate");
        XMLUtil.setValue((Node)lastUpdateNode, this.getLastUpdate());
        mixCascadeNode.appendChild(nameNode);
        mixCascadeNode.appendChild(networkNode);
        mixCascadeNode.appendChild(mixesNode);
        mixCascadeNode.appendChild(lastUpdateNode);
        if (this.isUserDefined()) {
            XMLUtil.setAttribute(mixCascadeNode, XML_ATTR_USER_DEFINED, true);
            if (this.m_signature != null) {
                Element[] signatureElements = this.m_signature.getXMLElements(doc);
                for (int i2 = 0; i2 < signatureElements.length; ++i2) {
                    mixCascadeNode.appendChild(signatureElements[i2]);
                }
            }
        }
        return mixCascadeNode;
    }

    public boolean isPaymentProtocolSupported() {
        return !this.m_isPayment || this.m_isPayment && (this.getPaymentProtocolVersion().equals(SUPPORTED_PAYMENT_PROTOCOL_VERSION) || this.getPaymentProtocolVersion().equals(SUPPORTED_PAYMENT_PROTOCOL_VERSION));
    }

    public boolean isPayment() {
        return this.m_isPayment;
    }

    public boolean isTermsAndConditionsConfirmationRequired() {
        return this.termsAndConditionsConfirmationRequired;
    }

    private void createMixIDString() {
        this.m_strMixIds = "";
        for (int i = 0; i < this.m_mixIds.size(); ++i) {
            this.m_strMixIds = this.m_strMixIds + this.m_mixIds.elementAt(i);
        }
    }

    public String getContext() {
        if (this.m_context == null) {
            if (this.isPayment()) {
                return "jondonym.premium";
            }
            return "jondonym";
        }
        return this.m_context;
    }

    public Element getWebInfo(Document webInfoDoc) {
        if (webInfoDoc == null) {
            return null;
        }
        Vector decomposedNames = this.getDecomposedCascadeName();
        Vector<String> namesToAdd = new Vector<String>(decomposedNames.size());
        String tempName = null;
        for (int i = 0; i < decomposedNames.size(); ++i) {
            tempName = (String)decomposedNames.elementAt(i);
            if (tempName == null || namesToAdd.contains(tempName)) {
                tempName = "";
            }
            namesToAdd.insertElementAt(tempName, i);
        }
        Element rootElement = webInfoDoc.createElement(XML_ELEMENT_WEBINFO);
        XMLUtil.setAttribute(rootElement, XML_ATTR_PAYMENT, this.isPayment());
        XMLUtil.setAttribute(rootElement, "id", this.getId());
        if (this.getMaxUsers() > 0) {
            XMLUtil.setAttribute(rootElement, XML_ATTR_MAX_USERS, this.getMaxUsers());
        }
        XMLUtil.setAttribute(rootElement, XML_ATTR_WEBINFO_OPERATOR_COUNT, this.getNumberOfOperatorsShown());
        XMLUtil.setAttribute(rootElement, XML_ATTR_WEBINFO_DISTRIBUTION, this.getDistribution());
        if (this.getContext() != null) {
            XMLUtil.setAttribute(rootElement, "context", this.getContext());
        }
        Element cascadeName = XMLUtil.createChildElement(rootElement, XML_ELEMENT_WEBINFO_CASCADE_NAME);
        Element mixList = webInfoDoc.createElement("Mixes");
        XMLUtil.createChildElementWithValue(rootElement, XML_ELEMENT_WEBINFO_CURR_USERS, "" + this.getCurrentStatus().getNrOfActiveUsers());
        PerformanceEntry perfEntry = (PerformanceEntry)Database.getInstance(class$anon$infoservice$PerformanceEntry == null ? (class$anon$infoservice$PerformanceEntry = MixCascade.class$("anon.infoservice.PerformanceEntry")) : class$anon$infoservice$PerformanceEntry).getEntryById(this.getId());
        if (perfEntry != null) {
            rootElement.appendChild(perfEntry.toXmlElement(webInfoDoc));
        }
        if (this.getDataRetentionInformation() != null) {
            XMLUtil.createChildElement(rootElement, "DataRetention");
        }
        Element currentNameElement = null;
        String currentDecomposedNameComponent = null;
        MixInfo currentMixInfo = null;
        ServiceOperator currentMixOperator = null;
        ServiceLocation currentMixLocation = null;
        Element currentMixElement = null;
        Element currentMixOperatorElement = null;
        Element currentMixLocationElement = null;
        String currentMixName = null;
        rootElement.appendChild(mixList);
        for (int i = 0; i < this.getNumberOfMixes(); ++i) {
            currentMixInfo = this.getMixInfo(i);
            if (currentMixInfo == null) continue;
            if (currentMixInfo.getCertPath() == null) {
                return null;
            }
            CertPath path = currentMixInfo.getCertPath().getPath();
            currentMixOperator = new ServiceOperator(null, currentMixInfo.getCertPath(), 0L);
            currentMixLocation = new ServiceLocation(null, path.getFirstCertificate());
            currentMixName = currentMixInfo.getName();
            if (currentMixOperator == null || currentMixLocation == null) {
                return null;
            }
            currentDecomposedNameComponent = null;
            if (i < namesToAdd.size() && (currentDecomposedNameComponent = (String)namesToAdd.elementAt(i)) != null && currentDecomposedNameComponent.equals("")) {
                currentDecomposedNameComponent = null;
            }
            if (currentDecomposedNameComponent != null) {
                currentNameElement = XMLUtil.createChildElementWithValue(cascadeName, XML_ELEMENT_WEBINFO_NAME, currentDecomposedNameComponent);
                if (currentMixLocation.getCountryCode() != null) {
                    XMLUtil.setAttribute(currentNameElement, XML_ATTR_WEBINFO_MIX_COUNTRY, currentMixLocation.getCountryCode());
                }
                if (currentMixOperator.getCountryCode() != null) {
                    XMLUtil.setAttribute(currentNameElement, XML_ATTR_WEBINFO_OP_COUNTRY, currentMixOperator.getCountryCode());
                }
                XMLUtil.setAttribute(currentNameElement, XML_ATTR_WEBINFO_MIX_POSITION, i);
            }
            currentMixElement = XMLUtil.createChildElement(mixList, "Mix");
            XMLUtil.setAttribute(currentMixElement, "id", currentMixInfo.getId());
            if (currentMixName != null) {
                XMLUtil.createChildElementWithValue(currentMixElement, XML_ELEMENT_WEBINFO_NAME, currentMixName);
            }
            currentMixOperatorElement = currentMixOperator.toXMLElement(webInfoDoc);
            currentMixLocationElement = currentMixLocation.toXMLElement(webInfoDoc);
            if (currentMixOperatorElement != null) {
                currentMixElement.appendChild(currentMixOperatorElement);
            }
            if (currentMixLocationElement == null) continue;
            currentMixElement.appendChild(currentMixLocationElement);
        }
        currentNameElement = XMLUtil.createChildElementWithValue(cascadeName, XML_ELEMENT_WEBINFO_COMPOSED_NAME, this.getName());
        Element listenerInterfaces = XMLUtil.createChildElement(rootElement, "ListenerInterfaces");
        Hashtable<String, Element> hashInterfaceHosts = new Hashtable<String, Element>();
        for (int i = 0; i < this.getNumberOfListenerInterfaces(); ++i) {
            Element elemInterface;
            ListenerInterface listenerInterface = this.getListenerInterface(i);
            if (listenerInterface.isHidden()) continue;
            if (hashInterfaceHosts.containsKey(listenerInterface.getHost())) {
                elemInterface = (Element)hashInterfaceHosts.get(listenerInterface.getHost());
            } else {
                elemInterface = XMLUtil.createChildElement(listenerInterfaces, "ListenerInterface");
                XMLUtil.setAttribute(elemInterface, "Host", listenerInterface.getHost());
                hashInterfaceHosts.put(listenerInterface.getHost(), elemInterface);
            }
            if (listenerInterface.getProtocol() == 5) continue;
            XMLUtil.createChildElementWithValue(elemInterface, "Port", "" + listenerInterface.getPort());
        }
        return rootElement;
    }

    public String getAccessControlPreSharedSecret() {
        return this.m_strAccessControlPreSharedSecret;
    }

    public void setAccessControlPreSharedSecret(String a_strPreShardSecret) {
        this.m_strAccessControlPreSharedSecret = a_strPreShardSecret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

