/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.crypto.MyRandom;
import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.DatabaseMessage;
import anon.infoservice.ICertifiedDatabaseEntry;
import anon.infoservice.IDistributable;
import anon.infoservice.IDistributor;
import anon.infoservice.externaldatabase.EDBException;
import anon.infoservice.externaldatabase.IEDBConfiguration;
import anon.infoservice.externaldatabase.IEDBDatabase;
import anon.util.Base64;
import anon.util.IXMLEncodable;
import anon.util.Util;
import anon.util.XMLUtil;
import anon.util.ZLibTools;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class Database
extends Observable
implements IXMLEncodable {
    private static String XML_ALL_DB_NAME = "InfoServiceDB";
    private static Hashtable ms_databases = new Hashtable();
    private static Thread ms_vacuumThread;
    private static IDistributor ms_distributor;
    private static boolean ms_bShutdown;
    private Class m_DatabaseEntryClass;
    private Thread m_dbThread;
    private final Object SYNC_THREAD = new Object();
    private Hashtable m_serviceDatabase;
    private MyRandom m_random = null;
    private long m_randomSeed;
    private Vector m_timeoutList;
    private volatile boolean m_bStopThread = false;
    private static final Object SYNC_EXTERNAL_DATABASE;
    private static IEDBDatabase ms_edbDatabase;
    private static boolean ms_bIsLoading;
    static /* synthetic */ Class class$anon$infoservice$Database;
    static /* synthetic */ Class class$anon$infoservice$AbstractDatabaseEntry;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$anon$util$IXMLEncodable;
    static /* synthetic */ Class class$anon$infoservice$Database$IWebInfo;

    public static void registerDistributor(IDistributor a_distributor) {
        ms_distributor = a_distributor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerExternalDatabase(IEDBConfiguration a_dbConf) {
        Object object = SYNC_EXTERNAL_DATABASE;
        synchronized (object) {
            try {
                if (ms_vacuumThread != null) {
                    while (ms_vacuumThread.isAlive()) {
                        ms_vacuumThread.interrupt();
                        ms_vacuumThread.join(500L);
                    }
                }
                boolean result = Database.testDB(a_dbConf);
                ms_vacuumThread = new Thread("Database vacuum"){

                    public void run() {
                        while (!Thread.currentThread().isInterrupted()) {
                            try {
                                Database.doVacuum();
                                Thread.sleep(300000L);
                            }
                            catch (Exception a_e) {
                                LogHolder.log(1, LogType.DB, "Could not vaccum database!", a_e);
                            }
                        }
                    }
                };
                ms_vacuumThread.setDaemon(true);
                ms_vacuumThread.start();
                return result;
            }
            catch (Exception a_e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean testDB(IEDBConfiguration a_dbConf) throws Exception {
        Object object = SYNC_EXTERNAL_DATABASE;
        synchronized (object) {
            ms_edbDatabase = a_dbConf.getEDBDatabaseInstance();
            ms_edbDatabase.testDB();
            return true;
        }
    }

    private static Database registerInstance(Database a_Database) {
        Database database = (Database)ms_databases.get(a_Database.getEntryClass());
        if (database == null && a_Database != null) {
            ms_databases.put(a_Database.getEntryClass(), a_Database);
            database = a_Database;
        }
        return database;
    }

    private static Database unregisterInstance(Class a_DatabaseEntryClass) {
        return (Database)ms_databases.remove(a_DatabaseEntryClass);
    }

    private static void unregisterInstances() {
        ms_databases.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database getInstance(Class a_DatabaseEntryClass) throws IllegalArgumentException {
        Database database = null;
        Class clazz = class$anon$infoservice$Database == null ? (class$anon$infoservice$Database = Database.class$("anon.infoservice.Database")) : class$anon$infoservice$Database;
        synchronized (clazz) {
            database = (Database)ms_databases.get(a_DatabaseEntryClass);
            if (database == null) {
                database = new Database(a_DatabaseEntryClass);
                if (!ms_bShutdown) {
                    ms_databases.put(a_DatabaseEntryClass, database);
                }
            }
        }
        return database;
    }

    public static void restoreFromXML(Document xmlAllDBs, Class[] classesToRestore) {
        if (xmlAllDBs == null || classesToRestore == null) {
            return;
        }
        Element allDBRoot = xmlAllDBs.getDocumentElement();
        if (allDBRoot == null) {
            return;
        }
        if (!allDBRoot.getNodeName().equals(XML_ALL_DB_NAME)) {
            return;
        }
        Database currentDB = null;
        for (int i = 0; i < classesToRestore.length; ++i) {
            currentDB = Database.getInstance(classesToRestore[i]);
            if (currentDB == null) continue;
            currentDB.loadFromXml(allDBRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document dumpToXML(Class[] classesToDump) {
        if (classesToDump == null) {
            return null;
        }
        Document doc = XMLUtil.createDocument();
        Element root = doc.createElement(XML_ALL_DB_NAME);
        Database currentDB = null;
        Element currentDBRoot = null;
        Class clazz = class$anon$infoservice$Database == null ? (class$anon$infoservice$Database = Database.class$("anon.infoservice.Database")) : class$anon$infoservice$Database;
        synchronized (clazz) {
            for (int i = 0; i < classesToDump.length; ++i) {
                currentDB = Database.getInstance(classesToDump[i]);
                currentDBRoot = currentDB.toXmlElement(doc);
                if (currentDBRoot == null) continue;
                root.appendChild(currentDBRoot);
            }
        }
        doc.appendChild(root);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownDatabases() {
        Class clazz = class$anon$infoservice$Database == null ? (class$anon$infoservice$Database = Database.class$("anon.infoservice.Database")) : class$anon$infoservice$Database;
        synchronized (clazz) {
            ms_bShutdown = true;
            Enumeration databases = ms_databases.elements();
            while (databases.hasMoreElements()) {
                Database currentDB = (Database)databases.nextElement();
                Object object = currentDB.SYNC_THREAD;
                synchronized (object) {
                    currentDB.stopThread();
                }
            }
            ms_databases.clear();
        }
    }

    private Database(Class a_DatabaseEntryClass) throws IllegalArgumentException {
        if (a_DatabaseEntryClass == null) {
            throw new NullPointerException("Invalid database class!");
        }
        if (!(class$anon$infoservice$AbstractDatabaseEntry == null ? (class$anon$infoservice$AbstractDatabaseEntry = Database.class$("anon.infoservice.AbstractDatabaseEntry")) : class$anon$infoservice$AbstractDatabaseEntry).isAssignableFrom(a_DatabaseEntryClass)) {
            throw new IllegalArgumentException("There is no Database that can store entries of type " + a_DatabaseEntryClass.getName() + "!");
        }
        this.m_DatabaseEntryClass = a_DatabaseEntryClass;
        this.m_serviceDatabase = new Hashtable();
        this.m_timeoutList = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThread() {
        Object object = this.SYNC_THREAD;
        synchronized (object) {
            if (ms_bShutdown || !this.m_bStopThread && this.m_dbThread != null && this.m_dbThread.isAlive()) {
                return;
            }
            while (this.m_dbThread != null && this.m_bStopThread && this.m_dbThread.isAlive()) {
                LogHolder.log(3, LogType.DB, "Shutting down old database thread before starting new one (" + this.m_DatabaseEntryClass.toString() + ")");
                this.m_dbThread.interrupt();
                Thread.yield();
            }
            this.m_bStopThread = false;
            this.m_dbThread = new Thread((Runnable)new TimeoutThread(), "Database Thread: " + this.m_DatabaseEntryClass.toString());
            this.m_dbThread.setDaemon(true);
            this.m_dbThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThread() {
        Object object = this.SYNC_THREAD;
        synchronized (object) {
            this.m_bStopThread = true;
            while (this.m_dbThread != null && this.m_dbThread.isAlive()) {
                LogHolder.log(6, LogType.DB, "Shutting down db thread for class: " + this.m_DatabaseEntryClass.toString());
                this.m_dbThread.interrupt();
                Hashtable hashtable = this.m_serviceDatabase;
                synchronized (hashtable) {
                    this.m_serviceDatabase.notify();
                }
                Thread.yield();
            }
        }
    }

    public boolean update(AbstractDatabaseEntry newEntry) throws IllegalArgumentException {
        return this.update(newEntry, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(AbstractDatabaseEntry newEntry, boolean a_bDistribute) throws IllegalArgumentException {
        if (newEntry == null) {
            return false;
        }
        if (!this.m_DatabaseEntryClass.isAssignableFrom(newEntry.getClass())) {
            throw new IllegalArgumentException("Database cannot store entries of type " + newEntry.getClass().getName() + "!");
        }
        boolean addEntry = false;
        AbstractDatabaseEntry oldEntry = null;
        boolean bStopThread = false;
        boolean bStartThread = false;
        Object object = this.SYNC_THREAD;
        synchronized (object) {
            Hashtable hashtable = this.m_serviceDatabase;
            synchronized (hashtable) {
                oldEntry = (AbstractDatabaseEntry)this.m_serviceDatabase.get(newEntry.getId());
                addEntry = newEntry.isNewerThan(oldEntry);
                if (addEntry) {
                    if (newEntry.getExpireTime() <= System.currentTimeMillis()) {
                        if (newEntry.isPersistanceDeletionAllowed()) {
                            newEntry.deletePersistence();
                        }
                        LogHolder.log(6, LogType.NET, "Received an expired db entry: '" + newEntry.getId() + "' (" + this.m_DatabaseEntryClass.toString() + "). It was dropped immediatly.");
                        return this.remove(newEntry.getId());
                    }
                    while (this.m_timeoutList.removeElement(newEntry.getId())) {
                    }
                    if (newEntry.isPersistanceDeletionAllowed()) {
                        this.addExternal(newEntry);
                        newEntry.deletePersistence();
                    }
                    this.m_serviceDatabase.put(newEntry.getId(), newEntry);
                    boolean timeoutEntryInserted = false;
                    int i = 0;
                    while (!timeoutEntryInserted) {
                        if (i < this.m_timeoutList.size()) {
                            Object currentID = this.m_timeoutList.elementAt(i);
                            AbstractDatabaseEntry currentEntry = (AbstractDatabaseEntry)this.m_serviceDatabase.get(currentID);
                            if (currentEntry.getExpireTime() >= newEntry.getExpireTime()) {
                                this.m_timeoutList.insertElementAt(newEntry.getId(), i);
                                timeoutEntryInserted = true;
                            }
                        } else {
                            this.m_timeoutList.addElement(newEntry.getId());
                            timeoutEntryInserted = true;
                        }
                        ++i;
                    }
                    if (i == 1) {
                        if (newEntry.getExpireTime() == Long.MAX_VALUE) {
                            bStopThread = true;
                        } else {
                            bStartThread = true;
                            this.m_serviceDatabase.notify();
                        }
                    }
                    LogHolder.log(7, LogType.MISC, "Added / updated entry '" + newEntry.getId() + "' in the " + this.m_DatabaseEntryClass.getName() + " database. Now there are " + Integer.toString(this.m_serviceDatabase.size()) + " entries stored in this database. The new entry has position " + Integer.toString(i) + "/" + Integer.toString(this.m_timeoutList.size()) + " in the database-timeout list.");
                    if (newEntry instanceof IDistributable && a_bDistribute) {
                        if (ms_distributor != null) {
                            ms_distributor.addJob((IDistributable)((Object)newEntry));
                        } else {
                            LogHolder.log(4, LogType.MISC, "No distributor specified - cannot distribute database entries!");
                        }
                    }
                } else if (newEntry.isPersistanceDeletionAllowed()) {
                    newEntry.deletePersistence();
                }
            }
            if (bStopThread) {
                this.stopThread();
            } else if (bStartThread) {
                this.startThread();
            }
        }
        if (addEntry) {
            this.setChanged();
            if (oldEntry == null) {
                this.notifyObservers(new DatabaseMessage(1, newEntry));
            } else {
                this.notifyObservers(new DatabaseMessage(2, newEntry));
            }
            return true;
        }
        return false;
    }

    public Class getEntryClass() {
        return this.m_DatabaseEntryClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String a_entryID) {
        if (a_entryID != null) {
            AbstractDatabaseEntry removedEntry;
            boolean bStopThread = false;
            boolean bStartThread = false;
            Object object = this.SYNC_THREAD;
            synchronized (object) {
                Hashtable hashtable = this.m_serviceDatabase;
                synchronized (hashtable) {
                    removedEntry = (AbstractDatabaseEntry)this.m_serviceDatabase.remove(a_entryID);
                    if (removedEntry != null) {
                        if (removedEntry.isPersistanceDeletionAllowed()) {
                            this.removeExternal(removedEntry);
                        }
                        this.m_timeoutList.removeElement(a_entryID);
                        if (this.m_timeoutList.size() > 0 && ((AbstractDatabaseEntry)this.m_serviceDatabase.get(this.m_timeoutList.elementAt(0))).getExpireTime() == Long.MAX_VALUE) {
                            bStopThread = true;
                        } else {
                            bStartThread = true;
                        }
                    }
                }
                if (bStartThread) {
                    this.startThread();
                } else if (bStopThread) {
                    this.stopThread();
                }
            }
            if (removedEntry != null) {
                this.setChanged();
                this.notifyObservers(new DatabaseMessage(3, removedEntry));
                return true;
            }
        }
        return false;
    }

    public boolean remove(AbstractDatabaseEntry a_deleteEntry) {
        if (a_deleteEntry != null && this.m_DatabaseEntryClass.isAssignableFrom(a_deleteEntry.getClass())) {
            return this.remove(a_deleteEntry.getId());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeThis(AbstractDatabaseEntry a_deleteEntry) {
        if (a_deleteEntry != null && this.m_DatabaseEntryClass.isAssignableFrom(a_deleteEntry.getClass())) {
            Hashtable hashtable = this.m_serviceDatabase;
            synchronized (hashtable) {
                if (this.getEntryById(a_deleteEntry.getId()) == a_deleteEntry) {
                    return this.remove(a_deleteEntry.getId());
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.SYNC_THREAD;
        synchronized (object) {
            Hashtable hashtable = this.m_serviceDatabase;
            synchronized (hashtable) {
                this.m_serviceDatabase.clear();
                this.m_timeoutList.removeAllElements();
            }
        }
        this.setChanged();
        this.notifyObservers(new DatabaseMessage(4));
    }

    public int loadFromXml(Element a_dbNode) {
        return this.loadFromXml(a_dbNode, false);
    }

    public int loadFromXml(Element a_dbNode, boolean a_bVerify) {
        int updatedEntries = 0;
        String xmlElementName = XMLUtil.getXmlElementName(this.m_DatabaseEntryClass);
        if (a_dbNode == null || xmlElementName == null) {
            return updatedEntries;
        }
        NodeList dbNodes = a_dbNode.getElementsByTagName(xmlElementName);
        Constructor constructor = null;
        try {
            constructor = this.m_DatabaseEntryClass.getConstructor(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = Database.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element, Long.TYPE);
        }
        catch (Exception a_e) {
            LogHolder.log(5, LogType.DB, "No timeout constructor for " + this.m_DatabaseEntryClass + " available.");
        }
        for (int i = 0; i < dbNodes.getLength(); ++i) {
            try {
                AbstractDatabaseEntry instance = constructor == null ? (AbstractDatabaseEntry)this.m_DatabaseEntryClass.getConstructor(class$org$w3c$dom$Element == null ? Database.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element).newInstance(dbNodes.item(i)) : (AbstractDatabaseEntry)constructor.newInstance(dbNodes.item(i), new Long(Long.MAX_VALUE));
                if (a_bVerify && instance instanceof ICertifiedDatabaseEntry && (!((ICertifiedDatabaseEntry)((Object)instance)).isVerified() || !((ICertifiedDatabaseEntry)((Object)instance)).isValid())) {
                    LogHolder.log(4, LogType.MISC, "XML entry " + dbNodes.item(i).getNodeName() + " for ID " + instance.getId() + " could not be verified while being loaded!");
                    continue;
                }
                this.update(instance);
                ++updatedEntries;
                continue;
            }
            catch (Exception e) {
                LogHolder.log(4, LogType.MISC, "Could not load db entry from XML!", e);
            }
        }
        return updatedEntries;
    }

    public Element toXmlElement(Document a_doc) {
        return this.toXmlElement(a_doc, XMLUtil.getXmlElementContainerName(this.m_DatabaseEntryClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element toXmlElement(Document a_doc, String a_xmlContainerName) {
        if (a_doc == null || !(class$anon$util$IXMLEncodable == null ? (class$anon$util$IXMLEncodable = Database.class$("anon.util.IXMLEncodable")) : class$anon$util$IXMLEncodable).isAssignableFrom(this.m_DatabaseEntryClass) || a_xmlContainerName == null || a_xmlContainerName.trim().length() == 0) {
            return null;
        }
        Element element = a_doc.createElement(a_xmlContainerName);
        Hashtable hashtable = this.m_serviceDatabase;
        synchronized (hashtable) {
            Enumeration it = this.m_serviceDatabase.elements();
            while (it.hasMoreElements()) {
                element.appendChild(((IXMLEncodable)it.nextElement()).toXmlElement(a_doc));
            }
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void randomize() {
        Hashtable hashtable = this.m_serviceDatabase;
        synchronized (hashtable) {
            if (this.m_random == null) {
                this.m_random = new MyRandom();
            }
            this.m_randomSeed = this.m_random.nextLong();
        }
    }

    public Hashtable getEntryHash() {
        return (Hashtable)this.m_serviceDatabase.clone();
    }

    public Vector getEntryList() {
        return this.getEntryList(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getEntryList(boolean a_bForceRandomize) {
        Vector entryList = new Vector();
        MyRandom random = null;
        Hashtable hashtable = this.m_serviceDatabase;
        synchronized (hashtable) {
            if (this.m_random != null) {
                this.m_random.setSeed(this.m_randomSeed, true);
            }
            random = a_bForceRandomize ? new MyRandom() : this.m_random;
            Enumeration serviceDatabaseElements = this.m_serviceDatabase.elements();
            while (serviceDatabaseElements.hasMoreElements()) {
                if (random == null || entryList.size() == 0) {
                    entryList.addElement(serviceDatabaseElements.nextElement());
                    continue;
                }
                entryList.insertElementAt(serviceDatabaseElements.nextElement(), Math.abs(random.nextInt(entryList.size() + 1)));
            }
        }
        return entryList;
    }

    public Vector getSortedEntryList(Util.Comparable c) {
        Vector entryList = this.getEntryList();
        Util.sort(entryList, c);
        return entryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getEntrySnapshotAsEnumeration() {
        Hashtable hashtable = this.m_serviceDatabase;
        synchronized (hashtable) {
            return this.getEntryList().elements();
        }
    }

    public int getNumberOfEntries() {
        return this.m_serviceDatabase.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractDatabaseEntry getEntryById(String entryId) {
        if (entryId == null) {
            return null;
        }
        AbstractDatabaseEntry resultEntry = null;
        Hashtable hashtable = this.m_serviceDatabase;
        synchronized (hashtable) {
            resultEntry = (AbstractDatabaseEntry)this.m_serviceDatabase.get(entryId);
        }
        return resultEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractDatabaseEntry getRandomEntry() {
        AbstractDatabaseEntry resultEntry = null;
        Hashtable hashtable = this.m_serviceDatabase;
        synchronized (hashtable) {
            if (this.m_timeoutList.size() > 0) {
                try {
                    String entryId = (String)this.m_timeoutList.elementAt(new MyRandom().nextInt(this.m_timeoutList.size()));
                    resultEntry = (AbstractDatabaseEntry)this.m_serviceDatabase.get(entryId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return resultEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Observer a_observer) {
        Hashtable hashtable = this.m_serviceDatabase;
        synchronized (hashtable) {
            super.addObserver(a_observer);
            a_observer.update(this, new DatabaseMessage(5, this.getEntryList()));
        }
    }

    public boolean isEntryIdInTimeoutList(String a_entryId) {
        return this.m_timeoutList.contains(a_entryId);
    }

    public int getTimeoutListSize() {
        return this.m_timeoutList.size();
    }

    public Document getWebInfos(String a_ID) {
        return Database.getWebInfos(this.getEntryClass(), a_ID);
    }

    public Document getWebInfos() {
        return Database.getWebInfos(this.getEntryClass());
    }

    private static Document getWebInfos(Class a_webInfoClass, String a_ID) {
        Element webInfoElement;
        if (!(class$anon$infoservice$Database$IWebInfo == null ? (class$anon$infoservice$Database$IWebInfo = Database.class$("anon.infoservice.Database$IWebInfo")) : class$anon$infoservice$Database$IWebInfo).isAssignableFrom(a_webInfoClass)) {
            LogHolder.log(0, LogType.DB, "Illegal class for web info: " + a_webInfoClass);
            return null;
        }
        Document webInfoDoc = XMLUtil.createDocument();
        IWebInfo webinfo = (IWebInfo)((Object)Database.getInstance(a_webInfoClass).getEntryById(a_ID));
        Element element = webInfoElement = webinfo == null ? null : webinfo.getWebInfo(webInfoDoc);
        if (webInfoElement == null) {
            return null;
        }
        webInfoDoc.appendChild(webInfoElement);
        return webInfoDoc;
    }

    private static Document getWebInfos(Class a_webInfoClass) {
        if (!(class$anon$infoservice$Database$IWebInfo == null ? (class$anon$infoservice$Database$IWebInfo = Database.class$("anon.infoservice.Database$IWebInfo")) : class$anon$infoservice$Database$IWebInfo).isAssignableFrom(a_webInfoClass)) {
            return null;
        }
        String nameContainer = Util.getStaticFieldValue(a_webInfoClass, "XML_ELEMENT_WEBINFO_CONTAINER");
        if (nameContainer == null) {
            return null;
        }
        Document allWebInfosDoc = XMLUtil.createDocument();
        Vector entries = Database.getInstance(a_webInfoClass).getEntryList();
        IWebInfo webinfo = null;
        Element rootElement = allWebInfosDoc.createElement(nameContainer);
        Element listItem = null;
        allWebInfosDoc.appendChild(rootElement);
        for (int i = 0; i < entries.size(); ++i) {
            webinfo = (IWebInfo)entries.elementAt(i);
            listItem = webinfo.getWebInfo(allWebInfosDoc);
            if (listItem == null) continue;
            rootElement.appendChild(listItem);
        }
        return allWebInfosDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExternal(AbstractDatabaseEntry a_newEntry) {
        if (ms_edbDatabase == null || !(a_newEntry instanceof IXMLEncodable) || ms_bIsLoading) {
            return;
        }
        Object object = SYNC_EXTERNAL_DATABASE;
        synchronized (object) {
            if (ms_edbDatabase == null) {
                return;
            }
            try {
                this.addExternal_int(a_newEntry);
            }
            catch (EDBException a_e) {
                LogHolder.log(2, LogType.DB, a_e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doVacuum() throws EDBException {
        if (ms_edbDatabase == null || ms_bIsLoading) {
            return;
        }
        Object object = SYNC_EXTERNAL_DATABASE;
        synchronized (object) {
            if (ms_edbDatabase == null) {
                return;
            }
            LogHolder.log(6, LogType.DB, "Vacuuming database...");
            ms_edbDatabase.doVacuum();
        }
    }

    private void addExternal_int(AbstractDatabaseEntry a_newEntry) throws EDBException {
        String content = null;
        String id = null;
        String type = null;
        try {
            id = a_newEntry.getId();
            type = Util.replaceAll(a_newEntry.getClass().getName(), ".", "__");
            Document doc = XMLUtil.toXMLDocument((IXMLEncodable)((Object)a_newEntry));
            if (doc == null) {
                throw new EDBException("Document is null!");
            }
            byte[] buff = XMLUtil.toByteArray(doc);
            content = Base64.encode(ZLibTools.compress(buff), false);
        }
        catch (Throwable t) {
            throw new EDBException("Converting AbstractDatabaseEntry to external format failed!");
        }
        ms_edbDatabase.insert(type, id, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExternal(AbstractDatabaseEntry a_newEntry) {
        if (ms_edbDatabase == null || !(a_newEntry instanceof IXMLEncodable) || ms_bIsLoading) {
            return;
        }
        Object object = SYNC_EXTERNAL_DATABASE;
        synchronized (object) {
            if (ms_edbDatabase == null) {
                return;
            }
            try {
                this.removeExternal_int(a_newEntry);
            }
            catch (EDBException a_e) {
                LogHolder.log(2, LogType.DB, a_e);
            }
        }
    }

    private void removeExternal_int(AbstractDatabaseEntry a_newEntry) throws EDBException {
        String type = Util.replaceAll(a_newEntry.getClass().getName(), ".", "__");
        ms_edbDatabase.remove(type, a_newEntry.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFromExternalDatabase() {
        if (ms_edbDatabase == null) {
            return;
        }
        Object object = SYNC_EXTERNAL_DATABASE;
        synchronized (object) {
            if (ms_edbDatabase == null) {
                return;
            }
            LogHolder.log(5, LogType.DB, "Reading cached objects from external database...");
            ms_bIsLoading = true;
            try {
                Database.loadFromExternalDatabase_int();
                LogHolder.log(5, LogType.DB, "Cached objects were read from external database.");
            }
            catch (EDBException a_e) {
                LogHolder.log(2, LogType.DB, a_e);
            }
            ms_bIsLoading = false;
        }
    }

    public static void loadFromExternalDatabase_int() throws EDBException {
        Vector vecToDelete = new Vector();
        Constructor<?> constructor = null;
        vecToDelete = ms_edbDatabase.getAllTypes();
        for (int i = 0; i < vecToDelete.size(); ++i) {
            String type = vecToDelete.elementAt(i).toString();
            String className = Util.replaceAll(type, "__", ".");
            boolean bDelete = false;
            try {
                Class<?> dbClass = Class.forName(className);
                Vector values = ms_edbDatabase.getAllValuesOfType(type);
                Enumeration enumValues = values.elements();
                while (enumValues.hasMoreElements()) {
                    AbstractDatabaseEntry instance;
                    Element xmlElement;
                    long end;
                    long start;
                    String xml = (String)enumValues.nextElement();
                    try {
                        start = System.currentTimeMillis();
                        byte[] decoded = Base64.decode(xml);
                        end = System.currentTimeMillis();
                        LogHolder.log(7, LogType.MISC, "Load from external Database - base64 decode needs [ms]: " + (end - start));
                        start = System.currentTimeMillis();
                        byte[] decompressed = ZLibTools.decompress(decoded);
                        end = System.currentTimeMillis();
                        LogHolder.log(7, LogType.MISC, "Load from external Database - decompress needs [ms]: " + (end - start));
                        start = System.currentTimeMillis();
                        Document doc = XMLUtil.toXMLDocument(decompressed);
                        end = System.currentTimeMillis();
                        LogHolder.log(7, LogType.MISC, "Load from external Database - document creation needs [ms]: " + (end - start));
                        xmlElement = doc.getDocumentElement();
                    }
                    catch (Exception a_e) {
                        LogHolder.log(2, LogType.DB, "Could not load cached DB entries for class " + className + ".", a_e);
                        bDelete = true;
                        break;
                    }
                    try {
                        start = System.currentTimeMillis();
                        constructor = dbClass.getConstructor(class$org$w3c$dom$Element == null ? Database.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element, Long.TYPE);
                        instance = (AbstractDatabaseEntry)constructor.newInstance(xmlElement, new Long(Long.MAX_VALUE));
                        long end2 = System.currentTimeMillis();
                        LogHolder.log(7, LogType.MISC, "Load from external Database - construction Database entry needs [ms]: " + (end2 - start));
                    }
                    catch (Exception a_e) {
                        try {
                            long start2 = System.currentTimeMillis();
                            constructor = dbClass.getConstructor(class$org$w3c$dom$Element == null ? Database.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element);
                            instance = (AbstractDatabaseEntry)constructor.newInstance(xmlElement);
                            end = System.currentTimeMillis();
                            LogHolder.log(7, LogType.MISC, "Load from external Database - construction Database entry needs [ms]: " + (end - start2));
                        }
                        catch (Exception a_e2) {
                            LogHolder.log(2, LogType.DB, "Could not load cached DB entries for class " + className + ".", a_e2);
                            bDelete = true;
                            break;
                        }
                    }
                    LogHolder.log(6, LogType.DB, "Loading cached DB entry " + instance.getClass().getName() + ":" + instance.getId() + ".");
                    Database.getInstance(dbClass).update(instance);
                }
            }
            catch (ClassNotFoundException a_e) {
                LogHolder.log(2, LogType.DB, "Could not load cached DB entries for class " + className + ".", a_e);
                bDelete = true;
            }
            if (!bDelete) continue;
            ms_edbDatabase.removeType(type);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ms_bShutdown = false;
        SYNC_EXTERNAL_DATABASE = new Object();
        ms_bIsLoading = false;
    }

    public static interface IWebInfo {
        public static final String FIELD_XML_ELEMENT_WEBINFO_CONTAINER = "XML_ELEMENT_WEBINFO_CONTAINER";

        public Element getWebInfo(Document var1);
    }

    private class TimeoutThread
    implements Runnable {
        private TimeoutThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LogHolder.log(6, LogType.DB, "Starting timeout database thread for class " + Database.this.m_DatabaseEntryClass.toString() + ".");
            while (!(Database.this.m_bStopThread || ms_bShutdown || Thread.currentThread().isInterrupted())) {
                boolean moreOldEntrys = true;
                Hashtable hashtable = Database.this.m_serviceDatabase;
                synchronized (hashtable) {
                    while (!Database.this.m_bStopThread && !ms_bShutdown && !Thread.currentThread().isInterrupted() && Database.this.m_timeoutList.size() > 0 && moreOldEntrys) {
                        AbstractDatabaseEntry entry = (AbstractDatabaseEntry)Database.this.m_serviceDatabase.get(Database.this.m_timeoutList.firstElement());
                        if (System.currentTimeMillis() >= entry.getExpireTime()) {
                            LogHolder.log(6, LogType.MISC, "DatabaseEntry (" + entry.getClass().getName() + ")" + entry.getId() + " has reached the expire time and is removed.");
                            AbstractDatabaseEntry removedEntry = (AbstractDatabaseEntry)Database.this.m_serviceDatabase.remove(entry.getId());
                            if (removedEntry != null && removedEntry.isPersistanceDeletionAllowed()) {
                                Database.this.removeExternal(removedEntry);
                            }
                            Database.this.m_timeoutList.removeElementAt(0);
                            Database.this.setChanged();
                            Database.this.notifyObservers(new DatabaseMessage(3, entry));
                            continue;
                        }
                        moreOldEntrys = false;
                    }
                    if (Database.this.m_bStopThread || ms_bShutdown || Thread.currentThread().isInterrupted()) {
                        return;
                    }
                }
                hashtable = Database.this.m_serviceDatabase;
                synchronized (hashtable) {
                    block19: {
                        block18: {
                            long sleepTime = 0L;
                            if (Database.this.m_timeoutList.size() > 0) {
                                sleepTime = ((AbstractDatabaseEntry)Database.this.m_serviceDatabase.get(Database.this.m_timeoutList.firstElement())).getExpireTime() - System.currentTimeMillis();
                            }
                            if (sleepTime > 0L) {
                                try {
                                    Database.this.m_serviceDatabase.wait(sleepTime);
                                    LogHolder.log(7, LogType.MISC, "One entry could be expired. Wake up...");
                                }
                                catch (InterruptedException e) {
                                    if (!Database.this.m_bStopThread && !ms_bShutdown && !Thread.currentThread().isInterrupted()) break block18;
                                    return;
                                }
                            }
                        }
                        if (Database.this.m_timeoutList.size() == 0) {
                            try {
                                Database.this.m_serviceDatabase.wait();
                                LogHolder.log(7, LogType.MISC, "First entry in the database. Look when it expires. Wake up...");
                            }
                            catch (InterruptedException e) {
                                if (!Database.this.m_bStopThread && !ms_bShutdown && !Thread.currentThread().isInterrupted()) break block19;
                                return;
                            }
                        }
                    }
                }
            }
        }
    }
}

