/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.infoservice.Database;
import anon.infoservice.ServiceOperator;
import anon.terms.TermsAndConditions;
import anon.util.JAPMessages;
import jap.OperatorsCellRenderer;
import jap.TermsAndCondtionsTableController;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import logging.LogHolder;
import logging.LogType;

public class TermsAndConditionsOperatorTable
extends JTable
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private static final int OPERATOR_COL = 0;
    private static final int DATE_COL = 1;
    private static final int ACCEPTED_COL = 2;
    private static final String OPERATOR_COL_NAMEKEY = "mixOperator";
    private static final String DATE_COL_NAMEKEY = "validFrom";
    private static final String ACCEPTED_COL_NAMEKEY = (class$jap$JAPConfTC == null ? (class$jap$JAPConfTC = TermsAndConditionsOperatorTable.class$("jap.JAPConfTC")) : class$jap$JAPConfTC).getName() + "_tncAccepted";
    private static final int COLS = 3;
    private TermsAndCondtionsTableController controller;
    static /* synthetic */ Class class$jap$JAPConfTC;
    static /* synthetic */ Class class$anon$infoservice$ServiceOperator;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Boolean;

    public TermsAndConditionsOperatorTable() {
        this((Vector)null);
    }

    public TermsAndConditionsOperatorTable(Vector operators) {
        OperatorTableModel model = operators != null ? new OperatorTableModel(operators) : new OperatorTableModel();
        this.setModel(model);
        this.setDefaultRenderer(class$anon$infoservice$ServiceOperator == null ? (class$anon$infoservice$ServiceOperator = TermsAndConditionsOperatorTable.class$("anon.infoservice.ServiceOperator")) : class$anon$infoservice$ServiceOperator, new OperatorsCellRenderer());
        this.setSelectionMode(0);
        this.getColumnModel().getColumn(0).setMinWidth(200);
        this.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.getColumnModel().getColumn(1).setMinWidth(100);
        this.getColumnModel().getColumn(1).setPreferredWidth(100);
        int opertorsSize = this.getOperators().size();
        this.setPreferredSize(new Dimension(450, Math.min(10 + opertorsSize * 12, 100)));
        this.addMouseListener(this);
    }

    public void mouseClicked(MouseEvent e) {
        if (this.controller != null) {
            ServiceOperator selectedOp = (ServiceOperator)this.getModel().getValueAt(this.getSelectedRow(), 0);
            boolean accepted = (Boolean)this.getModel().getValueAt(this.getSelectedRow(), 2);
            if ((this.getSelectedColumn() == 0 || this.getSelectedColumn() == 1) && e.getClickCount() > 1) {
                this.getModel().setValueAt(new Boolean(this.controller.handleOperatorAction(selectedOp, accepted)), this.getSelectedRow(), 2);
            } else if (this.getSelectedColumn() != 2) {
                this.controller.handleSelectLineAction(selectedOp);
            }
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public TermsAndCondtionsTableController getController() {
        return this.controller;
    }

    public void setController(TermsAndCondtionsTableController controller) {
        this.controller = controller;
    }

    public void setOperators(Vector operators) {
        this.checkModel();
        ((OperatorTableModel)this.getModel()).setOperators(operators);
        this.repaint();
    }

    public Vector getOperators() {
        this.checkModel();
        return ((OperatorTableModel)this.getModel()).getOperators();
    }

    public Vector getTermsAccepted() {
        this.checkModel();
        return ((OperatorTableModel)this.getModel()).getTermsAccepted();
    }

    public Vector getTermsRejected() {
        this.checkModel();
        return ((OperatorTableModel)this.getModel()).getTermsRejected();
    }

    public boolean areTermsRejected() {
        this.checkModel();
        return ((OperatorTableModel)this.getModel()).areTermsRejected();
    }

    private void checkModel() {
        if (this.getModel() == null) {
            throw new IllegalStateException("Current model is null");
        }
        if (!(this.getModel() instanceof OperatorTableModel)) {
            throw new IllegalStateException("Wrong model set " + this.getModel().getClass());
        }
    }

    public void setAccepted(int row, boolean value) {
        this.setValueAt(new Boolean(value), row, 2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class OperatorTableModel
    extends AbstractTableModel {
        private Vector m_vecOperators = new Vector();
        private String[] columnNames;
        private Class[] columnClasses;
        private BitSet accepted = new BitSet();

        public OperatorTableModel(Vector operators) {
            this.columnClasses = new Class[3];
            this.columnNames = new String[3];
            this.columnClasses[0] = class$anon$infoservice$ServiceOperator == null ? (class$anon$infoservice$ServiceOperator = TermsAndConditionsOperatorTable.class$("anon.infoservice.ServiceOperator")) : class$anon$infoservice$ServiceOperator;
            this.columnClasses[1] = class$java$util$Date == null ? (class$java$util$Date = TermsAndConditionsOperatorTable.class$("java.util.Date")) : class$java$util$Date;
            this.columnClasses[2] = class$java$lang$Boolean == null ? (class$java$lang$Boolean = TermsAndConditionsOperatorTable.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            this.columnNames[0] = JAPMessages.getString(TermsAndConditionsOperatorTable.OPERATOR_COL_NAMEKEY);
            this.columnNames[1] = JAPMessages.getString(TermsAndConditionsOperatorTable.DATE_COL_NAMEKEY);
            this.columnNames[2] = JAPMessages.getString(ACCEPTED_COL_NAMEKEY);
            this.setOperators(operators);
        }

        public OperatorTableModel() {
            this(Database.getInstance(class$anon$infoservice$ServiceOperator == null ? (class$anon$infoservice$ServiceOperator = TermsAndConditionsOperatorTable.class$("anon.infoservice.ServiceOperator")) : class$anon$infoservice$ServiceOperator).getEntryList());
        }

        public int getRowCount() {
            return this.m_vecOperators.size();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2 || columnIndex == 0;
        }

        public Class getColumnClass(int columnIndex) {
            return this.columnClasses[columnIndex];
        }

        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                switch (columnIndex) {
                    case 0: {
                        return (ServiceOperator)this.m_vecOperators.elementAt(rowIndex);
                    }
                    case 1: {
                        ServiceOperator op = (ServiceOperator)this.m_vecOperators.elementAt(rowIndex);
                        TermsAndConditions tc = TermsAndConditions.getTermsAndConditions(op);
                        return tc != null ? tc.getDate() : null;
                    }
                    case 2: {
                        return new Boolean(this.accepted.get(rowIndex));
                    }
                }
                throw new IndexOutOfBoundsException("No definition for column " + columnIndex);
            }
            catch (Exception ex) {
                LogHolder.log(3, LogType.GUI, ex);
                return null;
            }
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    boolean accept = (Boolean)aValue;
                    this.setAccepted(rowIndex, accept);
                    if (TermsAndConditionsOperatorTable.this.controller == null) break;
                    try {
                        TermsAndConditionsOperatorTable.this.controller.handleAcceptAction((ServiceOperator)this.getValueAt(rowIndex, 0), accept);
                    }
                    catch (IllegalStateException e) {
                        this.setAccepted(rowIndex, !accept);
                    }
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException("No definition for column " + columnIndex);
                }
            }
        }

        public void setOperators(Vector operators) {
            Object obj = null;
            this.m_vecOperators.removeAllElements();
            for (int i = 0; i < this.accepted.size(); ++i) {
                this.accepted.clear(i);
            }
            if (operators != null) {
                int operatorCount = 0;
                for (int i = 0; i < operators.size(); ++i) {
                    obj = operators.elementAt(i);
                    if (!(obj instanceof ServiceOperator) || !((ServiceOperator)obj).hasTermsAndConditions()) continue;
                    this.m_vecOperators.addElement(obj);
                    if (TermsAndConditions.getTermsAndConditions((ServiceOperator)obj).isAccepted()) {
                        this.accepted.set(operatorCount);
                    }
                    ++operatorCount;
                }
            }
        }

        public Vector getOperators() {
            return this.m_vecOperators;
        }

        public ServiceOperator getOperator(int row) {
            return (ServiceOperator)this.getValueAt(row, 0);
        }

        public Vector getTermsAccepted() {
            return this.getTermsWithAcceptStatus(true);
        }

        public Vector getTermsRejected() {
            return this.getTermsWithAcceptStatus(false);
        }

        public boolean areTermsRejected() {
            for (int i = 0; i < this.m_vecOperators.size(); ++i) {
                if (this.accepted.get(i)) continue;
                return true;
            }
            return false;
        }

        public void setAccepted(int index, boolean value) {
            if (value) {
                this.accepted.set(index);
            } else {
                this.accepted.clear(index);
            }
        }

        private Vector getTermsWithAcceptStatus(boolean acceptStatus) {
            Vector<TermsAndConditions> v = new Vector<TermsAndConditions>();
            ServiceOperator o = null;
            for (int i = 0; i < this.m_vecOperators.size(); ++i) {
                o = (ServiceOperator)this.m_vecOperators.elementAt(i);
                if (!o.hasTermsAndConditions() || this.accepted.get(i) != acceptStatus) continue;
                v.addElement(TermsAndConditions.getTermsAndConditions(o));
            }
            return v;
        }
    }
}

