/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.platform.AbstractOS;
import anon.util.ClassUtil;
import anon.util.RecursiveFileTool;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import anon.util.ZipArchiver;
import gui.help.AbstractHelpFileStorageManager;
import java.io.File;
import java.io.IOException;
import java.util.Observable;
import java.util.zip.ZipFile;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class JARHelpFileStorageManager
extends AbstractHelpFileStorageManager {
    public static final String HELP_VERSION_NODE = "jondohelp";
    public static final String HELP_VERSION_ATTRIBUTE = "version";
    public static final String HELP_VERSION_FILE = "jondohelp.xml";
    private String m_helpPath;
    private ZipArchiver m_archiver;

    public JARHelpFileStorageManager() {
        ZipFile japArchive = ClassUtil.getJarFile();
        if (japArchive == null) {
            // empty if block
        }
        this.m_archiver = new ZipArchiver(japArchive);
    }

    private void setHelpPath(String helpPath) {
        this.m_helpPath = helpPath;
    }

    public boolean helpVersionMismatch() {
        String versionString = this.getHelpVersion(this.m_helpPath + File.separator + "help");
        if (versionString == null) {
            return true;
        }
        return !"00.20.010".equals(versionString);
    }

    public boolean handleHelpPathChanged(String oldHelpPath, String newHelpPath, boolean a_bIgnoreExistingHelpDir) {
        boolean installationSuccessful = true;
        this.setHelpPath(newHelpPath);
        if (oldHelpPath != null) {
            this.removeOldHelp(oldHelpPath, false);
        }
        if (newHelpPath != null) {
            installationSuccessful = this.installHelp(a_bIgnoreExistingHelpDir);
        }
        return installationSuccessful;
    }

    public String helpPathValidityCheck(String a_absolutePath, boolean a_bIgnoreExistingHelpDir) {
        if (a_absolutePath != null) {
            File hpFile = new File(a_absolutePath);
            if (a_absolutePath.indexOf("JonDo") >= 0) {
                a_bIgnoreExistingHelpDir = true;
            }
            if (hpFile.exists()) {
                if (hpFile.isDirectory()) {
                    int index;
                    String strPath = a_absolutePath;
                    while ((index = strPath.toLowerCase().lastIndexOf("help".toLowerCase())) >= 0) {
                        if (!new File(strPath.substring(0, index + "help".length())).exists()) {
                            LogHolder.log(0, LogType.MISC, "Existing help directory was not found!");
                        }
                        if (this.getHelpVersion(strPath.substring(0, index + "help".length())) != null) {
                            return "helpNested";
                        }
                        strPath = strPath.substring(0, index);
                    }
                    strPath = AbstractOS.getInstance().getenv("ALLUSERSPROFILE");
                    if (strPath != null && hpFile.getPath().indexOf(strPath) >= 0) {
                        return "helpVirtual";
                    }
                    strPath = AbstractOS.getInstance().getenv("PROGRAMFILES");
                    if (strPath != null && hpFile.getPath().indexOf(strPath) >= 0) {
                        return "helpVirtual";
                    }
                    strPath = AbstractOS.getInstance().getenv("SYSTEMROOT");
                    if (strPath != null && hpFile.getPath().indexOf(strPath) >= 0) {
                        return "helpVirtual";
                    }
                    strPath = AbstractOS.getInstance().getenv("PROGRAMDATA");
                    if (strPath != null && hpFile.getPath().indexOf(strPath) >= 0) {
                        return "helpVirtual";
                    }
                    File helpDir = new File(hpFile.getPath() + File.separator + "help" + File.separator);
                    if (!helpDir.exists()) {
                        try {
                            if (!helpDir.mkdir()) {
                                return "invalidHelpPathNoWrite";
                            }
                            helpDir.delete();
                        }
                        catch (SecurityException a_e) {
                            return "invalidHelpPathNoWrite";
                        }
                        return "HELP_IS_VALID";
                    }
                    File jondoHelpFileVersion = new File(helpDir.getPath() + File.separator + HELP_VERSION_FILE);
                    if (a_bIgnoreExistingHelpDir || jondoHelpFileVersion.exists()) {
                        try {
                            if (!helpDir.canWrite()) {
                                return "invalidHelpPathNoWrite";
                            }
                        }
                        catch (SecurityException a_e) {
                            LogHolder.log(2, LogType.MISC, a_e);
                            return "invalidHelpPathNoWrite";
                        }
                        try {
                            if (!helpDir.canRead() || helpDir.list() == null) {
                                return "invalidHelpPathNoRead";
                            }
                        }
                        catch (SecurityException a_e) {
                            LogHolder.log(2, LogType.MISC, a_e);
                            return "invalidHelpPathNoRead";
                        }
                        return "helpJonDoExists";
                    }
                    LogHolder.log(4, LogType.GUI, "Found help directory without this version file: " + jondoHelpFileVersion);
                    return "helpDirExists";
                }
                return "helpNoDir";
            }
            return "invalidHelpPathNotExists";
        }
        return "invalidHelpPathNull";
    }

    public Observable getStorageObservable() {
        return this.m_archiver;
    }

    public boolean extractHelpFiles(String a_extractionPath) {
        return this.extractHelpFiles(a_extractionPath, true);
    }

    private boolean extractHelpFiles(String a_extractionPath, boolean bAcceptHelpFolderInPath) {
        if (a_extractionPath == null) {
            LogHolder.log(3, LogType.MISC, "Invalid directory for help extraction: " + a_extractionPath);
            return false;
        }
        boolean installationSuccessful = this.m_archiver.extractArchive("help/", a_extractionPath);
        if (installationSuccessful) {
            JARHelpFileStorageManager.createHelpVersionDoc(a_extractionPath);
            return true;
        }
        LogHolder.log(3, LogType.MISC, "Extracting help files was not succesful.");
        return false;
    }

    private boolean installHelp(boolean a_bIgnoreExistingHelpDir) {
        File helpFolder = this.getHelpFolder();
        if (helpFolder == null) {
            LogHolder.log(0, LogType.MISC, "Destination folder is null: Aborting help installation");
            return false;
        }
        if (this.m_archiver == null) {
            LogHolder.log(0, LogType.MISC, "JARStorageManager does only work when started from a Jar file");
            return false;
        }
        if (helpFolder.exists()) {
            if (this.helpVersionMismatch()) {
                this.removeOldHelp(this.m_helpPath, a_bIgnoreExistingHelpDir);
                if (helpFolder.exists()) {
                    LogHolder.log(0, LogType.MISC, "Could not delete old help directory!");
                    return false;
                }
            } else {
                LogHolder.log(5, LogType.MISC, "Previous help installation restored.");
                return true;
            }
        }
        return this.extractHelpFiles(this.m_helpPath, false);
    }

    private static void createHelpVersionDoc(String a_extractionPath) {
        Document helpVersionDoc = XMLUtil.createDocument();
        Element helpVersionNode = helpVersionDoc.createElement(HELP_VERSION_NODE);
        XMLUtil.setAttribute(helpVersionNode, HELP_VERSION_ATTRIBUTE, "00.20.010");
        helpVersionDoc.appendChild(helpVersionNode);
        File versionInfoFile = new File(a_extractionPath + File.separator + "help" + File.separator + HELP_VERSION_FILE);
        try {
            XMLUtil.write(helpVersionDoc, versionInfoFile);
        }
        catch (IOException ioe) {
            LogHolder.log(4, LogType.MISC, "Could not write help version due to an I/O error: ", ioe);
        }
    }

    private boolean removeOldHelp(String parentPath, boolean a_bIgnoreExistingHelpDir) {
        if (parentPath == null) {
            return true;
        }
        File helpFolder = new File(parentPath + File.separator + "help" + File.separator);
        File helpVersionFile = new File(parentPath + File.separator + "help" + File.separator + HELP_VERSION_FILE);
        try {
            if (!helpFolder.exists() || !a_bIgnoreExistingHelpDir && !helpVersionFile.exists() && helpFolder.list().length > 0) {
                LogHolder.log(6, LogType.MISC, "No old help found in " + helpFolder.getPath());
                return true;
            }
        }
        catch (SecurityException a_e) {
            LogHolder.log(6, LogType.MISC, "No old help found in " + helpFolder.getPath(), a_e);
            return false;
        }
        if (!RecursiveFileTool.deleteRecursion(helpFolder)) {
            LogHolder.log(4, LogType.MISC, "Failed to delete old help at first try - try again!");
            RecursiveFileTool.deleteRecursion(helpFolder);
        }
        if (!helpFolder.exists()) {
            LogHolder.log(7, LogType.MISC, "removed old help from " + parentPath);
            return true;
        }
        return false;
    }

    private boolean isHelpInstalled() {
        File helpFolder = this.getHelpFolder();
        if (helpFolder == null) {
            return false;
        }
        if (helpFolder.exists()) {
            return true;
        }
        LogHolder.log(4, LogType.GUI, "Checked for help folder " + helpFolder + " but it did not exist");
        return false;
    }

    private String getHelpVersion(String a_helpFolder) {
        try {
            File versionInfoFile = new File(a_helpFolder + File.separator + HELP_VERSION_FILE);
            if (!versionInfoFile.exists()) {
                return null;
            }
            Document doc = XMLUtil.readXMLDocument(versionInfoFile);
            Node versionNode = XMLUtil.getFirstChildByName(doc, HELP_VERSION_NODE);
            String versionString = XMLUtil.parseAttribute(versionNode, HELP_VERSION_ATTRIBUTE, null);
            return versionString;
        }
        catch (IOException ioe) {
            LogHolder.log(3, LogType.MISC, "Error: an I/O error occured while parsing help version file: ", ioe);
        }
        catch (XMLParseException xpe) {
            LogHolder.log(3, LogType.MISC, "Error: help version file cannot be parsed: ", xpe);
        }
        return null;
    }

    private File getHelpFolder() {
        if (this.m_helpPath == null) {
            return null;
        }
        return new File(this.m_helpPath + File.separator + "help" + File.separator);
    }

    public boolean ensureMostRecentVersion(String helpPath) {
        this.setHelpPath(helpPath);
        if (this.helpVersionMismatch() || !this.isHelpInstalled()) {
            if (this.m_helpPath != null && this.m_helpPath.indexOf("JonDo") >= 0) {
                return this.installHelp(true);
            }
            return this.installHelp(false);
        }
        return true;
    }

    public boolean helpInstallationExists(String helpPath) {
        this.setHelpPath(helpPath);
        return this.isHelpInstalled();
    }
}

