/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.infoservice.Database;
import anon.infoservice.ServiceOperator;
import anon.terms.TermsAndConditions;
import anon.terms.TermsAndConditionsResponseHandler;
import anon.util.JAPMessages;
import gui.JAPHyperlinkAdapter;
import gui.UpperLeftStartViewport;
import gui.dialog.JAPDialog;
import jap.AbstractJAPConfModule;
import jap.IJAPConfSavePoint;
import jap.JAPConf;
import jap.JAPController;
import jap.TermsAndConditionsOperatorTable;
import jap.TermsAndCondtionsTableController;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JAPConfTC
extends AbstractJAPConfModule
implements Observer,
TermsAndCondtionsTableController {
    private static final String MSG_TAB_TITLE = (class$jap$JAPConfTC == null ? (class$jap$JAPConfTC = JAPConfTC.class$("jap.JAPConfTC")) : class$jap$JAPConfTC).getName() + "_tabTitle";
    private static final String MSG_ERR_REJECT_IMPOSSIBLE = (class$jap$JAPConfTC == null ? (class$jap$JAPConfTC = JAPConfTC.class$("jap.JAPConfTC")) : class$jap$JAPConfTC).getName() + "_errRejectImpossible";
    private TermsAndConditionsOperatorTable m_tblOperators;
    private JEditorPane m_termsPane;
    private JScrollPane m_scrollingTerms;
    static /* synthetic */ Class class$jap$JAPConfTC;
    static /* synthetic */ Class class$anon$infoservice$ServiceOperator;

    protected JAPConfTC(IJAPConfSavePoint savePoint) {
        super(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initObservers() {
        if (super.initObservers()) {
            Object object = this.LOCK_OBSERVABLE;
            synchronized (object) {
                TermsAndConditionsResponseHandler.get().addObserver(this);
                return true;
            }
        }
        return false;
    }

    public String getTabTitle() {
        return JAPMessages.getString(MSG_TAB_TITLE);
    }

    public void recreateRootPanel() {
        JPanel root = this.getRootPanel();
        root.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.2;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.fill = 1;
        this.m_tblOperators = new TermsAndConditionsOperatorTable();
        this.m_tblOperators.setController(this);
        JScrollPane scroll = new JScrollPane(this.m_tblOperators);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setPreferredSize(this.m_tblOperators.getPreferredSize());
        root.add((Component)scroll, c);
        ++c.gridy;
        c.weighty = 0.8;
        this.m_termsPane = new JEditorPane("text/html", "");
        this.m_termsPane.addHyperlinkListener(new JAPHyperlinkAdapter());
        this.m_termsPane.setEditable(false);
        this.m_scrollingTerms = new JScrollPane();
        this.m_scrollingTerms.setViewport(new UpperLeftStartViewport());
        this.m_scrollingTerms.getViewport().add(this.m_termsPane);
        root.add((Component)this.m_scrollingTerms, c);
        root.validate();
    }

    public String getHelpContext() {
        return "services_tc";
    }

    protected void onRootPanelShown() {
        this.m_tblOperators.setOperators(Database.getInstance(class$anon$infoservice$ServiceOperator == null ? (class$anon$infoservice$ServiceOperator = JAPConfTC.class$("anon.infoservice.ServiceOperator")) : class$anon$infoservice$ServiceOperator).getEntryList());
    }

    protected boolean onOkPressed() {
        Vector[] allHandledTerms = new Vector[]{this.m_tblOperators.getTermsAccepted(), this.m_tblOperators.getTermsRejected()};
        TermsAndConditions terms = null;
        boolean accept = false;
        boolean errorDialogShown = false;
        for (int j = 0; j < allHandledTerms.length; ++j) {
            boolean bl = accept = j == 0;
            if (allHandledTerms[j] == null) continue;
            for (int i = 0; i < allHandledTerms[j].size(); ++i) {
                terms = (TermsAndConditions)allHandledTerms[j].elementAt(i);
                if (terms == null) continue;
                if (!accept && !JAPController.getInstance().isOperatorOfConnectedMix(terms.getOperator())) {
                    if (errorDialogShown) continue;
                    JAPDialog.showErrorDialog((JAPDialog)JAPConf.getInstance(), JAPMessages.getString(MSG_ERR_REJECT_IMPOSSIBLE, terms.getOperator().getOrganization()));
                    errorDialogShown = true;
                    continue;
                }
                terms.setAccepted(accept);
            }
        }
        this.m_tblOperators.setOperators(Database.getInstance(class$anon$infoservice$ServiceOperator == null ? (class$anon$infoservice$ServiceOperator = JAPConfTC.class$("anon.infoservice.ServiceOperator")) : class$anon$infoservice$ServiceOperator).getEntryList());
        return true;
    }

    protected void onCancelPressed() {
        this.m_tblOperators.setOperators(Database.getInstance(class$anon$infoservice$ServiceOperator == null ? (class$anon$infoservice$ServiceOperator = JAPConfTC.class$("anon.infoservice.ServiceOperator")) : class$anon$infoservice$ServiceOperator).getEntryList());
    }

    public void update(Observable o, Object arg) {
        this.onUpdateValues();
        this.getRootPanel().revalidate();
    }

    protected void onUpdateValues() {
        this.m_tblOperators.setOperators(Database.getInstance(class$anon$infoservice$ServiceOperator == null ? (class$anon$infoservice$ServiceOperator = JAPConfTC.class$("anon.infoservice.ServiceOperator")) : class$anon$infoservice$ServiceOperator).getEntryList());
    }

    public boolean handleOperatorAction(ServiceOperator operator, boolean accepted) {
        return accepted;
    }

    public void handleSelectLineAction(ServiceOperator operator) {
        TermsAndConditions tc = TermsAndConditions.getTermsAndConditions(operator);
        if (tc == null) {
            return;
        }
        String tcHtmlText = tc.getHTMLText(JAPMessages.getLocale());
        this.m_termsPane.setText(tcHtmlText);
    }

    public void handleAcceptAction(ServiceOperator operator, boolean accept) {
        if (!accept && !JAPController.getInstance().isOperatorOfConnectedMix(operator)) {
            JAPDialog.showErrorDialog((JAPDialog)JAPConf.getInstance(), JAPMessages.getString(MSG_ERR_REJECT_IMPOSSIBLE, operator.getOrganization()));
            throw new IllegalStateException(JAPMessages.getString(MSG_ERR_REJECT_IMPOSSIBLE, operator.getOrganization()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

