/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.crypto.CertPath;
import anon.crypto.CertificateInfoStructure;
import anon.crypto.JAPCertificate;
import anon.crypto.SignatureVerifier;
import anon.util.JAPMessages;
import gui.CAListCellRenderer;
import gui.CertDetailsDialog;
import gui.dialog.JAPDialog;
import jap.AbstractJAPConfModule;
import jap.JAPConfCertSavePoint;
import jap.JAPUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

final class JAPConfCert
extends AbstractJAPConfModule
implements Observer {
    public static final String MSG_NO_CHECK_WARNING = (class$jap$JAPConfCert == null ? (class$jap$JAPConfCert = JAPConfCert.class$("jap.JAPConfCert")) : class$jap$JAPConfCert).getName() + "_noCheckWarning";
    private static final String MSG_DETAILS = (class$jap$JAPConfCert == null ? (class$jap$JAPConfCert = JAPConfCert.class$("jap.JAPConfCert")) : class$jap$JAPConfCert).getName() + "_details";
    private TitledBorder m_borderCert;
    private CertDetailsDialog.CertShortInfoPanel m_shortInfoPanel;
    private JButton m_bttnCertInsert;
    private JButton m_bttnCertRemove;
    private JButton m_bttnCertStatus;
    private JButton m_bttnCertDetails;
    private DefaultListModel m_listmodelCertList;
    private JList m_listCert;
    private JScrollPane m_scrpaneList;
    private Enumeration m_enumCerts;
    private JCheckBox m_cbCertCheckEnabled;
    private JPanel m_panelCAList;
    private Vector m_deletedCerts = new Vector();
    private boolean m_bDoNotUpdate = false;
    static /* synthetic */ Class class$jap$JAPConfCert;

    public JAPConfCert() {
        super(new JAPConfCertSavePoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initObservers() {
        if (super.initObservers()) {
            Object object = this.LOCK_OBSERVABLE;
            synchronized (object) {
                SignatureVerifier.getInstance().getVerificationCertificateStore().addObserver(this);
                this.update(SignatureVerifier.getInstance().getVerificationCertificateStore(), null);
                return true;
            }
        }
        return false;
    }

    public void recreateRootPanel() {
        JPanel panelRoot = this.getRootPanel();
        panelRoot.removeAll();
        this.m_borderCert = new TitledBorder(JAPMessages.getString("confCertTab"));
        panelRoot.setBorder(this.m_borderCert);
        JPanel caLabel = this.createCALabel();
        this.m_panelCAList = this.createCertCAPanel();
        this.m_shortInfoPanel = new CertDetailsDialog.CertShortInfoPanel();
        panelRoot.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        panelRoot.add((Component)caLabel, c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panelRoot.add((Component)this.m_panelCAList, c);
        ++c.gridy;
        c.insets = new Insets(10, 10, 10, 10);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.fill = 2;
        panelRoot.add((Component)new JSeparator(), c);
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        panelRoot.add((Component)this.m_shortInfoPanel, c);
    }

    public String getTabTitle() {
        return JAPMessages.getString("confCertTab");
    }

    private JPanel createCALabel() {
        JPanel r_panelCALabel = new JPanel();
        GridBagLayout panelLayoutCA = new GridBagLayout();
        r_panelCALabel.setLayout(panelLayoutCA);
        this.m_cbCertCheckEnabled = new JCheckBox(JAPMessages.getString("certTrust") + ":");
        this.m_cbCertCheckEnabled.setSelected(true);
        this.m_cbCertCheckEnabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a_event) {
                if (!JAPConfCert.this.m_cbCertCheckEnabled.isSelected()) {
                    JAPDialog.showWarningDialog(JAPConfCert.this.m_cbCertCheckEnabled, JAPMessages.getString(MSG_NO_CHECK_WARNING));
                }
            }
        });
        this.m_cbCertCheckEnabled.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = JAPConfCert.this.m_cbCertCheckEnabled.isSelected();
                JAPConfCert.this.m_shortInfoPanel.setEnabled(b);
                JAPConfCert.this.m_bttnCertInsert.setEnabled(b);
                Object value = JAPConfCert.this.m_listCert.getSelectedValue();
                boolean enableRemove = false;
                if (value != null) {
                    enableRemove = b && !((CertificateInfoStructure)JAPConfCert.this.m_listCert.getSelectedValue()).isNotRemovable();
                }
                JAPConfCert.this.m_bttnCertRemove.setEnabled(enableRemove);
                JAPConfCert.this.m_bttnCertStatus.setEnabled(b);
                JAPConfCert.this.m_bttnCertDetails.setEnabled(b);
                JAPConfCert.this.m_listCert.setEnabled(b);
                JAPConfCert.this.m_panelCAList.setEnabled(b);
            }
        });
        GridBagConstraints panelConstraintsCA = new GridBagConstraints();
        panelConstraintsCA.anchor = 17;
        panelConstraintsCA.fill = 0;
        panelConstraintsCA.weightx = 0.0;
        panelConstraintsCA.insets = new Insets(10, 10, 0, 0);
        panelConstraintsCA.gridx = 0;
        panelConstraintsCA.gridy = 0;
        r_panelCALabel.add((Component)this.m_cbCertCheckEnabled, panelConstraintsCA);
        panelConstraintsCA.gridx = 1;
        panelConstraintsCA.gridy = 0;
        panelConstraintsCA.weightx = 1.0;
        panelConstraintsCA.insets = new Insets(10, 0, 10, 0);
        r_panelCALabel.add((Component)new JLabel(), panelConstraintsCA);
        return r_panelCALabel;
    }

    private JPanel createCertCAPanel() {
        JPanel r_panelCA = new JPanel();
        GridBagLayout panelLayoutCA = new GridBagLayout();
        r_panelCA.setLayout(panelLayoutCA);
        GridBagConstraints panelConstraintsCA = new GridBagConstraints();
        this.m_listmodelCertList = new DefaultListModel();
        this.m_listCert = new JList(this.m_listmodelCertList);
        this.m_listCert.setSelectionMode(0);
        this.m_listCert.setCellRenderer(new CAListCellRenderer());
        this.m_listCert.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (JAPConfCert.this.m_listmodelCertList.getSize() == 0 || JAPConfCert.this.m_listCert.getSelectedValue() == null) {
                    JAPConfCert.this.m_shortInfoPanel.update((JAPCertificate)null);
                    JAPConfCert.this.m_bttnCertRemove.setEnabled(false);
                    JAPConfCert.this.m_bttnCertStatus.setEnabled(false);
                    JAPConfCert.this.m_bttnCertDetails.setEnabled(false);
                } else {
                    CertificateInfoStructure j = (CertificateInfoStructure)JAPConfCert.this.m_listCert.getSelectedValue();
                    JAPConfCert.this.m_shortInfoPanel.update(j.getCertificate());
                    if (j.isEnabled()) {
                        JAPConfCert.this.m_bttnCertStatus.setText(JAPMessages.getString("certBttnDisable"));
                    } else {
                        JAPConfCert.this.m_bttnCertStatus.setText(JAPMessages.getString("certBttnEnable"));
                    }
                    JAPConfCert.this.m_bttnCertStatus.setEnabled(true);
                    JAPConfCert.this.m_bttnCertRemove.setEnabled(!j.isNotRemovable());
                    JAPConfCert.this.m_bttnCertDetails.setEnabled(true);
                }
            }
        });
        this.m_listCert.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent a_event) {
                if (a_event.getClickCount() == 2) {
                    JAPConfCert.this.m_bttnCertDetails.doClick();
                }
            }
        });
        this.m_scrpaneList = new JScrollPane();
        this.m_scrpaneList.getViewport().add((Component)this.m_listCert, null);
        panelConstraintsCA.gridx = 0;
        panelConstraintsCA.gridy = 0;
        panelConstraintsCA.anchor = 18;
        panelConstraintsCA.weightx = 1.0;
        panelConstraintsCA.weighty = 1.0;
        panelConstraintsCA.gridwidth = 4;
        panelConstraintsCA.insets = new Insets(0, 10, 10, 10);
        panelConstraintsCA.fill = 1;
        panelLayoutCA.setConstraints(this.m_scrpaneList, panelConstraintsCA);
        r_panelCA.add(this.m_scrpaneList);
        this.m_bttnCertInsert = new JButton(JAPMessages.getString("certBttnInsert"));
        this.m_bttnCertInsert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean decode_error = false;
                JAPCertificate cert = null;
                try {
                    cert = JAPUtil.openCertificate(new JFrame());
                }
                catch (Exception je) {
                    decode_error = true;
                }
                if (cert == null && decode_error) {
                    JAPDialog.showMessageDialog(JAPConfCert.this.getRootPanel(), JAPMessages.getString("certInputErrorTitle"));
                }
                if (cert != null) {
                    CertificateInfoStructure j = new CertificateInfoStructure(CertPath.getRootInstance(cert), null, 1, true, false, true, false);
                    JAPConfCert.this.m_listmodelCertList.addElement(j);
                    JAPConfCert.this.m_listCert.setSelectedIndex(JAPConfCert.this.m_listmodelCertList.getSize());
                }
            }
        });
        this.m_bttnCertRemove = new JButton(JAPMessages.getString("certBttnRemove"));
        this.m_bttnCertRemove.setEnabled(false);
        this.m_bttnCertRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JAPConfCert.this.m_listmodelCertList.getSize() > 0) {
                    JAPConfCert.this.m_deletedCerts.addElement(JAPConfCert.this.m_listmodelCertList.getElementAt(JAPConfCert.this.m_listCert.getSelectedIndex()));
                    JAPConfCert.this.m_listmodelCertList.remove(JAPConfCert.this.m_listCert.getSelectedIndex());
                }
                if (JAPConfCert.this.m_listmodelCertList.getSize() == 0) {
                    JAPConfCert.this.m_bttnCertRemove.setEnabled(false);
                    JAPConfCert.this.m_bttnCertStatus.setEnabled(false);
                    JAPConfCert.this.m_bttnCertDetails.setEnabled(false);
                    JAPConfCert.this.m_shortInfoPanel.update((JAPCertificate)null);
                } else {
                    JAPConfCert.this.m_shortInfoPanel.update((JAPCertificate)null);
                    JAPConfCert.this.m_listCert.setSelectedIndex(0);
                    CertificateInfoStructure j = (CertificateInfoStructure)JAPConfCert.this.m_listCert.getSelectedValue();
                    JAPConfCert.this.m_shortInfoPanel.update(j.getCertificate());
                }
            }
        });
        this.m_bttnCertStatus = new JButton(JAPMessages.getString("certBttnEnable"));
        this.m_bttnCertStatus.setEnabled(false);
        this.m_bttnCertStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CertificateInfoStructure certActual = (CertificateInfoStructure)JAPConfCert.this.m_listCert.getSelectedValue();
                if (certActual.isEnabled()) {
                    certActual.setEnabled(false);
                    JAPConfCert.this.m_bttnCertStatus.setText(JAPMessages.getString("certBttnEnable"));
                } else {
                    certActual.setEnabled(true);
                    JAPConfCert.this.m_bttnCertStatus.setText(JAPMessages.getString("certBttnDisable"));
                }
                JAPConfCert.this.m_listCert.repaint();
            }
        });
        this.m_bttnCertDetails = new JButton(JAPMessages.getString(MSG_DETAILS));
        this.m_bttnCertDetails.setEnabled(false);
        this.m_bttnCertDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CertificateInfoStructure info = (CertificateInfoStructure)JAPConfCert.this.m_listCert.getSelectedValue();
                if (info == null) {
                    return;
                }
                CertDetailsDialog dialog = new CertDetailsDialog(JAPConfCert.this.getRootPanel().getParent(), info.getCertificate().getX509Certificate(), true, JAPMessages.getLocale());
                dialog.pack();
                dialog.setVisible(true);
            }
        });
        panelConstraintsCA.gridx = 0;
        panelConstraintsCA.gridy = 1;
        panelConstraintsCA.weightx = 0.0;
        panelConstraintsCA.gridwidth = 1;
        panelConstraintsCA.weighty = 0.0;
        panelConstraintsCA.fill = 0;
        panelConstraintsCA.insets = new Insets(0, 10, 0, 0);
        panelLayoutCA.setConstraints(this.m_bttnCertInsert, panelConstraintsCA);
        r_panelCA.add(this.m_bttnCertInsert);
        panelConstraintsCA.gridx = 1;
        panelConstraintsCA.gridy = 1;
        panelLayoutCA.setConstraints(this.m_bttnCertRemove, panelConstraintsCA);
        r_panelCA.add(this.m_bttnCertRemove);
        panelConstraintsCA.gridx = 2;
        panelConstraintsCA.gridy = 1;
        panelLayoutCA.setConstraints(this.m_bttnCertStatus, panelConstraintsCA);
        r_panelCA.add(this.m_bttnCertStatus);
        panelConstraintsCA.gridx = 3;
        panelConstraintsCA.gridy = 1;
        panelLayoutCA.setConstraints(this.m_bttnCertDetails, panelConstraintsCA);
        r_panelCA.add(this.m_bttnCertDetails);
        return r_panelCA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable a_notifier, Object a_message) {
        if (this.m_bDoNotUpdate) {
            return;
        }
        if (a_notifier == SignatureVerifier.getInstance().getVerificationCertificateStore() && (a_message == null || a_message instanceof Integer && (Integer)a_message == 1)) {
            Enumeration enumCerts = SignatureVerifier.getInstance().getVerificationCertificateStore().getAllCertificates().elements();
            JAPConfCert jAPConfCert = this;
            synchronized (jAPConfCert) {
                int lastIndex = this.m_listCert.getSelectedIndex();
                this.m_listmodelCertList.clear();
                this.m_enumCerts = enumCerts;
                while (this.m_enumCerts.hasMoreElements()) {
                    CertificateInfoStructure j = (CertificateInfoStructure)this.m_enumCerts.nextElement();
                    if (j.getCertificateType() != 1) continue;
                    this.m_listmodelCertList.addElement(j);
                }
                if (this.m_listmodelCertList.getSize() > 0 && lastIndex >= 0 && lastIndex < this.m_listmodelCertList.getSize()) {
                    this.m_listCert.setSelectedIndex(lastIndex);
                }
            }
        }
    }

    protected void onUpdateValues() {
        if (this.m_cbCertCheckEnabled.isSelected() != SignatureVerifier.getInstance().isCheckSignatures()) {
            this.m_cbCertCheckEnabled.setSelected(SignatureVerifier.getInstance().isCheckSignatures());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onOkPressed() {
        if (this.m_bDoNotUpdate) {
            return true;
        }
        JAPConfCert jAPConfCert = this;
        synchronized (jAPConfCert) {
            CertificateInfoStructure currentCertificate;
            this.m_bDoNotUpdate = true;
            SignatureVerifier.getInstance().setCheckSignatures(this.m_cbCertCheckEnabled.isSelected());
            Enumeration certificates = this.m_deletedCerts.elements();
            while (certificates.hasMoreElements()) {
                currentCertificate = (CertificateInfoStructure)certificates.nextElement();
                SignatureVerifier.getInstance().getVerificationCertificateStore().removeCertificate(currentCertificate);
            }
            this.m_deletedCerts.removeAllElements();
            certificates = this.m_listmodelCertList.elements();
            while (certificates.hasMoreElements()) {
                currentCertificate = (CertificateInfoStructure)certificates.nextElement();
                CertificateInfoStructure storedCertificate = SignatureVerifier.getInstance().getVerificationCertificateStore().getCertificateInfoStructure(currentCertificate.getCertificate(), 1);
                if (storedCertificate != null) {
                    if (storedCertificate.isEnabled() == currentCertificate.isEnabled()) continue;
                    SignatureVerifier.getInstance().getVerificationCertificateStore().setEnabled(currentCertificate, currentCertificate.isEnabled());
                    continue;
                }
                SignatureVerifier.getInstance().getVerificationCertificateStore().addCertificateWithoutVerification(currentCertificate.getCertificate(), 1, true, false);
                SignatureVerifier.getInstance().getVerificationCertificateStore().setEnabled(currentCertificate, currentCertificate.isEnabled());
            }
            this.m_savePoint.createSavePoint();
            this.m_bDoNotUpdate = false;
        }
        this.update(SignatureVerifier.getInstance().getVerificationCertificateStore(), null);
        return true;
    }

    protected void onCancelPressed() {
        this.m_cbCertCheckEnabled.setSelected(SignatureVerifier.getInstance().isCheckSignatures());
        this.update(SignatureVerifier.getInstance().getVerificationCertificateStore(), null);
        this.m_deletedCerts.removeAllElements();
    }

    protected void onResetToDefaultsPressed() {
        super.onResetToDefaultsPressed();
        this.m_cbCertCheckEnabled.setSelected(true);
    }

    public String getHelpContext() {
        return "cert";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

