/*
 * Decompiled with CFR 0.152.
 */
package gui;

import anon.terms.TermsAndConditions;
import anon.util.JAPMessages;
import gui.JapHtmlPane;
import gui.UpperLeftStartViewport;
import gui.dialog.JAPDialog;
import gui.dialog.TermsAndConditionsPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class TermsAndConditionsDialog
extends JAPDialog {
    TermsAndConditionsPane m_panel;
    TermsAndConditonsDialogReturnValues m_ret = new TermsAndConditonsDialogReturnValues();
    boolean acceptInitialValue = false;
    public static final String HTML_EXPORT_ENCODING = "ISO-8859-1";
    public static final String MSG_DIALOG_TITLE = (class$gui$TermsAndConditionsDialog == null ? (class$gui$TermsAndConditionsDialog = TermsAndConditionsDialog.class$("gui.TermsAndConditionsDialog")) : class$gui$TermsAndConditionsDialog).getName() + "_dialogTitle";
    static /* synthetic */ Class class$gui$TermsAndConditionsDialog;

    public TermsAndConditionsDialog(Component a_parent, boolean accepted, TermsAndConditions tc) {
        this(a_parent, accepted, tc, JAPMessages.getLocale().getLanguage());
    }

    public TermsAndConditionsDialog(Component a_parent, boolean accepted, TermsAndConditions tc, String langCode) {
        super(a_parent, JAPMessages.getString(MSG_DIALOG_TITLE, tc.getOperator().getOrganization()));
        this.setResizable(false);
        this.m_panel = new TermsAndConditionsPane((JAPDialog)this, accepted, new TermsAndConditionsPane.TermsAndConditionsMessages());
        this.m_panel.setText(tc.getHTMLText(langCode));
        this.m_panel.updateDialog();
        this.pack();
    }

    public static void previewTranslation(Component parent, TermsAndConditions.Translation tcTranslation) {
        final String htmlText = TermsAndConditions.getHTMLText(tcTranslation);
        JapHtmlPane htmlPane = new JapHtmlPane(htmlText, new UpperLeftStartViewport());
        htmlPane.setPreferredSize(new Dimension(800, 600));
        final JAPDialog displayDialog = new JAPDialog(parent, "Translation preview [" + tcTranslation + "]");
        Container contentPane = displayDialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        final JButton exportButton = new JButton(JAPMessages.getString("bttnSaveAs"));
        final JButton closeButton = new JButton(JAPMessages.getString("bttnClose"));
        String organizationName = tcTranslation.getOperator() != null ? (tcTranslation.getOperator().getOrganization() != null ? tcTranslation.getOperator().getOrganization() : "???") : "???";
        final String suggestedFileName = "Terms_" + organizationName + "_" + tcTranslation.getLocale() + ".html";
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == exportButton) {
                    TermsAndConditionsDialog.actionExportHTMLToFile(displayDialog.getContentPane(), htmlText, suggestedFileName);
                } else if (e.getSource() == closeButton) {
                    displayDialog.dispose();
                }
            }
        };
        exportButton.addActionListener(actionListener);
        closeButton.addActionListener(actionListener);
        buttonPanel.add(exportButton);
        buttonPanel.add(closeButton);
        contentPane.add((Component)buttonPanel, "North");
        contentPane.add((Component)htmlPane, "South");
        contentPane.add(htmlPane);
        displayDialog.setDefaultCloseOperation(2);
        displayDialog.pack();
        displayDialog.setVisible(true);
    }

    public TermsAndConditonsDialogReturnValues getReturnValues() {
        this.m_ret.setCancelled(this.m_panel.getButtonValue() != 0);
        this.m_ret.setAccepted(this.m_panel.isTermsAccepted());
        return this.m_ret;
    }

    private static void actionExportHTMLToFile(Component parent, String htmlOutput, String suggestedFileName) {
        JFileChooser fc = new JFileChooser();
        File suggestedFile = new File(fc.getCurrentDirectory() + File.separator + suggestedFileName);
        fc.setSelectedFile(suggestedFile);
        int clicked = fc.showSaveDialog(parent);
        switch (clicked) {
            case 0: {
                File selectedFile = fc.getSelectedFile();
                boolean confirmed = true;
                if (selectedFile.exists()) {
                    boolean bl = confirmed = JAPDialog.showConfirmDialog(parent, "File already " + selectedFile.getName() + " already exists. Do you want to replace it?", 0, 3) == 0;
                }
                if (!confirmed) break;
                try {
                    OutputStreamWriter exportWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(selectedFile), HTML_EXPORT_ENCODING);
                    exportWriter.write(htmlOutput);
                    exportWriter.flush();
                    exportWriter.close();
                }
                catch (IOException e) {
                    JAPDialog.showErrorDialog(parent, "Could not export to " + selectedFile.getName(), (Throwable)e);
                }
                break;
            }
            case 1: {
                break;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class TermsAndConditonsDialogReturnValues {
        private boolean cancelled = false;
        private boolean accepted = false;

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }

        public boolean isAccepted() {
            return this.accepted;
        }

        public void setAccepted(boolean accepted) {
            this.accepted = accepted;
        }
    }
}

