/*
 * Decompiled with CFR 0.152.
 */
package anon.terms.template;

import anon.crypto.MultiCertPath;
import anon.crypto.SignatureVerifier;
import anon.crypto.XMLSignature;
import anon.infoservice.AbstractDistributableCertifiedDatabaseEntry;
import anon.infoservice.Database;
import anon.infoservice.InfoServiceHolder;
import anon.infoservice.OperatorAddress;
import anon.infoservice.ServiceOperator;
import anon.terms.TCComponent;
import anon.terms.TCComposite;
import anon.terms.TermsAndConditions;
import anon.terms.template.Preamble;
import anon.terms.template.Section;
import anon.util.Util;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TermsAndConditionsTemplate
extends AbstractDistributableCertifiedDatabaseEntry {
    private static final String XML_ATTR_DATE = "date";
    private static final String XML_ATTR_LOCALE = "locale";
    private static final String XML_ATTR_NAME = "name";
    private static final String XML_ATTR_TYPE = "type";
    private static final String[] REQUIRED_ATTRIBUTES = new String[]{"type", "locale", "date", "id", "name"};
    private static final String XML_ELEMENT_OPERATOR_COUNTRY = "OperatorCountry";
    private static final String XML_ELEMENT_SIGNATURE = "Sig";
    private static final String XML_ELEMENT_DATE = "Date";
    public static final String INFOSERVICE_PATH = "/tctemplate/";
    public static final String INFOSERVICE_CONTAINER_PATH = "/tctemplates";
    public static final String INFOSERVICE_SERIALS_PATH = "/tctemplateserials";
    public static final String[] REPLACEMENT_ELEMENT_NAMES = new String[]{"PrivacyPolicyUrl", "LegalOpinionsUrl", "OperationalAgreementUrl"};
    private static final String XSLT_PATH = "tac.xslt";
    public static String TERMS_AND_CONDITIONS_TYPE_COMMON_LAW = "CommonLaw";
    public static String TERMS_AND_CONDITIONS_TYPE_GERMAN_LAW = "GermanLaw";
    public static String TERMS_AND_CONDITIONS_TYPE_GENERAL_LAW = "GeneralLaw";
    public static String XML_ELEMENT_CONTAINER_NAME = "TermsAndConditionsTemplates";
    public static String XML_ELEMENT_NAME = "TermsAndConditionsTemplate";
    private String m_strId = null;
    private String m_locale = null;
    private String m_type = null;
    private String m_date;
    private Document signedDocument = null;
    private XMLSignature m_signature = null;
    private MultiCertPath m_certPath = null;
    private String name = "";
    private Preamble preamble = null;
    private TCComposite sections = new TCComposite();
    static /* synthetic */ Class class$anon$terms$template$TermsAndConditionsTemplate;

    public TermsAndConditionsTemplate(Element element, long aLong) throws XMLParseException {
        this(element);
    }

    public TermsAndConditionsTemplate(Node rootNode) throws XMLParseException {
        super(Long.MAX_VALUE);
        Element templateRoot = null;
        if (rootNode.getNodeType() == 9) {
            templateRoot = ((Document)rootNode).getDocumentElement();
        } else if (rootNode.getNodeType() == 1) {
            templateRoot = (Element)rootNode;
        } else {
            throw new XMLParseException("Invalid node type");
        }
        this.name = XMLUtil.parseAttribute((Node)templateRoot, XML_ATTR_NAME, "");
        this.m_date = XMLUtil.parseAttribute((Node)templateRoot, XML_ATTR_DATE, "");
        this.m_locale = XMLUtil.parseAttribute((Node)templateRoot, XML_ATTR_LOCALE, "");
        this.m_type = XMLUtil.parseAttribute((Node)templateRoot, XML_ATTR_TYPE, TERMS_AND_CONDITIONS_TYPE_COMMON_LAW);
        this.m_strId = this.m_type + "_" + this.m_locale + "_" + this.m_date;
        this.m_signature = SignatureVerifier.getInstance().getVerifiedXml(templateRoot, 5);
        if (this.m_signature != null) {
            this.m_certPath = this.m_signature.getMultiCertPath();
            if (rootNode.getNodeType() == 9) {
                this.signedDocument = (Document)rootNode;
            } else {
                this.signedDocument = XMLUtil.createDocument();
                this.signedDocument.appendChild(XMLUtil.importNode(this.signedDocument, templateRoot, true));
            }
        }
        NodeList nl = templateRoot.getElementsByTagName(Section.XML_ELEMENT_NAME);
        for (int i = 0; i < nl.getLength(); ++i) {
            this.sections.addTCComponent(new Section(nl.item(i)));
        }
        Node preambleNode = XMLUtil.getFirstChildByName(templateRoot, Preamble.XML_ELEMENT_NAME);
        this.preamble = preambleNode != null ? new Preamble(preambleNode) : new Preamble();
    }

    public TermsAndConditionsTemplate(File a_file) throws XMLParseException, IOException {
        this(XMLUtil.readXMLDocument(a_file));
    }

    public Document createTCDocument(TermsAndConditions.Translation tcTranslation) {
        Document tcDocument = XMLUtil.createDocument();
        Element tcRootElement = tcDocument.createElement(XML_ELEMENT_NAME);
        Element cityElement = tcDocument.createElement("City");
        Element venueElement = tcDocument.createElement("Venue");
        Element dateElement = tcDocument.createElement(XML_ELEMENT_DATE);
        ServiceOperator operator = null;
        OperatorAddress address = null;
        Element signatureElement = tcDocument.createElement(XML_ELEMENT_SIGNATURE);
        signatureElement.appendChild(cityElement);
        signatureElement.appendChild(dateElement);
        TCComposite copiedSections = this.getSections();
        TCComponent[] allSections = null;
        String[] requiredAttributeValues = new String[]{this.m_type, this.m_locale, this.m_date, this.m_strId, this.name};
        for (int i = 0; i < REQUIRED_ATTRIBUTES.length; ++i) {
            tcRootElement.setAttribute(REQUIRED_ATTRIBUTES[i], requiredAttributeValues[i]);
        }
        tcDocument.appendChild(tcRootElement);
        if (tcTranslation != null) {
            operator = tcTranslation.getOperator();
            address = tcTranslation.getOperatorAddress();
            Locale operatorLocale = new Locale(tcTranslation.getLocale(), operator.getCountryCode());
            Locale tcLocale = new Locale(tcTranslation.getLocale(), "", "");
            if (address != null) {
                address.setOperatorCountry(operatorLocale.getDisplayCountry(tcLocale));
            }
            Element operatorElement = operator.toXMLElement(tcDocument, address, false);
            Element operatorCountryElement = tcDocument.createElement(XML_ELEMENT_OPERATOR_COUNTRY);
            XMLUtil.setValue((Node)cityElement, address != null ? tcTranslation.getOperatorAddress().getCity() : "");
            XMLUtil.setValue((Node)venueElement, address != null ? tcTranslation.getOperatorAddress().getVenue() : "");
            XMLUtil.setValue((Node)dateElement, DateFormat.getDateInstance(2, tcLocale).format(tcTranslation.getDate()));
            operatorElement.appendChild(operatorCountryElement);
            XMLUtil.setValue((Node)operatorCountryElement, operatorLocale.getDisplayCountry(tcLocale));
            TCComponent[] translationSections = tcTranslation.getSections().getTCComponents();
            Section currentTranslationSection = null;
            Section currentSection = null;
            TCComponent[] currentParagraphs = null;
            for (int i = 0; i < translationSections.length; ++i) {
                currentTranslationSection = (Section)translationSections[i];
                currentSection = (Section)copiedSections.getTCComponent(currentTranslationSection.getId());
                if (!currentTranslationSection.hasContent() || currentSection == null) {
                    copiedSections.addTCComponent(translationSections[i]);
                    continue;
                }
                if (currentTranslationSection.getContent() != null) {
                    currentSection.setContent(currentTranslationSection.getContent());
                }
                currentParagraphs = currentTranslationSection.getTCComponents();
                for (int j = 0; j < currentParagraphs.length; ++j) {
                    currentSection.addTCComponent(currentParagraphs[j]);
                }
            }
            String[] replaceValues = new String[]{tcTranslation.getPrivacyPolicyUrl(), tcTranslation.getLegalOpinionsUrl(), tcTranslation.getOperationalAgreementUrl()};
            final Vector<Element> replaceNodes = new Vector<Element>();
            Element currentReplaceElement = null;
            for (int i = 0; i < replaceValues.length; ++i) {
                currentReplaceElement = tcDocument.createElement(REPLACEMENT_ELEMENT_NAMES[i]);
                currentReplaceElement.appendChild(tcDocument.createTextNode(replaceValues[i]));
                replaceNodes.addElement(currentReplaceElement);
            }
            replaceNodes.addElement(operatorElement);
            replaceNodes.addElement(operatorCountryElement);
            replaceNodes.addElement(venueElement);
            NodeList replaceNodeList = new NodeList(){

                public int getLength() {
                    return replaceNodes.size();
                }

                public Node item(int index) {
                    return (Node)replaceNodes.elementAt(index);
                }
            };
            allSections = copiedSections.getTCComponents();
            for (int i = 0; i < allSections.length; ++i) {
                ((Section)allSections[i]).replaceElementNodes(replaceNodeList);
            }
        }
        this.preamble.setOperator(operator);
        this.preamble.setOperatorAddress(address);
        tcRootElement.appendChild(this.preamble.toXmlElement(tcDocument));
        Element sectionsElement = tcDocument.createElement(Section.XML_ELEMENT_CONTAINER_NAME);
        allSections = copiedSections.getTCComponents();
        Element sectionElement = null;
        for (int i = 0; i < allSections.length; ++i) {
            sectionElement = ((Section)allSections[i]).toXmlElement(tcDocument);
            if (sectionElement == null) continue;
            sectionsElement.appendChild(sectionElement);
        }
        tcRootElement.appendChild(sectionsElement);
        tcRootElement.appendChild(signatureElement);
        return tcDocument;
    }

    public String transform(TermsAndConditions.Translation translation) {
        try {
            StringWriter writer = new StringWriter();
            this.transform(writer, translation);
            writer.close();
            String s = writer.toString();
            return Util.replaceAll(s, "<br/>", "<br>");
        }
        catch (IOException e) {
            LogHolder.log(3, LogType.MISC, "IOException caught while transforming terms and conditions.");
            return null;
        }
        catch (TransformerException e) {
            LogHolder.log(3, LogType.MISC, "Could not transform terms and conditions.");
            e.printStackTrace();
            return null;
        }
    }

    public void transform(Writer writer, TermsAndConditions.Translation translation) throws IOException, TransformerException {
        DOMSource xmlSource = new DOMSource(this.createTCDocument(translation));
        StreamSource xsltSource = new StreamSource(this.getClass().getResourceAsStream(XSLT_PATH));
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(xsltSource);
        transformer.transform(xmlSource, new StreamResult(writer));
    }

    public String getType() {
        return this.m_type;
    }

    public String getId() {
        return this.m_strId;
    }

    public long getLastUpdate() {
        return 0L;
    }

    public long getVersionNumber() {
        return 0L;
    }

    public String getLanguage() {
        return this.m_locale;
    }

    public String getDate() {
        return this.m_date;
    }

    public String getPostFile() {
        return "/posttcframework";
    }

    public boolean isVerified() {
        if (this.m_signature != null) {
            return this.m_signature.isVerified();
        }
        return false;
    }

    public boolean isValid() {
        if (this.m_certPath != null) {
            return this.m_certPath.isValid(new Date());
        }
        return false;
    }

    public TCComposite getSections() {
        return (TCComposite)this.sections.clone();
    }

    public static synchronized void store(Element root) {
        Element current = (Element)XMLUtil.getFirstChildByName(root, XML_ELEMENT_NAME);
        while (current != null) {
            try {
                Database.getInstance(class$anon$terms$template$TermsAndConditionsTemplate == null ? TermsAndConditionsTemplate.class$("anon.terms.template.TermsAndConditionsTemplate") : class$anon$terms$template$TermsAndConditionsTemplate).update(new TermsAndConditionsTemplate(current));
                current = (Element)XMLUtil.getNextSiblingByName(current, XML_ELEMENT_NAME);
            }
            catch (XMLParseException xpe) {
                LogHolder.log(3, LogType.MISC, "one tc templates could not be stored in the DB");
            }
        }
    }

    public static synchronized Enumeration getAllStoredRefIDs() {
        final Enumeration e = Database.getInstance(class$anon$terms$template$TermsAndConditionsTemplate == null ? (class$anon$terms$template$TermsAndConditionsTemplate = TermsAndConditionsTemplate.class$("anon.terms.template.TermsAndConditionsTemplate")) : class$anon$terms$template$TermsAndConditionsTemplate).getEntryList().elements();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return e.hasMoreElements();
            }

            public Object nextElement() {
                return ((TermsAndConditionsTemplate)e.nextElement()).getId();
            }
        };
    }

    public static void loadFromDirectory(File a_dir) {
        File file = null;
        if (a_dir == null) {
            return;
        }
        String[] files = a_dir.list();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            try {
                file = new File(a_dir.getAbsolutePath() + File.separator + files[i]);
                TermsAndConditionsTemplate tac = new TermsAndConditionsTemplate(file);
                Database.getInstance(class$anon$terms$template$TermsAndConditionsTemplate == null ? TermsAndConditionsTemplate.class$("anon.terms.template.TermsAndConditionsTemplate") : class$anon$terms$template$TermsAndConditionsTemplate).update(tac);
                continue;
            }
            catch (XMLParseException ex) {
                LogHolder.log(2, LogType.MISC, "XMLParseException while loading Terms & Conditions: ", ex);
                continue;
            }
            catch (IOException ex) {
                LogHolder.log(2, LogType.MISC, "IOException while loading Terms & Conditions: ", ex);
            }
        }
    }

    public static TermsAndConditionsTemplate getById(String a_id, boolean a_bUpdateFromInfoService) {
        TermsAndConditionsTemplate tc = (TermsAndConditionsTemplate)Database.getInstance(class$anon$terms$template$TermsAndConditionsTemplate == null ? (class$anon$terms$template$TermsAndConditionsTemplate = TermsAndConditionsTemplate.class$("anon.terms.template.TermsAndConditionsTemplate")) : class$anon$terms$template$TermsAndConditionsTemplate).getEntryById(a_id);
        if (!a_bUpdateFromInfoService || tc != null) {
            return tc;
        }
        tc = InfoServiceHolder.getInstance().getTCTemplate(a_id);
        Database.getInstance(class$anon$terms$template$TermsAndConditionsTemplate == null ? (class$anon$terms$template$TermsAndConditionsTemplate = TermsAndConditionsTemplate.class$("anon.terms.template.TermsAndConditionsTemplate")) : class$anon$terms$template$TermsAndConditionsTemplate).update(tc);
        return tc;
    }

    public boolean equals(Object a_object) {
        boolean objectEquals = false;
        if (a_object != null && a_object instanceof TermsAndConditionsTemplate) {
            objectEquals = this.getId().equals(((TermsAndConditionsTemplate)a_object).getId());
        }
        return objectEquals;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public XMLSignature getSignature() {
        return this.m_signature;
    }

    public MultiCertPath getCertPath() {
        return this.m_certPath;
    }

    public Document getDocument() {
        return this.signedDocument != null ? this.signedDocument : this.createTCDocument(null);
    }

    public Document getSignedDocument() {
        return this.signedDocument;
    }

    public void setSignedDocument(Document signedDocument) {
        this.signedDocument = signedDocument;
    }

    public Element getXmlStructure() {
        return this.getDocument().getDocumentElement();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

