/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.pay.xml.XMLBalance;
import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.util.Calendar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLVolumePlan
implements IXMLEncodable {
    public static final String XML_ELEMENT_NAME = "VolumePlan";
    private Document m_docTheVolumePlan;
    private String m_name;
    private String m_displayName;
    private int m_price;
    private double m_priceBC;
    private boolean m_volumeLimited;
    private boolean m_durationLimited;
    private long m_volumeKbytes;
    private int m_duration;
    private String m_durationUnit;
    private boolean m_bIsMonthlyVolume = false;
    private String m_strSinceAnonlibVersion;
    private boolean m_bIsFree = false;
    private boolean m_bIsActive = false;
    private long m_lExtraVolume;

    public XMLVolumePlan() {
    }

    public XMLVolumePlan(String xml) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        Document doc = XMLUtil.readXMLDocument(in);
        this.setValues(doc.getDocumentElement());
        this.m_docTheVolumePlan = doc;
    }

    public XMLVolumePlan(Element elemVolumePlan) throws Exception {
        this.setValues(elemVolumePlan);
        this.m_docTheVolumePlan = XMLUtil.createDocument();
        this.m_docTheVolumePlan.appendChild(XMLUtil.importNode(this.m_docTheVolumePlan, elemVolumePlan, true));
    }

    public XMLVolumePlan(Document doc) throws Exception {
        this.setValues(doc.getDocumentElement());
        this.m_docTheVolumePlan = doc;
    }

    public XMLVolumePlan(String a_name, String a_displayName, int a_price, int a_duration, String a_durationUnit, long a_volumeLimit, long a_extraVolume, boolean a_bMonthlyVolume, String a_sinceVersion, boolean a_bIsFree, boolean a_bIsActive, double a_priceBitcoin) {
        this.m_priceBC = a_priceBitcoin;
        this.m_strSinceAnonlibVersion = a_sinceVersion;
        this.m_name = a_name;
        this.m_bIsFree = a_bIsFree;
        this.m_bIsActive = a_bIsActive;
        this.m_displayName = a_displayName;
        this.m_price = a_price;
        this.m_durationLimited = true;
        this.m_duration = a_duration;
        this.m_durationUnit = a_durationUnit;
        this.m_volumeKbytes = a_volumeLimit;
        this.m_lExtraVolume = a_extraVolume;
        this.m_volumeLimited = true;
        this.m_bIsMonthlyVolume = a_bMonthlyVolume;
        this.m_docTheVolumePlan = XMLUtil.createDocument();
        this.m_docTheVolumePlan.appendChild(this.internal_toXmlElement(this.m_docTheVolumePlan));
    }

    public XMLVolumePlan(String a_name, String a_displayName, int a_price, boolean a_durationLimited, boolean a_volumeLimited, int a_duration, String a_durationUnit, long a_volumeLimit, String a_sinceVersion) {
        this.m_strSinceAnonlibVersion = a_sinceVersion;
        this.m_name = a_name;
        this.m_displayName = a_displayName;
        this.m_price = a_price;
        this.m_durationLimited = a_durationLimited;
        this.m_duration = a_duration;
        this.m_durationUnit = a_durationUnit;
        this.m_volumeKbytes = a_volumeLimit;
        this.m_volumeLimited = a_volumeLimited;
        this.m_docTheVolumePlan = XMLUtil.createDocument();
        this.m_docTheVolumePlan.appendChild(this.internal_toXmlElement(this.m_docTheVolumePlan));
    }

    public String getFirstSupportedAnonlibVersion() {
        return this.m_strSinceAnonlibVersion;
    }

    public boolean isActive() {
        return this.m_bIsActive;
    }

    public boolean isFree() {
        return this.m_bIsFree;
    }

    public boolean isMonthlyVolume() {
        return this.m_bIsMonthlyVolume;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDisplayName() {
        if (this.m_displayName != null && !this.m_displayName.equals("")) {
            return this.m_displayName;
        }
        return this.m_name;
    }

    public int getPrice() {
        return this.m_price;
    }

    public boolean isVolumeLimited() {
        return this.m_volumeLimited;
    }

    public boolean isDurationLimited() {
        return this.m_durationLimited;
    }

    public int getDuration() {
        return this.m_duration;
    }

    public String getDurationUnit() {
        return this.m_durationUnit;
    }

    public Calendar calculateEndDate(Calendar a_calendarNow) {
        int calendarUnit = this.getDurationUnit().equals("days") || this.getDurationUnit().equals("day") ? 5 : (this.getDurationUnit().equalsIgnoreCase("weeks") || this.getDurationUnit().equalsIgnoreCase("week") ? 3 : (this.getDurationUnit().equalsIgnoreCase("years") || this.getDurationUnit().equalsIgnoreCase("year") ? 1 : 2));
        return XMLBalance.calculateEndDate(a_calendarNow, this.getDuration(), calendarUnit);
    }

    public int getDurationInDays() {
        return 0;
    }

    public long getVolumeKbytes() {
        return this.m_volumeKbytes;
    }

    public long getExtraVolumeKbytes() {
        return this.m_lExtraVolume;
    }

    public Element toXmlElement(Document a_doc) {
        try {
            return (Element)XMLUtil.importNode(a_doc, this.m_docTheVolumePlan.getDocumentElement(), true);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void setValues(Element elemRoot) throws Exception {
        if (!elemRoot.getTagName().equals(XML_ELEMENT_NAME)) {
            throw new Exception("XMLVolumePlan: wrong XML structure");
        }
        this.m_strSinceAnonlibVersion = XMLUtil.parseAttribute((Node)elemRoot, "sinceVersion", null);
        Element elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "Name");
        this.m_name = XMLUtil.parseValue((Node)elem, (String)null);
        elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "DisplayName");
        this.m_displayName = XMLUtil.parseValue((Node)elem, (String)null);
        elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "Price");
        String str = XMLUtil.parseValue((Node)elem, (String)null);
        this.m_price = Integer.parseInt(str);
        this.m_bIsFree = XMLUtil.parseAttribute((Node)elem, "free", false);
        elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "VolumeLimited");
        this.m_volumeLimited = XMLUtil.parseValue((Node)elem, false);
        elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "DurationLimited");
        this.m_durationLimited = XMLUtil.parseValue((Node)elem, false);
        elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "VolumeKbytes");
        this.m_bIsMonthlyVolume = XMLUtil.parseAttribute((Node)elem, "monthly", false);
        str = XMLUtil.parseValue((Node)elem, (String)null);
        this.m_volumeKbytes = Long.parseLong(str);
        elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "ExtraVolumeKbytes");
        str = XMLUtil.parseValue((Node)elem, (String)null);
        this.m_lExtraVolume = Long.parseLong(str);
        elem = (Element)XMLUtil.getFirstChildByName(elemRoot, "Duration");
        str = XMLUtil.parseValue((Node)elem, (String)null);
        this.m_duration = Integer.parseInt(str);
        this.m_durationUnit = XMLUtil.parseAttribute((Node)elem, "unit", "");
    }

    private Element internal_toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement(XML_ELEMENT_NAME);
        if (this.m_strSinceAnonlibVersion != null) {
            XMLUtil.setAttribute(elemRoot, "sinceVersion", this.m_strSinceAnonlibVersion);
        }
        Element elem = a_doc.createElement("Name");
        XMLUtil.setValue((Node)elem, this.m_name);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("DisplayName");
        XMLUtil.setValue((Node)elem, this.m_displayName);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("Price");
        XMLUtil.setValue((Node)elem, this.m_price);
        elemRoot.appendChild(elem);
        XMLUtil.setAttribute(elem, "free", this.m_bIsFree);
        elem = a_doc.createElement("PriceBitcoins");
        XMLUtil.setValue((Node)elem, this.m_priceBC);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("DurationLimited");
        XMLUtil.setValue((Node)elem, this.m_durationLimited);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("VolumeLimited");
        XMLUtil.setValue((Node)elem, this.m_volumeLimited);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("ExtraVolumeKbytes");
        XMLUtil.setValue((Node)elem, this.m_lExtraVolume);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("VolumeKbytes");
        XMLUtil.setValue((Node)elem, this.m_volumeKbytes);
        elemRoot.appendChild(elem);
        XMLUtil.setAttribute(elem, "monthly", this.m_bIsMonthlyVolume);
        elem = a_doc.createElement("Duration");
        XMLUtil.setValue((Node)elem, this.m_duration);
        elem.setAttribute("unit", this.m_durationUnit);
        elemRoot.appendChild(elem);
        return elemRoot;
    }
}

