/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.util.Base64;
import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLChallenge
implements IXMLEncodable {
    public static final String TYPE_PAYMENT_INSTANCE = "PaymentInstance";
    public static final String TYPE_MIX = "Mix";
    private byte[] m_arbChallenge;
    private int m_prepaidBytes;
    public static final String XML_ELEMENT_NAME = "Challenge";
    private String strID;
    private String strType;

    public XMLChallenge(String xml) throws Exception {
        Document doc = XMLUtil.toXMLDocument(xml);
        this.setValues(doc.getDocumentElement());
    }

    public XMLChallenge(Element element) throws Exception {
        this.setValues(element);
    }

    public XMLChallenge(Document doc) throws Exception {
        this.setValues(doc.getDocumentElement());
    }

    public XMLChallenge(byte[] data, String a_strID, String a_strType) {
        this.strID = a_strID;
        this.strType = a_strType;
        this.m_arbChallenge = data;
    }

    private void setValues(Element elemRoot) throws Exception {
        if (!elemRoot.getTagName().equals(XML_ELEMENT_NAME)) {
            throw new Exception("XMLChallenge wrong XML structure");
        }
        this.strID = XMLUtil.parseAttribute((Node)elemRoot, "id", null);
        this.strType = XMLUtil.parseAttribute((Node)elemRoot, "type", null);
        Element element = (Element)XMLUtil.getFirstChildByName(elemRoot, "DontPanic");
        this.m_arbChallenge = Base64.decode(XMLUtil.parseValue((Node)element, ""));
        this.m_prepaidBytes = XMLUtil.parseValue(XMLUtil.getFirstChildByName(elemRoot, "PrepaidBytes"), 0);
    }

    public String getType() {
        return this.strType;
    }

    public String getId() {
        return this.strID;
    }

    public int getPrepaidBytes() {
        return this.m_prepaidBytes;
    }

    public byte[] getChallengeForSigning() {
        byte[] challenge = new byte[this.m_arbChallenge.length];
        System.arraycopy(this.m_arbChallenge, 0, challenge, 0, challenge.length);
        return challenge;
    }

    public byte[] getChallengeForCaptcha() {
        String tmp = "<DontPanic>" + Base64.encodeBytes(this.m_arbChallenge) + "</DontPanic>";
        return tmp.getBytes();
    }

    public Element toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement(XML_ELEMENT_NAME);
        elemRoot.setAttribute("id", this.strID);
        elemRoot.setAttribute("type", this.strType);
        Element elemChallenge = a_doc.createElement("DontPanic");
        elemRoot.appendChild(elemChallenge);
        XMLUtil.setValue((Node)elemChallenge, Base64.encodeBytes(this.m_arbChallenge));
        return elemRoot;
    }
}

