/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.crypto.IVerifyable;
import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.Database;
import anon.infoservice.IBoostrapable;
import anon.infoservice.IDistributable;
import anon.infoservice.IServiceContextContainer;
import anon.util.IXMLEncodable;
import anon.util.Util;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractDistributableDatabaseEntry
extends AbstractDatabaseEntry
implements IDistributable,
IXMLEncodable {
    public static final String XML_ATTR_SERIAL = "serial";
    public static final String XML_ATTR_VERIFIED = "verified";
    public static final String XML_ATTR_VALID = "valid";
    public static final String XML_ATTR_LAST_UPDATE = "lastUpdate";
    static /* synthetic */ Class class$anon$infoservice$AbstractDistributableDatabaseEntry;

    public AbstractDistributableDatabaseEntry(long a_expireTime) {
        super(a_expireTime);
    }

    public static String getHttpRequestString(Class a_xmlEncodableClass) {
        return Util.getStaticFieldValue(a_xmlEncodableClass, "HTTP_REQUEST_STRING");
    }

    public static String getHttpSerialsRequestString(Class a_xmlEncodableClass) {
        return Util.getStaticFieldValue(a_xmlEncodableClass, "HTTP_SERIALS_REQUEST_STRING");
    }

    public abstract Element getXmlStructure();

    public byte[] getPostData() {
        return XMLUtil.toString(this.getXmlStructure()).getBytes();
    }

    public int getPostEncoding() {
        return 0;
    }

    public final Element toXmlElement(Document a_doc) {
        Element returnXmlStructure = null;
        try {
            returnXmlStructure = (Element)XMLUtil.importNode(a_doc, this.getXmlStructure(), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (returnXmlStructure == null && XMLUtil.getStorageMode() == 2) {
            LogHolder.log(4, LogType.MISC, "Got null XML element, maybe due to aggressive storage mode.");
        }
        return returnXmlStructure;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ String getPostFile();

    public abstract /* synthetic */ String getId();

    public static class SerialDBEntry
    extends AbstractDatabaseEntry
    implements IServiceContextContainer {
        private String m_id;
        private long m_version;
        private long m_lastUpdate;
        private boolean m_bVerified;
        private boolean m_bValid;
        private String m_context;

        public SerialDBEntry(String a_id, long a_version, long a_lastUpdate, boolean a_bVerified, boolean a_bValid, String context) {
            super(0L);
            this.m_id = a_id;
            this.m_version = a_version;
            this.m_lastUpdate = a_lastUpdate;
            this.m_bVerified = a_bVerified;
            this.m_bValid = a_bValid;
            this.m_context = context;
        }

        public boolean isVerified() {
            return this.m_bVerified;
        }

        public boolean isValid() {
            return this.m_bValid;
        }

        public long getLastUpdate() {
            return this.m_lastUpdate;
        }

        public String getId() {
            return this.m_id;
        }

        public long getVersionNumber() {
            return this.m_version;
        }

        public String getContext() {
            return this.m_context;
        }

        public void setContext(String context) {
            this.m_context = context;
        }
    }

    public static class Serials
    implements IXMLEncodable {
        private static final String XML_ELEMENT_NAME = "Serials";
        private Class m_thisDBEntryClass;

        public Serials(Class a_thisDBEntryClass) throws IllegalArgumentException {
            if (a_thisDBEntryClass == null || !(class$anon$infoservice$AbstractDistributableDatabaseEntry == null ? (class$anon$infoservice$AbstractDistributableDatabaseEntry = AbstractDistributableDatabaseEntry.class$("anon.infoservice.AbstractDistributableDatabaseEntry")) : class$anon$infoservice$AbstractDistributableDatabaseEntry).isAssignableFrom(a_thisDBEntryClass)) {
                throw new IllegalArgumentException("Illegal class argument!");
            }
            this.m_thisDBEntryClass = a_thisDBEntryClass;
        }

        public Hashtable parse(Element a_elemSerials) throws XMLParseException {
            if (a_elemSerials == null || a_elemSerials.getNodeName() == null || !a_elemSerials.getNodeName().equals(XML_ELEMENT_NAME)) {
                throw new XMLParseException("##__null__##");
            }
            String context = null;
            NodeList serialNodes = a_elemSerials.getElementsByTagName(XMLUtil.getXmlElementName(this.m_thisDBEntryClass));
            Hashtable<String, SerialDBEntry> hashSerials = serialNodes.getLength() > 0 ? new Hashtable(serialNodes.getLength()) : new Hashtable<String, SerialDBEntry>();
            for (int i = 0; i < serialNodes.getLength(); ++i) {
                String id = XMLUtil.parseAttribute(serialNodes.item(i), "id", null);
                if (id == null) continue;
                long serial = XMLUtil.parseAttribute(serialNodes.item(i), AbstractDistributableDatabaseEntry.XML_ATTR_SERIAL, 0L);
                long lastUpdate = XMLUtil.parseAttribute(serialNodes.item(i), AbstractDistributableDatabaseEntry.XML_ATTR_LAST_UPDATE, 0L);
                boolean bVerified = XMLUtil.parseAttribute(serialNodes.item(i), AbstractDistributableDatabaseEntry.XML_ATTR_VERIFIED, false);
                boolean bValid = XMLUtil.parseAttribute(serialNodes.item(i), AbstractDistributableDatabaseEntry.XML_ATTR_VALID, false);
                context = XMLUtil.parseAttribute(serialNodes.item(i), "context", "jondonym");
                if (context.equals("de.jondos.jondonym")) {
                    context = "jondonym";
                }
                hashSerials.put(id, new SerialDBEntry(id, serial, lastUpdate, bVerified, bValid, context));
            }
            return hashSerials;
        }

        public Element toXmlElement(Document a_doc) {
            if (a_doc == null) {
                return null;
            }
            Element nodeSerials = a_doc.createElement(XML_ELEMENT_NAME);
            Enumeration knownEntries = Database.getInstance(this.m_thisDBEntryClass).getEntrySnapshotAsEnumeration();
            while (knownEntries.hasMoreElements()) {
                String context;
                AbstractDistributableDatabaseEntry currentEntry = (AbstractDistributableDatabaseEntry)knownEntries.nextElement();
                if (currentEntry instanceof IBoostrapable && ((IBoostrapable)((Object)currentEntry)).isBootstrap()) continue;
                if (currentEntry.getVersionNumber() <= 0L) {
                    // empty if block
                }
                Element nodeASerial = a_doc.createElement(XMLUtil.getXmlElementName(this.m_thisDBEntryClass));
                nodeSerials.appendChild(nodeASerial);
                XMLUtil.setAttribute(nodeASerial, "id", ((AbstractDatabaseEntry)currentEntry).getId());
                XMLUtil.setAttribute(nodeASerial, AbstractDistributableDatabaseEntry.XML_ATTR_LAST_UPDATE, currentEntry.getLastUpdate());
                XMLUtil.setAttribute(nodeASerial, AbstractDistributableDatabaseEntry.XML_ATTR_SERIAL, currentEntry.getVersionNumber());
                if (currentEntry instanceof IVerifyable) {
                    XMLUtil.setAttribute(nodeASerial, AbstractDistributableDatabaseEntry.XML_ATTR_VALID, ((IVerifyable)((Object)currentEntry)).isValid());
                    XMLUtil.setAttribute(nodeASerial, AbstractDistributableDatabaseEntry.XML_ATTR_VERIFIED, ((IVerifyable)((Object)currentEntry)).isVerified() && ((IVerifyable)((Object)currentEntry)).getCertPath().isVerified());
                }
                if (!(currentEntry instanceof IServiceContextContainer) || (context = ((IServiceContextContainer)((Object)currentEntry)).getContext()) == null) continue;
                XMLUtil.setAttribute(nodeASerial, "context", context);
            }
            return nodeSerials;
        }
    }
}

