/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto.tinytls.util;

import anon.util.ByteArrayUtil;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class P_Hash {
    private byte[] m_secret;
    private byte[] m_seed;
    private Digest m_digest;

    public P_Hash(byte[] secret, byte[] seed, Digest digest) {
        this.m_secret = secret;
        this.m_seed = seed;
        this.m_digest = digest;
    }

    public byte[] getHash(int length) {
        byte[] b = null;
        boolean counter = false;
        HMac hm = new HMac(this.m_digest);
        hm.reset();
        hm.init(new KeyParameter(this.m_secret));
        hm.update(this.m_seed, 0, this.m_seed.length);
        byte[] a = new byte[hm.getMacSize()];
        hm.doFinal(a, 0);
        do {
            hm.reset();
            hm.init(new KeyParameter(this.m_secret));
            hm.update(ByteArrayUtil.conc(a, this.m_seed), 0, a.length + this.m_seed.length);
            byte[] c = new byte[hm.getMacSize()];
            hm.doFinal(c, 0);
            b = b == null ? c : ByteArrayUtil.conc(b, c);
            hm.reset();
            hm.init(new KeyParameter(this.m_secret));
            hm.update(a, 0, a.length);
            a = new byte[hm.getMacSize()];
            hm.doFinal(a, 0);
        } while (b.length < length);
        return ByteArrayUtil.copy(b, 0, length);
    }
}

