/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.AnonChannel;
import anon.TooMuchDataForPacketException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TypeFilterDataChain
implements AnonChannel {
    private AnonChannel m_originChannel;
    private Object m_internalSynchronization;
    private boolean m_firstPacket;
    private OutputStream m_typeFilterOutputStream;

    public TypeFilterDataChain(AnonChannel a_originChannel, int a_dataChainType) {
        this.m_originChannel = a_originChannel;
        this.m_firstPacket = true;
        this.m_internalSynchronization = new Object();
        this.m_typeFilterOutputStream = new TypeFilterOutputStreamImplementation(a_originChannel.getOutputStream(), a_dataChainType);
    }

    public InputStream getInputStream() {
        return this.m_originChannel.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.m_typeFilterOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutputBlockSize() {
        int outputBlockSize = this.m_originChannel.getOutputBlockSize();
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            if (this.m_firstPacket && outputBlockSize > 0) {
                --outputBlockSize;
            }
        }
        return outputBlockSize;
    }

    public void close() {
        this.m_originChannel.close();
    }

    public boolean isClosed() {
        return this.m_originChannel.isClosed();
    }

    private class TypeFilterOutputStreamImplementation
    extends OutputStream {
        private int m_dataChainType;
        private OutputStream m_originOutputStream;

        public TypeFilterOutputStreamImplementation(OutputStream a_originOutputStream, int a_dataChainType) {
            this.m_originOutputStream = a_originOutputStream;
            this.m_dataChainType = a_dataChainType;
        }

        public void write(int a_byte) throws IOException {
            byte[] byteAsArray = new byte[]{(byte)a_byte};
            this.write(byteAsArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] a_buffer, int a_offset, int a_length) throws IOException {
            Object object = TypeFilterDataChain.this.m_internalSynchronization;
            synchronized (object) {
                byte[] typedPacket = a_buffer;
                if (TypeFilterDataChain.this.m_firstPacket) {
                    typedPacket = new byte[a_length + 1];
                    typedPacket[0] = (byte)this.m_dataChainType;
                    System.arraycopy(a_buffer, a_offset, typedPacket, 1, a_length);
                    a_offset = 0;
                    a_length = typedPacket.length;
                }
                try {
                    this.m_originOutputStream.write(typedPacket, a_offset, a_length);
                    TypeFilterDataChain.this.m_firstPacket = false;
                }
                catch (TooMuchDataForPacketException e) {
                    if (TypeFilterDataChain.this.m_firstPacket) {
                        if (e.getBytesSent() > 0) {
                            TypeFilterDataChain.this.m_firstPacket = false;
                        }
                        throw new TooMuchDataForPacketException(Math.max(0, e.getBytesSent() - 1));
                    }
                    throw e;
                }
            }
        }

        public void flush() throws IOException {
            this.m_originOutputStream.flush();
        }

        public void close() throws IOException {
            this.m_originOutputStream.close();
        }
    }
}

