/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import java.io.IOException;

public final class DataChainInputStreamQueueEntry {
    public static final int TYPE_DATA_AVAILABLE = 1;
    public static final int TYPE_STREAM_END = 2;
    public static final int TYPE_IO_EXCEPTION = 3;
    private final int m_type;
    private final byte[] m_data;
    private int m_alreadyReadBytes;
    private int m_iAvailableBytes;
    private IOException m_ioException;
    protected DataChainInputStreamQueueEntry m_Next;

    public DataChainInputStreamQueueEntry(int a_type, byte[] a_data, int data_offset, int len) {
        this.m_type = a_type;
        this.m_data = a_data;
        this.m_alreadyReadBytes = data_offset;
        this.m_iAvailableBytes = len;
        this.m_ioException = null;
    }

    public DataChainInputStreamQueueEntry(int a_type, byte[] a_data) {
        this.m_type = a_type;
        this.m_data = a_data;
        this.m_alreadyReadBytes = 0;
        this.m_iAvailableBytes = a_data.length;
        this.m_ioException = null;
    }

    public DataChainInputStreamQueueEntry(int a_type) {
        this.m_type = a_type;
        this.m_data = null;
        this.m_alreadyReadBytes = 0;
        this.m_iAvailableBytes = 0;
        this.m_ioException = null;
    }

    public DataChainInputStreamQueueEntry(IOException a_exception) {
        this.m_type = 3;
        this.m_data = null;
        this.m_alreadyReadBytes = 0;
        this.m_ioException = a_exception;
        this.m_iAvailableBytes = 0;
    }

    public int getType() {
        return this.m_type;
    }

    public void getData(byte[] buff, int offset, int len) {
        System.arraycopy(this.m_data, this.m_alreadyReadBytes, buff, offset, len);
        this.m_alreadyReadBytes += len;
        this.m_iAvailableBytes -= len;
    }

    public IOException getIOException() {
        return this.m_ioException;
    }

    public int getAvailableBytes() {
        return this.m_iAvailableBytes;
    }
}

