/*
 * Decompiled with CFR 0.152.
 */
package anon.anonudp.mixmessage.crypto;

public final class MyReplayDetection {
    private int m_iLowestID = -20;
    private int m_iCurrentIDs = 0;

    public boolean isValid(byte[] counterPrefix) {
        int packetID = counterPrefix[0];
        packetID <<= 8;
        packetID |= counterPrefix[1] & 0xFF;
        packetID <<= 8;
        packetID |= counterPrefix[2] & 0xFF;
        packetID <<= 8;
        return this.isValid(packetID |= counterPrefix[3] & 0xFF);
    }

    public boolean isValid(int packetID) {
        if (packetID <= this.m_iLowestID) {
            return false;
        }
        int bitPos = packetID - this.m_iLowestID - 1;
        if (bitPos > 30) {
            int shift = bitPos - 30;
            this.m_iCurrentIDs >>= shift;
            this.m_iCurrentIDs |= 0x40000000;
            this.m_iLowestID += shift;
            return true;
        }
        int bit = 1 << bitPos;
        if ((this.m_iCurrentIDs & bit) != 0) {
            return false;
        }
        this.m_iCurrentIDs |= bit;
        this.m_iCurrentIDs >>= 1;
        ++this.m_iLowestID;
        return true;
    }
}

