/*
 * Decompiled with CFR 0.152.
 */
package infoservice.performance;

import anon.infoservice.Database;
import anon.infoservice.HttpResponseStructure;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import infoservice.performance.PerformanceRequest;
import infoservice.performance.PerformanceToken;
import infoservice.performance.PerformanceTokenRequest;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;

public class PerformanceRequestHandler {
    public static byte[] MAGIC_BYTES_IPV4 = new byte[]{73, 80, 86, 52};
    public static byte[] MAGIC_BYTES_IPV6 = new byte[]{73, 80, 86, 54};

    public HttpResponseStructure handlePerformanceTokenRequest(byte[] a_postData) {
        Document doc = null;
        PerformanceTokenRequest request = null;
        try {
            doc = XMLUtil.toXMLDocument(a_postData);
            request = new PerformanceTokenRequest(doc.getDocumentElement());
        }
        catch (XMLParseException ex) {
            LogHolder.log(4, LogType.NET, "Error while processing PerformanceTokenRequest: " + ex.getMessage());
            return new HttpResponseStructure(400);
        }
        LogHolder.log(6, LogType.NET, "InfoService " + request.getInfoServiceId() + " is requesting a performance token.");
        PerformanceToken token = new PerformanceToken();
        Database.getInstance(PerformanceToken.class).update(token);
        doc = XMLUtil.toSignedXMLDocument(token, 2);
        HttpResponseStructure httpResponse = new HttpResponseStructure(0, 0, XMLUtil.toString(doc));
        LogHolder.log(6, LogType.NET, "Token " + token.getId() + " issued.");
        return httpResponse;
    }

    public HttpResponseStructure handlePerformanceRequest(InetAddress a_address, byte[] a_postData) {
        Document doc = null;
        PerformanceRequest request = null;
        try {
            doc = XMLUtil.toXMLDocument(a_postData);
            request = new PerformanceRequest(doc.getDocumentElement());
        }
        catch (XMLParseException ex) {
            LogHolder.log(4, LogType.NET, "Error while processing PerformanceTokenRequest: " + ex.getMessage());
            return new HttpResponseStructure(400);
        }
        LogHolder.log(5, LogType.NET, "Token " + request.getTokenId() + " is requesting " + request.getDataSize() + " bytes of random data.");
        byte[] data = new byte[request.getDataSize()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = 5;
        }
        byte[] magicBytes = null;
        if (a_address instanceof Inet4Address) {
            magicBytes = MAGIC_BYTES_IPV4;
            LogHolder.log(6, LogType.NET, "IP sent to performance test: " + a_address.getHostAddress());
        } else if (a_address instanceof Inet6Address) {
            magicBytes = MAGIC_BYTES_IPV6;
        }
        if (magicBytes != null) {
            byte[] ip = a_address.getAddress();
            byte[] ip_translated = new byte[ip.length * 2];
            int i = 0;
            int j = ip.length;
            while (i < ip.length) {
                if (ip[i] > 0) {
                    ip_translated[i] = ip[i];
                    ip_translated[j] = 0;
                } else {
                    ip_translated[i] = (byte)(ip[i] ^ 0xFFFFFF80);
                    ip_translated[j] = 1;
                }
                ++i;
                ++j;
            }
            System.arraycopy(magicBytes, 0, data, 0, magicBytes.length);
            System.arraycopy(ip_translated, 0, data, magicBytes.length, ip_translated.length);
        }
        HttpResponseStructure httpResponse = new HttpResponseStructure(0, 0, data);
        LogHolder.log(6, LogType.NET, data.length + " bytes sent. Removed token.");
        Database.getInstance(PerformanceToken.class).remove(request.getTokenId());
        return httpResponse;
    }
}

