/*
 * Decompiled with CFR 0.152.
 */
package infoservice.mailsystem.central;

import infoservice.mailsystem.central.MailHandler;
import infoservice.mailsystem.central.server.AbstractServerImplementation;
import infoservice.mailsystem.central.server.util.LimitedLengthInputStream;
import logging.LogHolder;
import logging.LogType;

public class MailSystemServerImplementation
extends AbstractServerImplementation {
    @Override
    protected void handleClientRequest() {
        try {
            this.getSocketContainer().setSocketTimeout(10000);
            LimitedLengthInputStream requestStream = new LimitedLengthInputStream(this.getSocketContainer().getInputStream(), 100000L);
            LogHolder.log(7, LogType.MISC, "MailSystemServerImplementation: handleClientRequest: Reading the request mail...");
            MailHandler mailHandler = new MailHandler(requestStream);
            LogHolder.log(7, LogType.MISC, "MailSystemServerImplementation: handleClientRequest: Request mail read. Creating reply...");
            mailHandler.createReply();
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.MISC, "MailSystemServerImplementation: handleClientRequest: Error occured while responding to received mail: " + e.toString());
        }
    }
}

