/*
 * Decompiled with CFR 0.152.
 */
package infoservice.dynamic;

import infoservice.agreement.IInfoServiceAgreementAdapter;
import infoservice.agreement.multicast.InfoserviceEMCAdapter;
import infoservice.dynamic.ComleteRandomStrategy;
import infoservice.dynamic.IDynamicCascadeBuildingStrategy;
import java.util.Properties;
import logging.LogHolder;
import logging.LogType;

public class DynamicConfiguration {
    private long m_emcGlobalTimeout = 100000L;
    private long m_agreementPhaseGap = 25000L;
    private long m_emcConsensusLogTimeout = 65000L;
    private long m_paxosRoundTimeout = 30000L;
    private int m_minCascadeLength = 2;
    private int m_maxCascadeLength = 3;
    private int m_hourOfAgreement = 15;
    private long m_passivePhaseLength = 60000L;
    private IInfoServiceAgreementAdapter m_agreementAdapter;
    private IDynamicCascadeBuildingStrategy m_cascadeBuildingStrategy;
    private int m_agreementLogLevel = 7;
    private static final DynamicConfiguration m_instance = new DynamicConfiguration();
    private boolean m_bConfigured = false;

    public static DynamicConfiguration getInstance() {
        return m_instance;
    }

    private DynamicConfiguration() {
    }

    public void readConfiguration(Properties a_properties) {
        String strategy;
        this.m_emcGlobalTimeout = this.parseLong(a_properties.getProperty("emcGlobalTimeout"), 100000L);
        this.m_passivePhaseLength = this.parseLong(a_properties.getProperty("passivePhaseLength"), 60000L);
        this.m_agreementPhaseGap = this.parseLong(a_properties.getProperty("agreementPhaseGap"), 25000L);
        this.m_emcConsensusLogTimeout = this.parseLong(a_properties.getProperty("emcConsensusLogTimeout"), 65000L);
        this.m_paxosRoundTimeout = this.parseLong(a_properties.getProperty("paxosRoundTimeout"), 30000L);
        this.m_minCascadeLength = this.parseInt(a_properties.getProperty("minCascadeLength"), 2);
        this.m_maxCascadeLength = this.parseInt(a_properties.getProperty("maxCascadeLength"), 3);
        this.m_hourOfAgreement = this.parseInt(a_properties.getProperty("hourOfAgreement"), 15);
        String logLevel = a_properties.getProperty("logLevel");
        this.m_agreementLogLevel = this.parseLogLevel(logLevel);
        String handler = a_properties.getProperty("agreementMethod");
        if (handler != null) {
            try {
                this.m_agreementAdapter = (IInfoServiceAgreementAdapter)Class.forName(handler.trim()).newInstance();
            }
            catch (Exception e) {
                LogHolder.log(4, LogType.AGREEMENT, "Unable to instanciate agreement handler of type " + handler + ", using default");
                this.m_agreementAdapter = new InfoserviceEMCAdapter();
            }
        } else {
            this.m_agreementAdapter = new InfoserviceEMCAdapter();
        }
        if ((strategy = a_properties.getProperty("cascadeBuildingStrategy")) != null) {
            try {
                this.m_cascadeBuildingStrategy = (IDynamicCascadeBuildingStrategy)Class.forName(strategy.trim()).newInstance();
            }
            catch (Exception e) {
                LogHolder.log(4, LogType.AGREEMENT, "Unable to instanciate cascade building strategy of type " + strategy + ", using default");
                this.m_cascadeBuildingStrategy = new ComleteRandomStrategy();
            }
        } else {
            this.m_cascadeBuildingStrategy = new ComleteRandomStrategy();
        }
        this.m_bConfigured = true;
    }

    public boolean isConfigured() {
        return this.m_bConfigured;
    }

    private int parseLogLevel(String logLevel) {
        if ("DEBUG".equals(logLevel)) {
            return 7;
        }
        if ("INFO".equals(logLevel)) {
            return 6;
        }
        if ("ERROR".equals(logLevel)) {
            return 3;
        }
        if ("FATAL".equals(logLevel)) {
            return 0;
        }
        return 7;
    }

    public IInfoServiceAgreementAdapter getAgreementHandler() {
        return this.m_agreementAdapter;
    }

    public long getAgreementPhaseGap() {
        return this.m_agreementPhaseGap;
    }

    public long getEmcConsensusLogTimeout() {
        return this.m_emcConsensusLogTimeout;
    }

    public long getEmcGlobalTimeout() {
        return this.m_emcGlobalTimeout;
    }

    public long getPaxosRoundTimeout() {
        return this.m_paxosRoundTimeout;
    }

    public int getMaxCascadeLength() {
        return this.m_maxCascadeLength;
    }

    public int getMinCascadeLength() {
        return this.m_minCascadeLength;
    }

    private long parseLong(String a_str, long a_default) {
        long result = a_default;
        try {
            result = Long.parseLong(a_str.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private int parseInt(String a_str, int a_default) {
        int result = a_default;
        try {
            result = Integer.parseInt(a_str.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public int getHourOfAgreement() {
        return this.m_hourOfAgreement;
    }

    public IDynamicCascadeBuildingStrategy getCascadeBuildingStrategy() {
        return this.m_cascadeBuildingStrategy;
    }

    public long getPassivePhaseLength() {
        return this.m_passivePhaseLength;
    }

    public int getAgreementLogLevel() {
        return this.m_agreementLogLevel;
    }
}

