/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.paxos.integration;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import anon.infoservice.Database;
import anon.infoservice.HTTPConnectionFactory;
import anon.infoservice.HttpResponseStructure;
import anon.infoservice.IDistributable;
import anon.infoservice.InfoServiceDBEntry;
import anon.infoservice.ListenerInterface;
import anon.infoservice.ServiceSoftware;
import infoservice.Configuration;
import infoservice.InfoServiceDistributor;
import infoservice.agreement.IInfoServiceAgreementAdapter;
import infoservice.agreement.logging.AgreementFileLog;
import infoservice.agreement.paxos.IPaxosTarget;
import infoservice.agreement.paxos.integration.InfoServiceCollectMessage;
import infoservice.agreement.paxos.integration.InfoServiceFreezeProofMessage;
import infoservice.agreement.paxos.integration.InfoServiceMessageFactory;
import infoservice.agreement.paxos.integration.InfoServicePaxosMessage;
import infoservice.agreement.paxos.integration.InfoServicePaxosTarget;
import infoservice.agreement.paxos.integration.PaxosAdapter;
import infoservice.agreement.paxos.messages.CollectMessage;
import infoservice.agreement.paxos.messages.FreezeProofMessage;
import infoservice.agreement.paxos.messages.PaxosMessage;
import infoservice.dynamic.DynamicCascadeConfigurator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class InfoServicePaxosAdapter
extends PaxosAdapter
implements IInfoServiceAgreementAdapter {
    private DynamicCascadeConfigurator m_dynamicMixConfigurator = new DynamicCascadeConfigurator();
    InfoServiceDBEntry m_self;

    public InfoServicePaxosAdapter() {
        InfoServicePaxosAdapter.setLog(new AgreementFileLog());
        this.m_self = this.generateInfoServiceSelf();
        this.m_lastRandom = "0000000000";
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException e) {
                    InfoServicePaxosAdapter.this.error("Unable to sleep in thread");
                }
                InfoServiceDBEntry generatedOwnEntry = InfoServicePaxosAdapter.this.generateInfoServiceSelf();
                Database.getInstance(InfoServiceDBEntry.class).update(generatedOwnEntry);
                InfoServiceDistributor.getInstance().addJobToInititalNeighboursQueue(generatedOwnEntry);
                InfoServicePaxosAdapter.this.info("Now we are ready to start the agreement");
            }
        }.start();
    }

    @Override
    protected void prepareTargets() {
        this.m_targets = new Hashtable();
        this.info("OWN ID IS: " + this.m_self.getId());
        Enumeration en = Database.getInstance(InfoServiceDBEntry.class).getEntrySnapshotAsEnumeration();
        while (en.hasMoreElements()) {
            InfoServiceDBEntry entry = (InfoServiceDBEntry)en.nextElement();
            InfoServicePaxosTarget tmp = new InfoServicePaxosTarget(entry);
            if (!entry.checkId() && !this.m_self.equals(entry)) {
                this.info("Discarting " + entry.getId() + " because its a dummy");
                continue;
            }
            this.info("Using InfoService " + entry.getId());
            this.m_targets.put(tmp.getId(), tmp);
        }
    }

    InfoServiceDBEntry generateInfoServiceSelf() {
        Vector<ListenerInterface> virtualListeners = Configuration.getInstance().getVirtualListeners();
        return new InfoServiceDBEntry(Configuration.getInstance().getOwnName(), Configuration.getInstance().getID(), virtualListeners, Configuration.getInstance().holdForwarderList(), false, System.currentTimeMillis(), System.currentTimeMillis(), Configuration.getInstance().isPerfServerEnabled(), new ServiceSoftware("IS.09.010"));
    }

    @Override
    public HttpResponseStructure handleMessage(byte[] a_postData) {
        PaxosMessage msg = InfoServiceMessageFactory.decode(a_postData);
        this.handleIncommingMessage(msg);
        return new HttpResponseStructure(200);
    }

    @Override
    protected String getIdentifier() {
        return this.m_self.getId();
    }

    @Override
    public void sendMessage(final PaxosMessage a_msg, final IPaxosTarget a_target) {
        new Thread(){

            @Override
            public void run() {
                InfoServiceDBEntry entry = ((InfoServicePaxosTarget)a_target).getInfoService();
                IDistributable msg = null;
                msg = a_msg instanceof CollectMessage ? new InfoServiceCollectMessage((CollectMessage)a_msg) : (a_msg instanceof FreezeProofMessage ? new InfoServiceFreezeProofMessage((FreezeProofMessage)a_msg) : new InfoServicePaxosMessage(a_msg));
                InfoServicePaxosAdapter.this.sendToInfoService(entry, msg);
            }
        }.start();
    }

    protected boolean sendToInfoService(InfoServiceDBEntry a_infoservice, IDistributable a_message) {
        boolean connected = false;
        if (a_infoservice == null) {
            return false;
        }
        Enumeration enumer = a_infoservice.getListenerInterfaces().elements();
        while (enumer.hasMoreElements() && !connected) {
            ListenerInterface currentInterface = (ListenerInterface)enumer.nextElement();
            if (!currentInterface.isValid()) continue;
            if (this.sendToInterface(currentInterface, a_message)) {
                connected = true;
                continue;
            }
            currentInterface.setUseInterface(false);
        }
        return connected;
    }

    private boolean sendToInterface(ListenerInterface a_listener, IDistributable a_message) {
        boolean connected = true;
        HTTPConnection connection = null;
        try {
            connection = HTTPConnectionFactory.getInstance().createHTTPConnection(a_listener, a_message.getPostEncoding(), false);
            HTTPResponse response = connection.Post(a_message.getPostFile(), a_message.getPostData());
            int statusCode = response.getStatusCode();
            connected = statusCode >= 200 && statusCode <= 299;
        }
        catch (Exception e) {
            LogHolder.log(0, LogType.NET, "ERROR WHILE SENDING TO " + connection.getHost() + ":" + connection.getPort() + ": " + e.toString());
            connected = false;
        }
        if (connection != null) {
            connection.stop();
        }
        return connected;
    }

    @Override
    protected void useAgreement(long a_agreement) {
        this.m_dynamicMixConfigurator.buildCascades(a_agreement);
    }

    @Override
    public void multicast(PaxosMessage a_msg) {
        IDistributable tmp = null;
        tmp = a_msg instanceof CollectMessage ? new InfoServiceCollectMessage((CollectMessage)a_msg) : (a_msg instanceof FreezeProofMessage ? new InfoServiceFreezeProofMessage((FreezeProofMessage)a_msg) : new InfoServicePaxosMessage(a_msg));
        final InfoServiceCollectMessage msg = tmp;
        msg.getPostData();
        Enumeration en = this.m_targets.keys();
        while (en.hasMoreElements()) {
            IPaxosTarget target = (IPaxosTarget)this.m_targets.get(en.nextElement());
            final InfoServiceDBEntry entry = ((InfoServicePaxosTarget)target).getInfoService();
            new Thread(){

                @Override
                public void run() {
                    InfoServicePaxosAdapter.this.sendToInfoService(entry, msg);
                }
            }.start();
        }
    }
}

