/*
 * Decompiled with CFR 0.152.
 */
package infoservice;

import anon.infoservice.Database;
import anon.infoservice.InfoServiceDBEntry;
import anon.infoservice.InfoServiceHolder;
import anon.infoservice.MixCascade;
import anon.infoservice.MixCascadeExitAddresses;
import anon.infoservice.MixInfo;
import anon.infoservice.PerformanceInfo;
import anon.infoservice.StatusInfo;
import anon.infoservice.update.InfoServiceUpdater;
import anon.pay.PaymentInstanceDBEntry;
import anon.util.Updater;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import infoservice.Configuration;
import infoservice.PassiveInfoServiceMainUpdater;
import infoservice.PassiveInfoServiceStatusUpdater;
import java.io.File;
import java.io.IOException;
import java.util.Observable;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;

public class PassiveInfoServiceInitializer {
    private static final String LOAD_ERROR = "Could not load the cachefile for the passive InfoService";
    private static final String PARSE_ERROR = "Could not parse the cachefile for the passive InfoService";
    private static final String CACHE_ERROR = "DB caching failed.";
    private static final Class[] CACHE_CLASSES = new Class[]{MixCascade.class, MixCascadeExitAddresses.class, PerformanceInfo.class, StatusInfo.class, InfoServiceDBEntry.class, MixInfo.class, PaymentInstanceDBEntry.class};
    public static String CACHE_FILE_NAME = "cache.xml";
    private static InfoServiceUpdater infoServiceUpdater = null;
    private static PassiveInfoServiceStatusUpdater statusUpdater = null;
    private static PassiveInfoServiceGlobalUpdater globalUpdater = null;
    private static final int GLOBAL_UPDATE_INTERVAL = 60000;
    private static final long UPDATE_SYNC_INTERVAL = 4000L;

    public static synchronized void init() throws IOException {
        Document doc = null;
        try {
            File fileCache = new File(CACHE_FILE_NAME);
            if (fileCache.exists() && (doc = XMLUtil.readXMLDocument(new File(CACHE_FILE_NAME))) != null) {
                Database.restoreFromXML(doc, CACHE_CLASSES);
            }
        }
        catch (IOException e) {
            LogHolder.log(6, LogType.MISC, LOAD_ERROR, e);
            e.printStackTrace();
        }
        catch (XMLParseException e) {
            LogHolder.log(6, LogType.MISC, PARSE_ERROR, e);
            e.printStackTrace();
        }
        InfoServiceHolder.getInstance().setNumberOfAskedInfoServices(4);
        Updater.ObservableInfo observableInfo = new Updater.ObservableInfo(new Observable()){

            @Override
            public Integer getUpdateChanged() {
                return new Integer(0);
            }

            @Override
            public boolean isUpdateDisabled() {
                return false;
            }
        };
        infoServiceUpdater = new InfoServiceUpdater(observableInfo);
        statusUpdater = new PassiveInfoServiceStatusUpdater(observableInfo);
        globalUpdater = new PassiveInfoServiceGlobalUpdater(observableInfo);
        infoServiceUpdater.updateAsync(null);
        statusUpdater.updateAsync(null);
        globalUpdater.start();
    }

    public static synchronized void shutdown() {
        globalUpdater.interrupt();
    }

    private static void cacheDB() {
        Document doc = Database.dumpToXML(CACHE_CLASSES);
        if (doc != null) {
            File cacheFile = new File(CACHE_FILE_NAME);
            try {
                XMLUtil.write(doc, cacheFile);
            }
            catch (IOException ioe) {
                LogHolder.log(6, LogType.MISC, CACHE_ERROR, ioe);
            }
        } else {
            LogHolder.log(6, LogType.MISC, CACHE_ERROR);
        }
    }

    private static class PassiveInfoServiceGlobalUpdater
    extends Thread {
        private static PassiveInfoServiceMainUpdater mainUpdater = null;

        PassiveInfoServiceGlobalUpdater(Updater.ObservableInfo a_observableInfo) throws IOException {
            mainUpdater = new PassiveInfoServiceMainUpdater(!Configuration.getInstance().isPerfEnabled(), a_observableInfo);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    mainUpdater.update();
                    Thread.sleep(4000L);
                    PassiveInfoServiceInitializer.cacheDB();
                    Thread.sleep(60000L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

