/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.CertPath;
import anon.crypto.CertificateInfoStructure;
import anon.crypto.JAPCertificate;
import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CertificateContainer
implements IXMLEncodable {
    public static final String XML_ELEMENT_NAME = "CertificateContainer";
    private static final String XML_ATTR_REMOVABLE = "removable";
    private JAPCertificate m_parentCertificate;
    private CertPath m_certPath;
    private int m_certificateType;
    private boolean m_enabled;
    private boolean m_certificateNeedsVerification;
    private boolean m_onlyHardRemovable;
    private boolean m_bNotRemovable = false;
    private Vector m_lockList;

    public CertificateContainer(CertPath a_certPath, int a_certificateType, boolean a_certificateNeedsVerification) {
        if (a_certPath == null || a_certPath.getFirstCertificate() == null) {
            throw new IllegalArgumentException("Invalid cert path!");
        }
        this.m_certPath = a_certPath;
        this.m_certificateType = a_certificateType;
        this.m_certificateNeedsVerification = a_certificateNeedsVerification;
        this.m_enabled = true;
        this.m_parentCertificate = null;
        this.m_onlyHardRemovable = false;
        this.m_bNotRemovable = false;
        this.m_lockList = new Vector();
    }

    public CertificateContainer(Element a_certificateContainerNode) throws Exception {
        Element certificateTypeNode = (Element)XMLUtil.getFirstChildByName(a_certificateContainerNode, "CertificateType");
        if (certificateTypeNode == null) {
            throw new Exception("No CertificateType node found.");
        }
        this.m_certificateType = XMLUtil.parseValue((Node)certificateTypeNode, -1);
        if (this.m_certificateType == -1) {
            throw new Exception("Invalid CertificateType value.");
        }
        Element certificateNeedsVerificationNode = (Element)XMLUtil.getFirstChildByName(a_certificateContainerNode, "CertificateNeedsVerification");
        if (certificateNeedsVerificationNode == null) {
            throw new Exception("No CertificateNeedsVerification node found.");
        }
        this.m_certificateNeedsVerification = XMLUtil.parseValue((Node)certificateNeedsVerificationNode, true);
        Element certificateEnabledNode = (Element)XMLUtil.getFirstChildByName(a_certificateContainerNode, "CertificateEnabled");
        if (certificateEnabledNode == null) {
            throw new Exception("No CertificateEnabled node found.");
        }
        this.m_enabled = XMLUtil.parseValue((Node)certificateEnabledNode, false);
        Element certificateDataNode = (Element)XMLUtil.getFirstChildByName(a_certificateContainerNode, "CertificateData");
        if (certificateDataNode == null) {
            throw new Exception("No CertificateData node found.");
        }
        JAPCertificate certificate = JAPCertificate.getInstance(XMLUtil.getFirstChildByName(certificateDataNode, "X509Certificate"));
        if (certificate == null) {
            this.m_certPath = new CertPath((Element)XMLUtil.getFirstChildByName(certificateDataNode, "CertPath"));
        }
        this.m_parentCertificate = null;
        this.m_onlyHardRemovable = true;
        this.m_bNotRemovable = !XMLUtil.parseAttribute((Node)a_certificateContainerNode, XML_ATTR_REMOVABLE, false);
        this.m_lockList = new Vector();
    }

    public JAPCertificate getCertificate() {
        return this.m_certPath.getFirstCertificate();
    }

    public CertPath getCertPath() {
        return this.m_certPath;
    }

    public void setParentCertificate(JAPCertificate a_parentCertificate) {
        this.m_parentCertificate = a_parentCertificate;
    }

    public JAPCertificate getParentCertificate() {
        return this.m_parentCertificate;
    }

    public int getCertificateType() {
        return this.m_certificateType;
    }

    public boolean getCertificateNeedsVerification() {
        return this.m_certificateNeedsVerification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable() {
        boolean returnValue = false;
        CertificateContainer certificateContainer = this;
        synchronized (certificateContainer) {
            returnValue = (!this.m_certificateNeedsVerification || this.m_parentCertificate != null) && this.m_enabled;
        }
        return returnValue;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean a_enabled) {
        this.m_enabled = a_enabled;
        this.m_certPath.resetVerification();
    }

    public void enableOnlyHardRemovable() {
        this.m_onlyHardRemovable = true;
    }

    public boolean isOnlyHardRemovable() {
        return this.m_onlyHardRemovable;
    }

    public void enableNotRemovable() {
        this.m_bNotRemovable = true;
    }

    public boolean isNotRemovable() {
        return this.m_bNotRemovable;
    }

    public Vector getLockList() {
        return this.m_lockList;
    }

    public CertificateInfoStructure getInfoStructure() {
        return new CertificateInfoStructure(this.m_certPath, this.m_parentCertificate, this.m_certificateType, this.m_enabled, this.m_certificateNeedsVerification, this.m_onlyHardRemovable, this.m_bNotRemovable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element toXmlElement(Document a_doc) {
        Element certificateContainerNode = a_doc.createElement(XML_ELEMENT_NAME);
        CertificateContainer certificateContainer = this;
        synchronized (certificateContainer) {
            XMLUtil.setAttribute(certificateContainerNode, XML_ATTR_REMOVABLE, !this.m_bNotRemovable);
            Element certificateTypeNode = a_doc.createElement("CertificateType");
            XMLUtil.setValue((Node)certificateTypeNode, this.m_certificateType);
            Element certificateNeedsVerificationNode = a_doc.createElement("CertificateNeedsVerification");
            XMLUtil.setValue((Node)certificateNeedsVerificationNode, this.m_certificateNeedsVerification);
            Element certificateEnabledNode = a_doc.createElement("CertificateEnabled");
            XMLUtil.setValue((Node)certificateEnabledNode, this.m_enabled);
            Element certificateDataNode = a_doc.createElement("CertificateData");
            certificateDataNode.appendChild(this.m_certPath.toXmlElement(a_doc));
            certificateContainerNode.appendChild(certificateTypeNode);
            certificateContainerNode.appendChild(certificateNeedsVerificationNode);
            certificateContainerNode.appendChild(certificateEnabledNode);
            certificateContainerNode.appendChild(certificateDataNode);
        }
        return certificateContainerNode;
    }

    public boolean equals(Object a_certificateContainer) {
        if (this == a_certificateContainer) {
            return true;
        }
        if (a_certificateContainer == null || !(a_certificateContainer instanceof CertificateContainer)) {
            return false;
        }
        return this.m_certPath.getFirstCertificate().getId().equals(((CertificateContainer)a_certificateContainer).getCertificate().getId());
    }

    public String getId() {
        return this.m_certPath.getFirstCertificate().getId();
    }

    public int hashCode() {
        return this.m_certPath.getFirstCertificate().hashCode();
    }
}

